/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.languagemodel;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Ignore;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.languagemodel.LanguageModelTest;
import org.languagetool.languagemodel.LuceneLanguageModel;

public class LuceneSingleIndexLanguageModelTest
extends LanguageModelTest {
    @Test
    public void testLanguageModel() throws Exception {
        URL ngramUrl = JLanguageTool.getDataBroker().getFromResourceDirAsUrl("/yy/ngram-index");
        try (LuceneLanguageModel model = new LuceneLanguageModel(new File(ngramUrl.toURI()));){
            MatcherAssert.assertThat((Object)model.getCount("the"), (Matcher)CoreMatchers.is((Object)55L));
            MatcherAssert.assertThat((Object)model.getCount(Arrays.asList("the", "nice")), (Matcher)CoreMatchers.is((Object)3L));
            MatcherAssert.assertThat((Object)model.getCount(Arrays.asList("the", "nice", "building")), (Matcher)CoreMatchers.is((Object)1L));
            MatcherAssert.assertThat((Object)model.getCount("not-in-here"), (Matcher)CoreMatchers.is((Object)0L));
            MatcherAssert.assertThat((Object)model.getTotalTokenCount(), (Matcher)CoreMatchers.is((Object)3L));
        }
    }

    @Test
    @Ignore(value="for interactive use only")
    public void testPerformance() throws Exception {
        LuceneLanguageModel model = new LuceneLanguageModel(new File("/data/google-gram-index/"));
        super.testPerformance(model, 3);
    }
}

