/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.References;

public abstract class AnyObjectId
implements Comparable<AnyObjectId> {
    int w1;
    int w2;
    int w3;
    int w4;
    int w5;
    private static final byte[] hexbyte = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final char[] hexchar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @Deprecated
    public static boolean equals(AnyObjectId firstObjectId, AnyObjectId secondObjectId) {
        return AnyObjectId.isEqual(firstObjectId, secondObjectId);
    }

    public static boolean isEqual(AnyObjectId firstObjectId, AnyObjectId secondObjectId) {
        if (References.isSameObject(firstObjectId, secondObjectId)) {
            return true;
        }
        return firstObjectId.w3 == secondObjectId.w3 && firstObjectId.w4 == secondObjectId.w4 && firstObjectId.w5 == secondObjectId.w5 && firstObjectId.w1 == secondObjectId.w1 && firstObjectId.w2 == secondObjectId.w2;
    }

    public final int getFirstByte() {
        return this.w1 >>> 24;
    }

    public final int getByte(int index) {
        int w;
        switch (index >> 2) {
            case 0: {
                w = this.w1;
                break;
            }
            case 1: {
                w = this.w2;
                break;
            }
            case 2: {
                w = this.w3;
                break;
            }
            case 3: {
                w = this.w4;
                break;
            }
            case 4: {
                w = this.w5;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(index);
            }
        }
        return w >>> 8 * (3 - (index & 3)) & 0xFF;
    }

    @Override
    public final int compareTo(AnyObjectId other) {
        if (this == other) {
            return 0;
        }
        int cmp = NB.compareUInt32(this.w1, other.w1);
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt32(this.w2, other.w2);
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt32(this.w3, other.w3);
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt32(this.w4, other.w4);
        if (cmp != 0) {
            return cmp;
        }
        return NB.compareUInt32(this.w5, other.w5);
    }

    public final int compareTo(byte[] bs, int p) {
        int cmp = NB.compareUInt32(this.w1, NB.decodeInt32(bs, p));
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt32(this.w2, NB.decodeInt32(bs, p + 4));
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt32(this.w3, NB.decodeInt32(bs, p + 8));
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt32(this.w4, NB.decodeInt32(bs, p + 12));
        if (cmp != 0) {
            return cmp;
        }
        return NB.compareUInt32(this.w5, NB.decodeInt32(bs, p + 16));
    }

    public final int compareTo(int[] bs, int p) {
        int cmp = NB.compareUInt32(this.w1, bs[p]);
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt32(this.w2, bs[p + 1]);
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt32(this.w3, bs[p + 2]);
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt32(this.w4, bs[p + 3]);
        if (cmp != 0) {
            return cmp;
        }
        return NB.compareUInt32(this.w5, bs[p + 4]);
    }

    public boolean startsWith(AbbreviatedObjectId abbr) {
        return abbr.prefixCompare(this) == 0;
    }

    public final int hashCode() {
        return this.w2;
    }

    public final boolean equals(AnyObjectId other) {
        return other != null ? AnyObjectId.isEqual(this, other) : false;
    }

    public final boolean equals(Object o) {
        if (o instanceof AnyObjectId) {
            return this.equals((AnyObjectId)o);
        }
        return false;
    }

    public void copyRawTo(ByteBuffer w) {
        w.putInt(this.w1);
        w.putInt(this.w2);
        w.putInt(this.w3);
        w.putInt(this.w4);
        w.putInt(this.w5);
    }

    public void copyRawTo(byte[] b, int o) {
        NB.encodeInt32(b, o, this.w1);
        NB.encodeInt32(b, o + 4, this.w2);
        NB.encodeInt32(b, o + 8, this.w3);
        NB.encodeInt32(b, o + 12, this.w4);
        NB.encodeInt32(b, o + 16, this.w5);
    }

    public void copyRawTo(int[] b, int o) {
        b[o] = this.w1;
        b[o + 1] = this.w2;
        b[o + 2] = this.w3;
        b[o + 3] = this.w4;
        b[o + 4] = this.w5;
    }

    public void copyRawTo(OutputStream w) throws IOException {
        AnyObjectId.writeRawInt(w, this.w1);
        AnyObjectId.writeRawInt(w, this.w2);
        AnyObjectId.writeRawInt(w, this.w3);
        AnyObjectId.writeRawInt(w, this.w4);
        AnyObjectId.writeRawInt(w, this.w5);
    }

    private static void writeRawInt(OutputStream w, int v) throws IOException {
        w.write(v >>> 24);
        w.write(v >>> 16);
        w.write(v >>> 8);
        w.write(v);
    }

    public void copyTo(OutputStream w) throws IOException {
        w.write(this.toHexByteArray());
    }

    public void copyTo(byte[] b, int o) {
        AnyObjectId.formatHexByte(b, o + 0, this.w1);
        AnyObjectId.formatHexByte(b, o + 8, this.w2);
        AnyObjectId.formatHexByte(b, o + 16, this.w3);
        AnyObjectId.formatHexByte(b, o + 24, this.w4);
        AnyObjectId.formatHexByte(b, o + 32, this.w5);
    }

    public void copyTo(ByteBuffer b) {
        b.put(this.toHexByteArray());
    }

    private byte[] toHexByteArray() {
        byte[] dst = new byte[40];
        AnyObjectId.formatHexByte(dst, 0, this.w1);
        AnyObjectId.formatHexByte(dst, 8, this.w2);
        AnyObjectId.formatHexByte(dst, 16, this.w3);
        AnyObjectId.formatHexByte(dst, 24, this.w4);
        AnyObjectId.formatHexByte(dst, 32, this.w5);
        return dst;
    }

    private static void formatHexByte(byte[] dst, int p, int w) {
        int o = p + 7;
        while (o >= p && w != 0) {
            dst[o--] = hexbyte[w & 0xF];
            w >>>= 4;
        }
        while (o >= p) {
            dst[o--] = 48;
        }
    }

    public void copyTo(Writer w) throws IOException {
        w.write(this.toHexCharArray());
    }

    public void copyTo(char[] tmp, Writer w) throws IOException {
        this.toHexCharArray(tmp);
        w.write(tmp, 0, 40);
    }

    public void copyTo(char[] tmp, StringBuilder w) {
        this.toHexCharArray(tmp);
        w.append(tmp, 0, 40);
    }

    private char[] toHexCharArray() {
        char[] dst = new char[40];
        this.toHexCharArray(dst);
        return dst;
    }

    private void toHexCharArray(char[] dst) {
        AnyObjectId.formatHexChar(dst, 0, this.w1);
        AnyObjectId.formatHexChar(dst, 8, this.w2);
        AnyObjectId.formatHexChar(dst, 16, this.w3);
        AnyObjectId.formatHexChar(dst, 24, this.w4);
        AnyObjectId.formatHexChar(dst, 32, this.w5);
    }

    static void formatHexChar(char[] dst, int p, int w) {
        int o = p + 7;
        while (o >= p && w != 0) {
            dst[o--] = hexchar[w & 0xF];
            w >>>= 4;
        }
        while (o >= p) {
            dst[o--] = 48;
        }
    }

    public String toString() {
        return "AnyObjectId[" + this.name() + "]";
    }

    public final String name() {
        return new String(this.toHexCharArray());
    }

    public final String getName() {
        return this.name();
    }

    public AbbreviatedObjectId abbreviate(int len) {
        int a = AbbreviatedObjectId.mask(len, 1, this.w1);
        int b = AbbreviatedObjectId.mask(len, 2, this.w2);
        int c = AbbreviatedObjectId.mask(len, 3, this.w3);
        int d = AbbreviatedObjectId.mask(len, 4, this.w4);
        int e = AbbreviatedObjectId.mask(len, 5, this.w5);
        return new AbbreviatedObjectId(len, a, b, c, d, e);
    }

    public final ObjectId copy() {
        if (this.getClass() == ObjectId.class) {
            return (ObjectId)this;
        }
        return new ObjectId(this);
    }

    public abstract ObjectId toObjectId();
}

