/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.generation;

import org.apache.groovy.contracts.domain.Precondition;
import org.apache.groovy.contracts.generation.BaseGenerator;
import org.apache.groovy.contracts.util.AnnotationUtils;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.io.ReaderSource;

public class PreconditionGenerator
extends BaseGenerator {
    public PreconditionGenerator(ReaderSource source) {
        super(source);
    }

    public void generatePreconditionAssertionStatement(MethodNode method, Precondition precondition) {
        BooleanExpression preconditionBooleanExpression = this.addCallsToSuperMethodNodeAnnotationClosure(method.getDeclaringClass(), method, org.apache.groovy.contracts.annotations.meta.Precondition.class, precondition.booleanExpression(), false);
        BlockStatement originalBlockStatement = precondition.originalBlockStatement();
        boolean useExecutionTracker = originalBlockStatement == null || Boolean.TRUE.equals(originalBlockStatement.getNodeMetaData((Object)"org.apache.groovy.contracts.META_DATA.USE_EXECUTION_TRACKER"));
        BlockStatement blockStatement = !useExecutionTracker && Boolean.TRUE.equals(method.getNodeMetaData((Object)"org.apache.groovy.contracts.USE_INLINE_MODE")) ? this.getInlineModeBlockStatement(precondition.originalBlockStatement()) : this.wrapAssertionBooleanExpression(method.getDeclaringClass(), method, preconditionBooleanExpression, "precondition");
        this.addPrecondition(method, blockStatement);
    }

    public void generateDefaultPreconditionStatement(ClassNode type, MethodNode methodNode) {
        boolean isAnotherPreconditionAvailable;
        boolean bl = isAnotherPreconditionAvailable = AnnotationUtils.getAnnotationNodeInHierarchyWithMetaAnnotation(type.getSuperClass(), methodNode, ClassHelper.makeWithoutCaching(org.apache.groovy.contracts.annotations.meta.Precondition.class)).size() > 0;
        if (!isAnotherPreconditionAvailable) {
            return;
        }
        BooleanExpression preconditionBooleanExpression = GeneralUtils.boolX((Expression)ConstantExpression.FALSE);
        if ((preconditionBooleanExpression = this.addCallsToSuperMethodNodeAnnotationClosure(type, methodNode, org.apache.groovy.contracts.annotations.meta.Precondition.class, preconditionBooleanExpression, false)).getExpression() == ConstantExpression.FALSE) {
            return;
        }
        BlockStatement blockStatement = this.wrapAssertionBooleanExpression(type, methodNode, preconditionBooleanExpression, "precondition");
        this.addPrecondition(methodNode, blockStatement);
    }

    private void addPrecondition(MethodNode method, BlockStatement blockStatement) {
        BlockStatement modifiedMethodCode = new BlockStatement();
        modifiedMethodCode.addStatements(blockStatement.getStatements());
        if (method.getCode() instanceof BlockStatement) {
            BlockStatement methodBlock = (BlockStatement)method.getCode();
            for (Statement statement : methodBlock.getStatements()) {
                if (method instanceof ConstructorNode && statement instanceof ExpressionStatement && ((ExpressionStatement)statement).getExpression() instanceof ConstructorCallExpression) {
                    modifiedMethodCode.getStatements().add(0, statement);
                    continue;
                }
                modifiedMethodCode.getStatements().add(statement);
            }
        } else {
            modifiedMethodCode.addStatement(method.getCode());
        }
        method.setCode((Statement)modifiedMethodCode);
    }
}

