/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.commonscompress.archivers.zip;

import coursierapi.shaded.commonscompress.archivers.zip.ZipArchiveEntry;
import coursierapi.shaded.commonscompress.archivers.zip.ZipMethod;
import java.io.Serializable;
import java.util.zip.ZipException;

public class UnsupportedZipFeatureException
extends ZipException {
    private final Feature reason;
    private final transient ZipArchiveEntry entry;

    public UnsupportedZipFeatureException(Feature reason, ZipArchiveEntry entry) {
        super("Unsupported feature " + reason + " used in entry " + entry.getName());
        this.reason = reason;
        this.entry = entry;
    }

    public UnsupportedZipFeatureException(ZipMethod method, ZipArchiveEntry entry) {
        super("Unsupported compression method " + entry.getMethod() + " (" + method.name() + ") used in entry " + entry.getName());
        this.reason = Feature.METHOD;
        this.entry = entry;
    }

    public static class Feature
    implements Serializable {
        public static final Feature ENCRYPTION = new Feature("encryption");
        public static final Feature METHOD = new Feature("compression method");
        public static final Feature DATA_DESCRIPTOR = new Feature("data descriptor");
        public static final Feature SPLITTING = new Feature("splitting");
        public static final Feature UNKNOWN_COMPRESSED_SIZE = new Feature("unknown compressed size");
        private final String name;

        private Feature(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

