/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import pcgen.base.util.Indirect;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Reducible;
import pcgen.cdom.enumeration.FactKey;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.output.publish.OutputDB;
import pcgen.system.LanguageBundle;

public class PreFactTester
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    @Override
    public int passes(Prerequisite prereq, PlayerCharacter aPC, CDOMObject source) throws PrerequisiteException {
        int number;
        try {
            number = Integer.parseInt(prereq.getOperand());
        }
        catch (NumberFormatException exceptn) {
            throw new PrerequisiteException(LanguageBundle.getFormattedString("PreFact.error", prereq.toString()));
        }
        String location = prereq.getCategoryName();
        String[] locationElements = location.split("\\.");
        Iterable<Reducible> objModel = OutputDB.getIterable(aPC.getCharID(), locationElements);
        if (objModel == null) {
            throw new PrerequisiteException("Output System does not have model for: " + location);
        }
        String[] factinfo = prereq.getKey().split("=");
        FactKey fk = FactKey.valueOf(factinfo[0]);
        Indirect targetVal = fk.getFormatManager().convertIndirect(factinfo[1]);
        int runningTotal = 0;
        for (Reducible r : objModel) {
            Indirect cdoVal = r.getCDOMObject().get(fk);
            if (!targetVal.equals(cdoVal)) continue;
            ++runningTotal;
        }
        runningTotal = prereq.getOperator().compare(runningTotal, number);
        return this.countedTotal(prereq, runningTotal);
    }

    @Override
    public String kindHandled() {
        return "FACT";
    }

    @Override
    public String toHtmlString(Prerequisite prereq) {
        if (prereq.getOperator() == PrerequisiteOperator.GTEQ && "1".equals(prereq.getOperand())) {
            return prereq.getKey();
        }
        String foo = LanguageBundle.getFormattedString("PreFact.toHtml", prereq.getOperator().toDisplayString(), prereq.getOperand(), prereq.getKey());
        return foo;
    }
}

