/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.Collection;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.content.SpellLikeAbility;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.CDOMObjectSourceFacet;
import pcgen.cdom.facet.base.AbstractQualifiedListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.core.spell.Spell;

public class SpellsFacet
extends AbstractQualifiedListFacet<SpellLikeAbility>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private CDOMObjectSourceFacet cdomSourceFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CharID id = dfce.getCharID();
        CDOMObject cdo = dfce.getCDOMObject();
        Collection mods = cdo.getListMods(Spell.SPELLS);
        if (mods == null) {
            return;
        }
        for (CDOMReference ref : mods) {
            Collection<AssociatedPrereqObject> assocs = cdo.getListAssociations(Spell.SPELLS, ref);
            Collection spells = ref.getContainedObjects();
            for (AssociatedPrereqObject apo : assocs) {
                Formula times = apo.getAssociation(AssociationKey.TIMES_PER_UNIT);
                String timeunit = apo.getAssociation(AssociationKey.TIME_UNIT);
                if (timeunit == null) {
                    timeunit = "Day";
                }
                String casterlevel = apo.getAssociation(AssociationKey.CASTER_LEVEL);
                String dcformula = apo.getAssociation(AssociationKey.DC_FORMULA);
                String book = apo.getAssociation(AssociationKey.SPELLBOOK);
                String ident = cdo.getQualifiedKey();
                for (Spell sp : spells) {
                    SpellLikeAbility sla = new SpellLikeAbility(sp, times, timeunit, book, casterlevel, dcformula, ident);
                    sla.addAllPrerequisites(apo.getPrerequisiteList());
                    this.add(id, sla, cdo);
                }
            }
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.removeAll(dfce.getCharID(), dfce.getCDOMObject());
    }

    public void setCdomSourceFacet(CDOMObjectSourceFacet cdomSourceFacet) {
        this.cdomSourceFacet = cdomSourceFacet;
    }

    public void init() {
        this.cdomSourceFacet.addDataFacetChangeListener(this);
    }
}

