/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.converter;

import java.util.Collection;
import pcgen.base.util.ObjectContainer;
import pcgen.cdom.base.Converter;
import pcgen.cdom.base.PrimitiveFilter;
import pcgen.core.PlayerCharacter;

public class AddFilterConverter<B, R>
implements Converter<B, R> {
    private final Converter<B, R> converter;
    private final PrimitiveFilter<B> filter;

    public AddFilterConverter(Converter<B, R> conv, PrimitiveFilter<B> fil) {
        if (conv == null) {
            throw new IllegalArgumentException("Converter cannot be null");
        }
        if (fil == null) {
            throw new IllegalArgumentException("PrimitiveFilter cannot be null");
        }
        this.converter = conv;
        this.filter = fil;
    }

    @Override
    public Collection<? extends R> convert(ObjectContainer<B> orig) {
        return this.converter.convert(orig, this.filter);
    }

    @Override
    public Collection<? extends R> convert(ObjectContainer<B> orig, PrimitiveFilter<B> lim) {
        return this.converter.convert(orig, new CompoundFilter<B>(this.filter, lim));
    }

    public int hashCode() {
        return this.converter.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AddFilterConverter) {
            AddFilterConverter other = (AddFilterConverter)obj;
            return other.filter.equals(this.filter) && other.converter.equals(this.converter);
        }
        return false;
    }

    private static final class CompoundFilter<T>
    implements PrimitiveFilter<T> {
        private final PrimitiveFilter<T> filter1;
        private final PrimitiveFilter<T> filter2;

        public CompoundFilter(PrimitiveFilter<T> fil1, PrimitiveFilter<T> fil2) {
            this.filter1 = fil1;
            this.filter2 = fil2;
        }

        @Override
        public boolean allow(PlayerCharacter pc, T obj) {
            return this.filter1.allow(pc, obj) == this.filter2.allow(pc, obj);
        }
    }
}

