/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content.factset;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.ContentDefinition;
import pcgen.cdom.content.factset.FactSetDefinitionEnforcer;
import pcgen.cdom.content.factset.FactSetGroupDefinition;
import pcgen.cdom.content.factset.FactSetInfo;
import pcgen.cdom.content.factset.FactSetParser;
import pcgen.cdom.enumeration.FactSetKey;
import pcgen.output.actor.FactSetKeyActor;
import pcgen.output.wrapper.CDOMObjectWrapper;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public class FactSetDefinition<T extends CDOMObject, F>
extends ContentDefinition<T, F>
implements FactSetInfo<T, F> {
    private String factSetName;

    @Override
    protected void activateKey() {
        this.getFactSetKey();
    }

    @Override
    protected void activateOutput() {
        FactSetKeyActor<F> fca = new FactSetKeyActor<F>(this.getFactSetKey());
        CDOMObjectWrapper cow = CDOMObjectWrapper.getInstance();
        if (!cow.load(this.getUsableLocation(), this.factSetName.toLowerCase(), fca)) {
            Logging.errorPrint(this.getUsableLocation().getSimpleName() + " output " + this.factSetName.toLowerCase() + " already exists, ignoring Visibility to EXPORT for FACTSET: " + this.factSetName);
        }
    }

    @Override
    protected void activateTokens(LoadContext context) {
        Boolean selectable;
        context.loadLocalToken(new FactSetParser(this));
        Boolean required = this.getRequired();
        if (required != null && required.booleanValue()) {
            context.loadLocalToken(new FactSetDefinitionEnforcer(this));
        }
        if ((selectable = this.getSelectable()) != null && selectable.booleanValue()) {
            context.loadLocalToken(new FactSetGroupDefinition(this));
        }
    }

    public void setFactSetName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Fact Set Name cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Fact Set Name cannot be empty");
        }
        this.factSetName = name;
    }

    @Override
    public String getFactSetName() {
        return this.factSetName;
    }

    @Override
    public FactSetKey<F> getFactSetKey() {
        return FactSetKey.getConstant(this.factSetName, this.getFormatManager());
    }
}

