/*
 * Decompiled with CFR 0.152.
 */
package plugin.jepcommands;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import pcgen.core.GameMode;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.VariableProcessor;
import pcgen.util.PCGenCommand;
import pcgen.util.PJEP;

public class ClassLevelCommand
extends PCGenCommand {
    public boolean checkNumberOfParameters(int arg0) {
        return arg0 >= 0 && arg0 <= 2;
    }

    public ClassLevelCommand() {
        this.numberOfParameters = -1;
    }

    public String getFunctionName() {
        return "CLASSLEVEL";
    }

    public boolean updateVariables(PJEP jep) {
        String src;
        boolean updated = false;
        if (jep.removeVariable("CL") != null) {
            updated = true;
        }
        if ((src = this.variableSource) == null || !src.startsWith("CLASS:")) {
            return updated;
        }
        src = src.substring(6);
        PlayerCharacter pc = null;
        if (this.parent instanceof VariableProcessor) {
            pc = ((VariableProcessor)this.parent).getPc();
        } else if (this.parent instanceof PlayerCharacter) {
            pc = (PlayerCharacter)this.parent;
        }
        if (pc == null) {
            return updated;
        }
        Double result = new Double(pc.getClassLevelString(src, false));
        jep.addVariable("CL", ((Number)result).doubleValue());
        return true;
    }

    public void run(Stack inStack) throws ParseException {
        String src;
        String p2;
        this.checkStack(inStack);
        int paramCount = this.curNumberOfParameters;
        String applied = null;
        String className = null;
        if (paramCount > 2) {
            throw new ParseException("Invalid number of parameters");
        }
        if (paramCount >= 2 && (p2 = inStack.pop().toString()).startsWith("APPLIEDAS=")) {
            applied = p2.substring(10);
        }
        if (paramCount >= 1) {
            String p1 = inStack.pop().toString();
            if (p1.startsWith("APPLIEDAS=")) {
                if (applied != null) {
                    throw new ParseException("Formula had two APPLIEDAS= entries");
                }
                applied = p1.substring(10);
            } else {
                className = p1;
            }
        }
        if (className == null && (src = this.variableSource).startsWith("CLASS:")) {
            className = src.substring(6);
        }
        if (className == null) {
            throw new ParseException("Unable to determine class name");
        }
        PlayerCharacter pc = this.getPC();
        String cl = className;
        if (applied != null) {
            if ("NONEPIC".equalsIgnoreCase(applied)) {
                GameMode mode = SettingsHandler.getGame();
                int limit = mode.getMaxNonEpicLevel() + 1;
                if (limit == Integer.MAX_VALUE) {
                    throw new ParseException("Game Mode has no EPIC limit");
                }
                cl = cl + ";BEFORELEVEL=" + limit;
            } else {
                throw new ParseException("Did not understand APPLIEDAS=" + applied);
            }
        }
        Double result = new Double(pc.getClassLevelString(cl, false));
        inStack.push(result);
    }

    private PlayerCharacter getPC() throws ParseException {
        PlayerCharacter pc = null;
        if (this.parent instanceof VariableProcessor) {
            pc = ((VariableProcessor)this.parent).getPc();
        } else if (this.parent instanceof PlayerCharacter) {
            pc = (PlayerCharacter)this.parent;
        }
        if (pc == null) {
            throw new ParseException("Invalid parent (no PC): " + this.parent.getClass().getName());
        }
        return pc;
    }
}

