/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.NoteItem;
import pcgen.core.PlayerCharacter;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;

public class NoteToken
extends Token {
    public static final String TOKENNAME = "NOTE";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        StringTokenizer tok = new StringTokenizer(tokenSource, ".");
        tok.nextToken();
        StringBuilder sb = new StringBuilder();
        String name = tok.nextToken();
        List<NoteItem> noteList = NoteToken.getNoteList(pc, name);
        String beforeHeader = "<b>";
        String afterHeader = "</b><br/>";
        String beforeValue = "";
        String afterValue = "<br/>";
        String token = "ALL";
        if (tok.hasMoreTokens()) {
            beforeHeader = tok.nextToken();
            if ("NAME".equals(beforeHeader)) {
                token = "NAME";
                afterValue = "";
                beforeValue = "";
                afterHeader = "";
                beforeHeader = "";
                if (tok.hasMoreTokens() && !"ALL".equals(token)) {
                    beforeHeader = tok.nextToken();
                }
                if (tok.hasMoreTokens()) {
                    afterHeader = tok.nextToken();
                }
            } else if ("VALUE".equals(beforeHeader)) {
                token = "VALUE";
                afterValue = "";
                beforeValue = "";
                afterHeader = "";
                beforeHeader = "";
                if (tok.hasMoreTokens()) {
                    beforeValue = tok.nextToken();
                }
                if (tok.hasMoreTokens()) {
                    afterValue = tok.nextToken();
                }
            } else if ("ALL".equals(beforeHeader)) {
                token = "ALL";
                if (tok.hasMoreTokens()) {
                    beforeHeader = tok.nextToken();
                }
                if (tok.hasMoreTokens()) {
                    afterHeader = tok.nextToken();
                }
                if (tok.hasMoreTokens()) {
                    beforeValue = tok.nextToken();
                }
                if (tok.hasMoreTokens()) {
                    afterValue = tok.nextToken();
                }
            }
        }
        for (NoteItem ni : noteList) {
            if ("ALL".equals(token)) {
                sb.append(ni.getExportString(beforeHeader, afterHeader, beforeValue, afterValue));
                continue;
            }
            if ("NAME".equals(token)) {
                sb.append(ni.getName());
                continue;
            }
            if (!"VALUE".equals(token)) continue;
            String internal = beforeValue + afterValue;
            if ("".equals(internal)) {
                internal = "$1";
            }
            sb.append(beforeValue);
            sb.append(ni.getValue().replaceAll("(\n)", internal));
            sb.append(afterValue);
        }
        return sb.toString().trim();
    }

    public static List<NoteItem> getNoteList(PlayerCharacter pc, String name) {
        ArrayList<Object> resultList;
        block5: {
            ArrayList<NoteItem> noteList = new ArrayList<NoteItem>();
            NoteToken.buildSubTree(noteList, pc.getDisplay().getNotesList(), -1);
            if ("ALL".equals(name)) {
                resultList = noteList;
            } else {
                resultList = new ArrayList();
                try {
                    int i = Integer.parseInt(name);
                    if (i < 0 && i >= noteList.size()) break block5;
                    resultList.add(noteList.get(i));
                }
                catch (NumberFormatException e) {
                    resultList = new ArrayList<NoteItem>(noteList);
                    for (int i = resultList.size() - 1; i >= 0; --i) {
                        NoteItem ni = (NoteItem)resultList.get(i);
                        if (ni.getName().equalsIgnoreCase(name)) continue;
                        resultList.remove(i);
                    }
                }
            }
        }
        return resultList;
    }

    private static void buildSubTree(List<NoteItem> targetList, Collection<NoteItem> baseList, int parentNode) {
        for (NoteItem note : baseList) {
            if (note.getParentId() != parentNode && (parentNode != -1 || note.getParentId() >= 0)) continue;
            targetList.add(note);
            NoteToken.buildSubTree(targetList, baseList, note.getId());
        }
    }
}

