/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.layout.factories;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.layout.builder.ButtonBarBuilder;
import com.jgoodies.layout.builder.ButtonStackBuilder;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.layout.factories.Paddings;
import com.jgoodies.layout.layout.FormSpecs;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;

public final class Forms {
    private Forms() {
    }

    public static JComponent single(String columnSpec, String rowSpec, JComponent component) {
        Preconditions.checkNotBlank(columnSpec, "The %s must not be null, empty, or whitespace.", "column specification");
        Preconditions.checkNotBlank(rowSpec, "The %s must not be null, empty, or whitespace.", "row specification");
        Preconditions.checkNotNull(component, "The %s must not be null.", "component");
        return ((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns(columnSpec, new Object[0])).rows(rowSpec, new Object[0])).add(component).xy(1, 1)).build();
    }

    public static JComponent centered(JComponent component) {
        return Forms.single("center:pref:grow", "c:p:g", component);
    }

    public static JComponent padded(JComponent component, Paddings.Padding padding) {
        JComponent container = Forms.single("fill:pref", "f:p", component);
        container.setBorder(padding);
        return container;
    }

    public static JComponent padded(JComponent component, String paddingSpec, Object ... args) {
        return Forms.padded(component, Paddings.createPadding(paddingSpec, args));
    }

    public static JComponent paddedGrow(JComponent component, Paddings.Padding padding) {
        JComponent container = Forms.single("fill:default:grow", "f:d:g", component);
        container.setBorder(padding);
        return container;
    }

    public static JComponent paddedGrow(JComponent component, String paddingSpec, Object ... args) {
        return Forms.paddedGrow(component, Paddings.createPadding(paddingSpec, args));
    }

    public static JComponent horizontal(String gapColSpec, JComponent ... components) {
        Preconditions.checkNotBlank(gapColSpec, "The %s must not be null, empty, or whitespace.", "gap column specification");
        Preconditions.checkNotNull(components, "The %s must not be null.", "component array");
        Preconditions.checkArgument(components.length > 1, "You must provide more than one component.");
        FormBuilder builder = (FormBuilder)((FormBuilder)new FormBuilder().columns("%1$s*(pref, %2$s), pref", components.length - 1, gapColSpec)).rows(FormSpecs.PREF_ROWSPEC);
        int column = 1;
        for (JComponent component : components) {
            builder.add(component).xy(column, 1);
            column += 2;
        }
        return builder.build();
    }

    public static JComponent vertical(String gapRowSpec, JComponent ... components) {
        Preconditions.checkNotBlank(gapRowSpec, "The %s must not be null, empty, or whitespace.", "gap row specification");
        Preconditions.checkNotNull(components, "The %s must not be null.", "component array");
        Preconditions.checkArgument(components.length > 1, "You must provide more than one component.");
        FormBuilder builder = (FormBuilder)((FormBuilder)new FormBuilder().columns(FormSpecs.PREF_COLSPEC)).rows("%1$s*(p, %2$s), p", components.length - 1, gapRowSpec);
        int row = 1;
        for (JComponent component : components) {
            builder.add(component).xy(1, row);
            row += 2;
        }
        return builder.build();
    }

    public static JComponent buttonBar(JComponent ... buttons) {
        return new ButtonBarBuilder().addButton(buttons).build();
    }

    public static JComponent buttonStack(JComponent ... buttons) {
        return new ButtonStackBuilder().addButton(buttons).build();
    }

    public static JComponent checkBoxBar(JCheckBox ... checkBoxes) {
        return Forms.buildGroupedButtonBar(checkBoxes);
    }

    public static JComponent checkBoxStack(JCheckBox ... checkBoxes) {
        return Forms.buildGroupedButtonStack(checkBoxes);
    }

    public static JComponent radioButtonBar(JRadioButton ... radioButtons) {
        return Forms.buildGroupedButtonBar(radioButtons);
    }

    public static JComponent radioButtonStack(JRadioButton ... radioButtons) {
        return Forms.buildGroupedButtonStack(radioButtons);
    }

    private static JComponent buildGroupedButtonBar(AbstractButton ... buttons) {
        Preconditions.checkArgument(buttons.length > 1, "You must provide more than one button.");
        FormBuilder builder = (FormBuilder)((FormBuilder)new FormBuilder().columns("pref, %s*($rgap, pref)", buttons.length - 1)).rows(FormSpecs.PREF_ROWSPEC);
        int column = 1;
        for (AbstractButton button : buttons) {
            builder.add(button).xy(column, 1);
            column += 2;
        }
        builder.focusGroup(buttons);
        return builder.build();
    }

    private static JComponent buildGroupedButtonStack(AbstractButton ... buttons) {
        Preconditions.checkArgument(buttons.length > 1, "You must provide more than one button.");
        FormBuilder builder = (FormBuilder)((FormBuilder)new FormBuilder().columns(FormSpecs.PREF_COLSPEC)).rows("p, %s*(0, p)", buttons.length - 1);
        int row = 1;
        for (AbstractButton button : buttons) {
            builder.add(button).xy(1, row, "left, center");
            row += 2;
        }
        builder.focusGroup(buttons);
        return builder.build();
    }
}

