/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core;

import com.jgoodies.common.jsdl.check.SeverityLevel;
import com.jgoodies.common.jsdl.check.StyleCheck;
import com.jgoodies.common.jsdl.check.StyleChecks;

public final class JSDLCoreStyleChecks {
    public static final StyleCheck WINDOW_PARENT_NOT_NULL = StyleChecks.createAndRegister(SeverityLevel.WARNING, "A dialog should have the parent component set, so it can be opened relative to the parent's location.\nThis is important in multi-screen environments.\nYou can ensure that the parent is set, if you hand over the event that has initiated the command\nwhenever you create or show a dialog with JGoodies Dialogs.");
    public static final StyleCheck WINDOW_TITLE_NOT_BLANK = StyleChecks.createAndRegister(SeverityLevel.ERROR, "The window title must not be null, empty, or whitespace.");
    public static final StyleCheck WINDOW_TITLE_DOES_NOT_END_WITH_PUNCTUATION_MARK = StyleChecks.createAndRegister(SeverityLevel.INFO, "The window title shall not end with a period, question mark, or exclamation mark ('.', '!', '?').");
    public static final StyleCheck WINDOW_TITLE_TRIMMED = StyleChecks.createAndRegister(SeverityLevel.INFO, "The window title shall not start or end with whitespace, i.e. should be trimmed.");
    public static final StyleCheck COMMIT_BUTTONS_NOT_EMPTY = StyleChecks.createAndRegister(SeverityLevel.WARNING, "At least one commit button shall be provided, except in dialogs that are automatically closed,\nfor example progress dialogs that take only a few seconds.");
    public static final StyleCheck BUTTON_TEXTS_NOT_BLANK = StyleChecks.createAndRegister(SeverityLevel.ERROR, "A button text must not be blank.");
    public static final StyleCheck BUTTON_TEXTS_UNIQUE = StyleChecks.createAndRegister(SeverityLevel.ERROR, "A button text shall not duplicate other button texts.");
    public static final StyleCheck ERRORS_ARE_NEVER_OK = StyleChecks.createAndRegister(SeverityLevel.WARNING, "Errors are never OK; use Close instead.");
    public static final StyleCheck BUTTON_TEXT_SPELLING = StyleChecks.createAndRegister(SeverityLevel.WARNING, "A known button texts shall be spelled correctly.");
    public static final StyleCheck ADDITIONAL_BUTTON_IS_NOT_COMMIT = StyleChecks.createAndRegister(SeverityLevel.WARNING, "An additonal command button must not use a commit value.");
    public static final StyleCheck COMMIT_BUTTON_ORDER = StyleChecks.createAndRegister(SeverityLevel.WARNING, "A commit button shall be in the correct order.");
    public static final StyleCheck MAIN_INSTRUCTION_NULL_OR_NOT_BLANK = StyleChecks.createAndRegister(SeverityLevel.ERROR, "The main instruction may be null but must not be empty or whitespace.");
    public static final StyleCheck MAIN_INSTRUCTION_TRIMMED = StyleChecks.createAndRegister(SeverityLevel.INFO, "The main instruction should not start or end with whitespace, i.e. should be trimmed.");
    public static final StyleCheck MAIN_INSTRUCTION_DOES_NOT_END_WITH_PERIOD = StyleChecks.createAndRegister(SeverityLevel.INFO, "A main instruction shall not end with a period ('.').");
    public static final StyleCheck MAIN_INSTRUCTION_ELLIPSIS_SUFFIX_IS_CHARACTER_NOT_THREE_DOTS = StyleChecks.createAndRegister(SeverityLevel.INFO, "The main instruction ends with three dots \"...\"; use the single ellipsis character '\u2026' (\\u2026) instead.");
    public static final StyleCheck MAIN_INSTRUCTION_IS_QUESTION_IN_QUESTION_MESSAGES = StyleChecks.createAndRegister(SeverityLevel.WARNING, "The main instruction of a TaskPane with MessageType.QUESTION or QUESTION_CRITICAL shall be a question.\nIn your language it shall end with a question mark, for example: \"Do you want to update JDiskReport now?\"");
    public static final StyleCheck MAIN_INSTRUCTION_MUST_NOT_REPEAT_WINDOW_TITLE = StyleChecks.createAndRegister(SeverityLevel.WARNING, "A main instruction shall not repeat the window title.");
    public static final StyleCheck MAIN_INSTRUCTION_DOES_NOT_START_WITH_PLEASE_OR_WOULD_YOU_LIKE = StyleChecks.createAndRegister(SeverityLevel.INFO, "Write main instructions simply and directly.\nGood: \"Save changes?\"\nPoor: \"Would you like to save changes?\"\n\nGood: \"Check all applicable projects\"\nPoor: \"Please check all applicable projects\"");
    public static final StyleCheck LABELING_MAIN_INSTRUCTION_HAS_MNEMONIC = StyleChecks.createAndRegister(SeverityLevel.INFO, "A main instruction that labels the content shall have a mnemonic.\nIn other words, it shall mark a character with a mnemonic marker ('_'),\nas for example \"_Enter your billing address\".\nSee class MnemonicUtils for details about marking text.");
    public static final StyleCheck MAIN_INSTRUCTION_IS_SENTENCE = StyleChecks.createAndRegister(SeverityLevel.INFO, "[In western languages] a main instruction shall be a sentence, not a single word.");
    public static final StyleCheck WIZARD_PAGE_MAIN_INSTRUCTION_NOT_BLANK = StyleChecks.createAndRegister(SeverityLevel.WARNING, "A wizard page's main instruction must not be null, empty or whitespace.");
    public static final StyleCheck SUPPLEMENTAL_INSTRUCTION_TRIMMED = StyleChecks.createAndRegister(SeverityLevel.INFO, "The supplemental instruction must not start or end with whitespace, i.e. should be trimmed.");
    public static final StyleCheck META_OPTION_ENCLOSED_IN_PARENTHESES = StyleChecks.createAndRegister(SeverityLevel.INFO, "Meta-options shall be enclosed in parentheses, e.g. \"(None)\" or \"(All)\".");
    public static final StyleCheck TAB_TITLE_TRIMMED = StyleChecks.createAndRegister(SeverityLevel.INFO, "A tabbed pane's tab title shall not start or end with whitespace, i.e. should be trimmed.");

    private JSDLCoreStyleChecks() {
    }
}

