/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.ArrayList;
import java.util.Comparator;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTFormalParameter;
import net.sourceforge.pmd.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.CanSuppressWarnings;
import net.sourceforge.pmd.ast.SimpleNode;

public class RuleViolation
implements IRuleViolation {
    private Rule rule;
    private String description;
    private String filename;
    private String className;
    private String methodName;
    private String variableName;
    private String packageName;
    private int beginLine;
    private int endLine;
    private int beginColumn;
    private int endColumn;
    private boolean isSuppressed;

    public RuleViolation(Rule rule, RuleContext ctx, SimpleNode node) {
        this(rule, ctx, node, rule.getMessage());
    }

    public RuleViolation(Rule rule, RuleContext ctx, SimpleNode node, String specificMsg) {
        this.rule = rule;
        this.filename = ctx.getSourceCodeFilename();
        this.description = specificMsg;
        this.className = node.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class) == null ? "" : (node.getScope().getEnclosingClassScope().getClassName() == null ? "" : node.getScope().getEnclosingClassScope().getClassName());
        this.setVariableNameIfExists(node);
        this.methodName = node.getFirstParentOfType(ASTMethodDeclaration.class) == null ? "" : node.getScope().getEnclosingMethodScope().getName();
        this.packageName = node.getScope().getEnclosingSourceFileScope().getPackageName() == null ? "" : node.getScope().getEnclosingSourceFileScope().getPackageName();
        this.beginLine = node.getBeginLine();
        this.endLine = node.getEndLine();
        this.beginColumn = node.getBeginColumn();
        this.endColumn = node.getEndColumn();
        ArrayList<ASTTypeDeclaration> parentTypes = new ArrayList<ASTTypeDeclaration>(node.getParentsOfType(ASTTypeDeclaration.class));
        if (node instanceof ASTTypeDeclaration) {
            parentTypes.add((ASTTypeDeclaration)node);
        }
        parentTypes.addAll(node.getParentsOfType(ASTClassOrInterfaceBodyDeclaration.class));
        if (node instanceof ASTClassOrInterfaceBodyDeclaration) {
            parentTypes.add((ASTTypeDeclaration)node);
        }
        parentTypes.addAll(node.getParentsOfType(ASTFormalParameter.class));
        if (node instanceof ASTFormalParameter) {
            parentTypes.add((ASTTypeDeclaration)node);
        }
        parentTypes.addAll(node.getParentsOfType(ASTLocalVariableDeclaration.class));
        if (node instanceof ASTLocalVariableDeclaration) {
            parentTypes.add((ASTTypeDeclaration)node);
        }
        for (CanSuppressWarnings canSuppressWarnings : parentTypes) {
            if (!canSuppressWarnings.hasSuppressWarningsAnnotationFor(this.getRule())) continue;
            this.isSuppressed = true;
        }
    }

    private void setVariableNameIfExists(SimpleNode node) {
        String string = this.variableName = node.getClass().equals(ASTFieldDeclaration.class) ? ((ASTFieldDeclaration)node).getVariableName() : "";
        if (this.variableName == "") {
            String string2 = this.variableName = node.getClass().equals(ASTLocalVariableDeclaration.class) ? ((ASTLocalVariableDeclaration)node).getVariableName() : "";
        }
        if (this.variableName == "") {
            this.variableName = node.getClass().equals(ASTVariableDeclaratorId.class) ? node.getImage() : "";
        }
    }

    public Rule getRule() {
        return this.rule;
    }

    public boolean isSuppressed() {
        return this.isSuppressed;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String toString() {
        return this.getFilename() + ":" + this.getRule() + ":" + this.getDescription() + ":" + this.beginLine;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RuleViolationComparator
    implements Comparator<IRuleViolation> {
        @Override
        public int compare(IRuleViolation r1, IRuleViolation r2) {
            if (!r1.getFilename().equals(r2.getFilename())) {
                return r1.getFilename().compareTo(r2.getFilename());
            }
            if (r1.getBeginLine() != r2.getBeginLine()) {
                return r1.getBeginLine() - r2.getBeginLine();
            }
            if (r1.getDescription() != null && r2.getDescription() != null && !r1.getDescription().equals(r2.getDescription())) {
                return r1.getDescription().compareTo(r2.getDescription());
            }
            if (r1.getBeginLine() == r2.getBeginLine()) {
                return 1;
            }
            return r1.getBeginLine() - r2.getBeginLine();
        }
    }
}

