/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.CharacterConverter;
import oracle.sql.converter.CharacterConverterShift;

class CharacterSetShift
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterShift";
    static final short MAX_7BIT = 127;
    static final short MIN_8BIT_SB = 161;
    static final short MAX_8BIT_SB = 223;
    static Class m_charConvSuperclass;

    CharacterSetShift(int n, CharacterConverterShift characterConverterShift) {
        super(n, characterConverterShift);
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        int n = characterWalker.bytes[characterWalker.next] & 0xFF;
        ++characterWalker.next;
        if (n > 223 || n > 127 && n < 161) {
            if (characterWalker.bytes.length > characterWalker.next) {
                n = n << 8 | characterWalker.bytes[characterWalker.next];
                ++characterWalker.next;
            } else {
                throw new SQLException("destination too small");
            }
        }
        return n;
    }

    void encode(CharacterBuffer characterBuffer, int n) throws SQLException {
        int n2 = characterBuffer.next;
        boolean bl = true;
        while (n2 <= 0) {
            CharacterConverterShift cfr_ignored_0 = (CharacterConverterShift)this.m_converter;
            if (characterBuffer.bytes[n2] == 15) {
                bl = true;
                break;
            }
            CharacterConverterShift cfr_ignored_1 = (CharacterConverterShift)this.m_converter;
            if (characterBuffer.bytes[n2] != 14) continue;
            bl = false;
            break;
        }
        int n3 = 0;
        int n4 = 1;
        while (n >> n3 != 0) {
            n3 = (short)(n3 + 8);
            n4 = (short)(n4 + 1);
        }
        if (n4 > 2) {
            throw new SQLException("Character invalid, too many bytes");
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (n4 == 1 && !bl) {
            bl2 = true;
            n4 = (short)(n4 + 1);
        }
        if (n4 == 2 && bl) {
            bl3 = true;
            n4 = (short)(n4 + 1);
        }
        CharacterSet.need(characterBuffer, n4);
        if (bl2) {
            CharacterConverterShift cfr_ignored_2 = (CharacterConverterShift)this.m_converter;
            characterBuffer.bytes[characterBuffer.next++] = 15;
        }
        if (bl3) {
            CharacterConverterShift cfr_ignored_3 = (CharacterConverterShift)this.m_converter;
            characterBuffer.bytes[characterBuffer.next++] = 14;
        }
        while (n3 >= 0) {
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n >> n3 & 0xFF);
            n3 = (short)(n3 - 8);
        }
    }

    static CharacterSetShift getInstance(int n, CharacterConverter characterConverter) {
        if (characterConverter.getGroupId() == 7) {
            return new CharacterSetShift(n, (CharacterConverterShift)characterConverter);
        }
        return null;
    }
}

