/*
 * Decompiled with CFR 0.152.
 */
package spock.util;

import java.util.ArrayList;
import java.util.List;
import org.spockframework.util.Assert;

public abstract class Exceptions {
    public static Throwable getRootCause(Throwable exception) {
        Assert.notNull(exception);
        return exception.getCause() == null ? exception : Exceptions.getRootCause(exception.getCause());
    }

    public static List<Throwable> getCauseChain(Throwable exception) {
        Assert.notNull(exception);
        ArrayList<Throwable> result = new ArrayList<Throwable>();
        Exceptions.collectCauseChain(exception, result);
        return result;
    }

    private static void collectCauseChain(Throwable exception, List<Throwable> collector) {
        if (exception == null) {
            return;
        }
        collector.add(exception);
        Exceptions.collectCauseChain(exception.getCause(), collector);
    }
}

