/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.report.log;

import java.io.File;
import org.spockframework.report.log.IReportLogListener;
import org.spockframework.report.log.ReportLogClient;
import org.spockframework.report.log.ReportLogConfiguration;
import org.spockframework.report.log.ReportLogEmitter;
import org.spockframework.report.log.ReportLogWriter;
import org.spockframework.runtime.AbstractRunListener;
import org.spockframework.runtime.AsyncStandardStreamsListener;
import org.spockframework.runtime.StandardStreamsCapturer;
import org.spockframework.runtime.extension.AbstractGlobalExtension;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.IoUtil;

public class ReportLogExtension
extends AbstractGlobalExtension {
    private final StandardStreamsCapturer streamsCapturer = new StandardStreamsCapturer();
    private AsyncStandardStreamsListener logWriterListener;
    private AsyncStandardStreamsListener logClientListener;
    private ReportLogWriter logWriter;
    private ReportLogClient logClient;
    volatile ReportLogConfiguration reportConfig;

    @Override
    public void visitSpec(SpecInfo spec) {
        if (!this.reportConfig.enabled) {
            return;
        }
        if (this.logWriterListener != null) {
            spec.addListener(this.logWriterListener);
        }
        if (this.logClientListener != null) {
            spec.addListener(this.logClientListener);
        }
        if (this.logWriterListener != null || this.logClientListener != null) {
            spec.addListener(new AbstractRunListener(){

                @Override
                public void beforeSpec(SpecInfo theSpec) {
                    ReportLogExtension.this.streamsCapturer.start();
                }
            });
        }
    }

    @Override
    public void start() {
        if (!this.reportConfig.enabled) {
            return;
        }
        File logFile = this.reportConfig.getLogFile();
        if (logFile != null) {
            this.logWriter = new ReportLogWriter(logFile);
            this.logWriter.setPrefix("loadLogFile(");
            this.logWriter.setPostfix(")\n\n");
            this.logWriter.start();
            this.logWriterListener = this.createRunListener("spock-report-log-writer", this.logWriter);
            this.logWriterListener.start();
        }
        if (this.reportConfig.reportServerAddress != null) {
            this.logClient = new ReportLogClient(this.reportConfig.reportServerAddress, this.reportConfig.reportServerPort);
            this.logClient.start();
            this.logClientListener = this.createRunListener("spock-report-log-client", this.logClient);
            this.logClientListener.start();
        }
    }

    @Override
    public void stop() {
        if (!this.reportConfig.enabled) {
            return;
        }
        IoUtil.stopQuietly(this.streamsCapturer, this.logWriterListener, this.logWriter, this.logClientListener, this.logClient);
    }

    private AsyncStandardStreamsListener createRunListener(String name, IReportLogListener logListener) {
        ReportLogEmitter emitter = new ReportLogEmitter();
        emitter.addListener(logListener);
        AsyncStandardStreamsListener listener = new AsyncStandardStreamsListener(name, emitter, emitter);
        this.streamsCapturer.addStandardStreamsListener(listener);
        return listener;
    }
}

