/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.scan;

import JTrrntzip.TrrntZipStatus;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jrm.locale.Messages;
import jrm.misc.BreakException;
import jrm.misc.Log;
import jrm.misc.Settings;
import jrm.profile.Profile;
import jrm.profile.data.Anyware;
import jrm.profile.data.AnywareBase;
import jrm.profile.data.AnywareList;
import jrm.profile.data.Archive;
import jrm.profile.data.ByName;
import jrm.profile.data.Container;
import jrm.profile.data.Directory;
import jrm.profile.data.Disk;
import jrm.profile.data.Entity;
import jrm.profile.data.EntityBase;
import jrm.profile.data.EntityStatus;
import jrm.profile.data.Entry;
import jrm.profile.data.MachineList;
import jrm.profile.data.NameBase;
import jrm.profile.data.Rom;
import jrm.profile.data.Sample;
import jrm.profile.data.Samples;
import jrm.profile.data.SoftwareList;
import jrm.profile.fix.actions.AddEntry;
import jrm.profile.fix.actions.BackupContainer;
import jrm.profile.fix.actions.BackupEntry;
import jrm.profile.fix.actions.ContainerAction;
import jrm.profile.fix.actions.CreateContainer;
import jrm.profile.fix.actions.DeleteContainer;
import jrm.profile.fix.actions.DeleteEntry;
import jrm.profile.fix.actions.DuplicateEntry;
import jrm.profile.fix.actions.OpenContainer;
import jrm.profile.fix.actions.RenameEntry;
import jrm.profile.fix.actions.TZipContainer;
import jrm.profile.report.ContainerTZip;
import jrm.profile.report.ContainerUnknown;
import jrm.profile.report.ContainerUnneeded;
import jrm.profile.report.EntryAdd;
import jrm.profile.report.EntryMissing;
import jrm.profile.report.EntryMissingDuplicate;
import jrm.profile.report.EntryOK;
import jrm.profile.report.EntryUnneeded;
import jrm.profile.report.EntryWrongHash;
import jrm.profile.report.EntryWrongName;
import jrm.profile.report.Report;
import jrm.profile.report.RomSuspiciousCRC;
import jrm.profile.report.SubjectSet;
import jrm.profile.scan.DirScan;
import jrm.profile.scan.options.FormatOptions;
import jrm.profile.scan.options.HashCollisionOptions;
import jrm.profile.scan.options.MergeOptions;
import jrm.ui.MainFrame;
import jrm.ui.progress.ProgressHandler;
import org.apache.commons.io.FilenameUtils;

public class Scan {
    public static final Report report = new Report();
    public final ArrayList<Collection<ContainerAction>> actions = new ArrayList();
    private final Profile profile;
    private final MergeOptions merge_mode;
    private final boolean implicit_merge;
    private final FormatOptions format;
    private final boolean create_mode;
    private final boolean createfull_mode;
    private final boolean ignore_unneeded_containers;
    private final boolean ignore_unneeded_entries;
    private final boolean ignore_unknown_containers;
    private final boolean backup;
    private final HashCollisionOptions hash_collision_mode;
    private DirScan roms_dstscan = null;
    private DirScan disks_dstscan = null;
    private DirScan samples_dstscan = null;
    private final Map<String, DirScan> swroms_dstscans = new HashMap<String, DirScan>();
    private Map<String, DirScan> swdisks_dstscans = new HashMap<String, DirScan>();
    private final List<DirScan> allscans = new ArrayList<DirScan>();
    private final ArrayList<ContainerAction> backup_actions = new ArrayList();
    private final ArrayList<ContainerAction> create_actions = new ArrayList();
    private final ArrayList<ContainerAction> rename_before_actions = new ArrayList();
    private final ArrayList<ContainerAction> add_actions = new ArrayList();
    private final ArrayList<ContainerAction> delete_actions = new ArrayList();
    private final ArrayList<ContainerAction> rename_after_actions = new ArrayList();
    private final ArrayList<ContainerAction> duplicate_actions = new ArrayList();
    private final Map<String, ContainerAction> tzip_actions = new HashMap<String, ContainerAction>();

    private static <T> Predicate<T> not(Predicate<T> predicate) {
        return predicate.negate();
    }

    public Scan(Profile profile, ProgressHandler handler) throws BreakException {
        this(profile, handler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scan(Profile profile, ProgressHandler handler, Map<String, DirScan> scancache) throws BreakException {
        this.profile = profile;
        profile.setPropsCheckPoint();
        report.reset();
        this.format = FormatOptions.valueOf(profile.getProperty("format", FormatOptions.ZIP.toString()));
        this.merge_mode = MergeOptions.valueOf(profile.getProperty("merge_mode", MergeOptions.SPLIT.toString()));
        this.implicit_merge = profile.getProperty("implicit_merge", false);
        this.create_mode = profile.getProperty("create_mode", true);
        this.createfull_mode = profile.getProperty("createfull_mode", true);
        this.hash_collision_mode = HashCollisionOptions.valueOf(profile.getProperty("hash_collision_mode", HashCollisionOptions.SINGLEFILE.toString()));
        this.ignore_unneeded_containers = profile.getProperty("ignore_unneeded_containers", false);
        this.ignore_unneeded_entries = profile.getProperty("ignore_unneeded_entries", false);
        this.ignore_unknown_containers = profile.getProperty("ignore_unknown_containers", false);
        this.backup = profile.getProperty("backup", true);
        String dstdir_txt = profile.getProperty("roms_dest_dir", "");
        if (dstdir_txt.isEmpty()) {
            System.err.println("dst dir is empty");
            return;
        }
        File roms_dstdir = new File(dstdir_txt);
        if (!roms_dstdir.isDirectory()) {
            System.err.println("dst dir is not a directory");
            return;
        }
        File disks_dstdir = new File(roms_dstdir.getAbsolutePath());
        if (profile.getProperty("disks_dest_dir_enabled", false)) {
            String disks_dstdir_txt = profile.getProperty("disks_dest_dir", "");
            if (disks_dstdir_txt.isEmpty()) {
                return;
            }
            disks_dstdir = new File(disks_dstdir_txt);
        }
        File swroms_dstdir = new File(roms_dstdir.getAbsolutePath());
        if (profile.getProperty("swroms_dest_dir_enabled", false)) {
            String swroms_dstdir_txt = profile.getProperty("swroms_dest_dir", "");
            if (swroms_dstdir_txt.isEmpty()) {
                return;
            }
            swroms_dstdir = new File(swroms_dstdir_txt);
        }
        File swdisks_dstdir = new File(swroms_dstdir.getAbsolutePath());
        if (profile.getProperty("swdisks_dest_dir_enabled", false)) {
            String swdisks_dstdir_txt = profile.getProperty("swdisks_dest_dir", "");
            if (swdisks_dstdir_txt.isEmpty()) {
                return;
            }
            swdisks_dstdir = new File(swdisks_dstdir_txt);
        }
        String samples_dstdir_txt = profile.getProperty("samples_dest_dir", "");
        File samples_dstdir = profile.getProperty("samples_dest_dir_enabled", false) && samples_dstdir_txt.length() > 0 ? new File(samples_dstdir_txt) : null;
        ArrayList<File> srcdirs = new ArrayList<File>();
        for (String s : profile.getProperty("src_dir", "").split("\\|")) {
            File f;
            if (s.isEmpty() || !(f = new File(s)).isDirectory()) continue;
            srcdirs.add(f);
        }
        srcdirs.add(new File(Settings.getWorkPath().toFile(), "backup"));
        for (File dir : srcdirs) {
            if (scancache != null) {
                String cachefile = DirScan.getCacheFile(dir, DirScan.getOptions(profile, false)).getAbsolutePath();
                if (!scancache.containsKey(cachefile)) {
                    scancache.put(cachefile, new DirScan(profile, dir, handler, false));
                }
                this.allscans.add(scancache.get(cachefile));
            } else {
                this.allscans.add(new DirScan(profile, dir, handler, false));
            }
            if (!handler.isCancel()) continue;
            throw new BreakException();
        }
        ArrayList<Container> unknown = new ArrayList<Container>();
        ArrayList<Container> unneeded = new ArrayList<Container>();
        ArrayList<Container> samples_unknown = new ArrayList<Container>();
        ArrayList<Container> samples_unneeded = new ArrayList<Container>();
        if (((MachineList)profile.machinelist_list.get(0)).size() > 0) {
            ((MachineList)profile.machinelist_list.get(0)).resetFilteredName();
            this.roms_dstscan = this.dirscan((ByName<?>)profile.machinelist_list.get(0), roms_dstdir, (List<Container>)unknown, (List<Container>)unneeded, handler);
            this.disks_dstscan = roms_dstdir.equals(disks_dstdir) ? this.roms_dstscan : this.dirscan((ByName<?>)profile.machinelist_list.get(0), disks_dstdir, (List<Container>)unknown, (List<Container>)unneeded, handler);
            if (samples_dstdir != null && samples_dstdir.isDirectory()) {
                this.samples_dstscan = this.dirscan(((MachineList)profile.machinelist_list.get((int)0)).samplesets, samples_dstdir, samples_unknown, samples_unneeded, handler);
            }
            if (handler.isCancel()) {
                throw new BreakException();
            }
        }
        if (profile.machinelist_list.softwarelist_list.size() > 0) {
            AtomicInteger j = new AtomicInteger();
            handler.setProgress2(String.format("%d/%d", j.get(), profile.machinelist_list.softwarelist_list.size()), j.get(), profile.machinelist_list.softwarelist_list.size());
            for (SoftwareList sl2 : profile.machinelist_list.softwarelist_list.getFilteredStream().collect(Collectors.toList())) {
                sl2.resetFilteredName();
                File sldir = new File(swroms_dstdir, sl2.getName());
                this.swroms_dstscans.put(sl2.getName(), this.dirscan(sl2, sldir, unknown, unneeded, handler));
                if (swroms_dstdir.equals(swdisks_dstdir)) {
                    this.swdisks_dstscans = this.swroms_dstscans;
                } else {
                    sldir = new File(swdisks_dstdir, sl2.getName());
                    this.swdisks_dstscans.put(sl2.getName(), this.dirscan(sl2, sldir, unknown, unneeded, handler));
                }
                handler.setProgress2(String.format("%d/%d (%s)", j.incrementAndGet(), profile.machinelist_list.softwarelist_list.size(), sl2.getName()), j.get(), profile.machinelist_list.softwarelist_list.size());
                if (!handler.isCancel()) continue;
                throw new BreakException();
            }
            handler.setProgress2(null, null);
            if (swroms_dstdir.isDirectory() && !swroms_dstdir.equals(roms_dstdir)) {
                for (File f : swroms_dstdir.listFiles()) {
                    if (!this.swroms_dstscans.containsKey(f.getName())) {
                        unknown.add(f.isDirectory() ? new Directory(f, (AnywareBase)null) : new Archive(f, (AnywareBase)null));
                    }
                    if (!handler.isCancel()) continue;
                    throw new BreakException();
                }
            }
            if (!swroms_dstdir.equals(swdisks_dstdir) && swdisks_dstdir.isDirectory()) {
                for (File f : swdisks_dstdir.listFiles()) {
                    if (!this.swdisks_dstscans.containsKey(f.getName())) {
                        unknown.add(f.isDirectory() ? new Directory(f, (AnywareBase)null) : new Archive(f, (AnywareBase)null));
                    }
                    if (!handler.isCancel()) continue;
                    throw new BreakException();
                }
            }
        }
        handler.setInfos(1, false);
        try {
            if (!this.ignore_unknown_containers) {
                unknown.forEach(c -> {
                    report.add(new ContainerUnknown((Container)c));
                    this.delete_actions.add(new DeleteContainer((Container)c, this.format));
                });
            }
            if (!this.ignore_unneeded_containers) {
                unneeded.forEach(c -> {
                    report.add(new ContainerUnneeded((Container)c));
                    this.backup_actions.add(new BackupContainer((Container)c));
                    this.delete_actions.add(new DeleteContainer((Container)c, this.format));
                });
            }
            profile.suspicious_crc.forEach(crc -> report.add(new RomSuspiciousCRC((String)crc)));
            AtomicInteger i = new AtomicInteger();
            AtomicInteger j = new AtomicInteger();
            handler.setProgress(Messages.getString("Scan.SearchingForFixes"), i.get(), profile.subsize());
            handler.setProgress2(String.format("%d/%d", j.get(), profile.size()), j.get(), profile.size());
            if (((MachineList)profile.machinelist_list.get(0)).size() > 0) {
                handler.setProgress2(String.format("%d/%d", j.incrementAndGet(), profile.size()), j.get(), profile.size());
                for (Samples set : ((MachineList)profile.machinelist_list.get((int)0)).samplesets) {
                    handler.setProgress(null, i.incrementAndGet(), null, set.getName());
                    if (this.samples_dstscan != null) {
                        this.scanSamples(set);
                    }
                    if (!handler.isCancel()) continue;
                    throw new BreakException();
                }
                ((MachineList)profile.machinelist_list.get(0)).forEach(Anyware::resetCollisionMode);
                ((MachineList)profile.machinelist_list.get(0)).getFilteredStream().forEach(m -> {
                    handler.setProgress(null, i.incrementAndGet(), null, m.getFullName());
                    this.scanWare((Anyware)m);
                    if (handler.isCancel()) {
                        throw new BreakException();
                    }
                });
            }
            if (profile.machinelist_list.softwarelist_list.size() > 0) {
                profile.machinelist_list.softwarelist_list.getFilteredStream().forEach(sl -> {
                    handler.setProgress2(String.format("%d/%d (%s)", j.incrementAndGet(), profile.size(), sl.getName()), j.get(), profile.size());
                    this.roms_dstscan = this.swroms_dstscans.get(sl.getName());
                    this.disks_dstscan = this.swdisks_dstscans.get(sl.getName());
                    sl.getFilteredStream().forEach(Anyware::resetCollisionMode);
                    sl.getFilteredStream().forEach(s -> {
                        handler.setProgress(null, i.incrementAndGet(), null, s.getFullName());
                        this.scanWare((Anyware)s);
                        if (handler.isCancel()) {
                            throw new BreakException();
                        }
                    });
                });
            }
            handler.setProgress2(null, null);
        }
        catch (BreakException e) {
            throw e;
        }
        catch (Throwable e) {
            Log.err("Other Exception when listing", e);
        }
        finally {
            handler.setProgress(Messages.getString("Profile.SavingCache"), -1);
            report.write();
            report.flush();
            if (MainFrame.profile_viewer != null) {
                MainFrame.profile_viewer.reload();
            }
            profile.nfo.stats.scanned = new Date();
            profile.nfo.stats.haveSets = Stream.concat(profile.machinelist_list.stream(), profile.machinelist_list.softwarelist_list.stream()).mapToLong(AnywareList::countHave).sum();
            profile.nfo.stats.haveRoms = Stream.concat(profile.machinelist_list.stream(), profile.machinelist_list.softwarelist_list.stream()).flatMap(Collection::stream).mapToLong(Anyware::countHaveRoms).sum();
            profile.nfo.stats.haveDisks = Stream.concat(profile.machinelist_list.stream(), profile.machinelist_list.softwarelist_list.stream()).flatMap(Collection::stream).mapToLong(Anyware::countHaveDisks).sum();
            profile.nfo.save();
            profile.save();
        }
        if (this.backup) {
            this.actions.add(this.backup_actions);
        }
        this.actions.add(this.create_actions);
        this.actions.add(this.rename_before_actions);
        this.actions.add(this.add_actions);
        this.actions.add(this.duplicate_actions);
        this.actions.add(this.delete_actions);
        this.actions.add(this.rename_after_actions);
        this.actions.add(this.tzip_actions.values());
    }

    private DirScan dirscan(ByName<?> byname, File dstdir, List<Container> unknown, List<Container> unneeded, ProgressHandler handler) {
        DirScan dstscan = new DirScan(this.profile, dstdir, handler, true);
        this.allscans.add(dstscan);
        for (Container c : dstscan.getContainersIterable()) {
            if (c.getType() == Container.Type.UNK) {
                unknown.add(c);
                continue;
            }
            if (byname.containsFilteredName(FilenameUtils.getBaseName(c.file.toString()))) continue;
            if (byname.containsName(FilenameUtils.getBaseName(c.file.toString()))) {
                unneeded.add(c);
                continue;
            }
            unknown.add(c);
        }
        return dstscan;
    }

    private void prepTZip(SubjectSet report_subject, Container archive, Anyware ware, List<Rom> roms) {
        if (!(this.format != FormatOptions.TZIP || this.merge_mode.isMerge() && ware.isClone() || report_subject.isMissing() || report_subject.isUnneeded() || roms.size() <= 0)) {
            Container tzipcontainer = null;
            Container container = this.roms_dstscan.getContainerByName(ware.getDest(this.merge_mode, this.implicit_merge).getName() + (Object)((Object)this.format.getExt()));
            if (container != null) {
                if (container.lastTZipCheck < container.modified) {
                    tzipcontainer = container;
                } else if (!container.lastTZipStatus.contains(TrrntZipStatus.ValidTrrntzip)) {
                    tzipcontainer = container;
                } else if (report_subject.hasFix()) {
                    tzipcontainer = container;
                }
            } else if (this.create_mode && report_subject.hasFix()) {
                tzipcontainer = archive;
            }
            if (tzipcontainer != null) {
                tzipcontainer.m = ware;
                this.tzip_actions.put(tzipcontainer.file.getAbsolutePath(), new TZipContainer(tzipcontainer, this.format));
                report.add(new ContainerTZip(tzipcontainer));
            }
        }
    }

    private void prepTZip(SubjectSet report_subject, Container archive, Samples set) {
        if (this.format == FormatOptions.TZIP && !report_subject.isMissing() && !report_subject.isUnneeded() && set.samples.size() > 0) {
            Container tzipcontainer = null;
            Container container = this.samples_dstscan.getContainerByName(archive.file.getName());
            if (container != null) {
                if (container.lastTZipCheck < container.modified) {
                    tzipcontainer = container;
                } else if (!container.lastTZipStatus.contains(TrrntZipStatus.ValidTrrntzip)) {
                    tzipcontainer = container;
                } else if (report_subject.hasFix()) {
                    tzipcontainer = container;
                }
            } else if (this.create_mode && report_subject.hasFix()) {
                tzipcontainer = archive;
            }
            if (tzipcontainer != null) {
                tzipcontainer.m = set;
                this.tzip_actions.put(tzipcontainer.file.getAbsolutePath(), new TZipContainer(tzipcontainer, this.format));
                report.add(new ContainerTZip(tzipcontainer));
            }
        }
    }

    private void removeOtherFormats(Anyware ware) {
        this.format.getExt().allExcept().forEach(e -> {
            Container c = this.roms_dstscan.getContainerByName(ware.getName() + (Object)e);
            if (c != null) {
                report.add(new ContainerUnneeded(c));
                this.backup_actions.add(new BackupContainer(c));
                this.delete_actions.add(new DeleteContainer(c, this.format));
            }
        });
    }

    private void removeUnneededClone(Anyware ware, List<Disk> disks, List<Rom> roms) {
        if (this.merge_mode.isMerge() && ware.isClone()) {
            Container c2;
            if (this.format == FormatOptions.DIR && disks.size() == 0 && roms.size() == 0) {
                Arrays.asList(this.roms_dstscan.getContainerByName(ware.getName()), this.disks_dstscan.getContainerByName(ware.getName())).forEach(c -> {
                    if (c != null) {
                        report.add(new ContainerUnneeded((Container)c));
                        this.backup_actions.add(new BackupContainer((Container)c));
                        this.delete_actions.add(new DeleteContainer((Container)c, this.format));
                    }
                });
            } else if (disks.size() == 0 && (c2 = this.disks_dstscan.getContainerByName(ware.getName())) != null) {
                report.add(new ContainerUnneeded(c2));
                this.backup_actions.add(new BackupContainer(c2));
                this.delete_actions.add(new DeleteContainer(c2, this.format));
            }
            if (this.format != FormatOptions.DIR && roms.size() == 0 && (c2 = this.roms_dstscan.getContainerByName(ware.getName() + (Object)((Object)this.format.getExt()))) != null) {
                report.add(new ContainerUnneeded(c2));
                this.backup_actions.add(new BackupContainer(c2));
                this.delete_actions.add(new DeleteContainer(c2, this.format));
            }
        }
    }

    private boolean scanDisks(Anyware ware, List<Disk> disks, Directory directory, SubjectSet report_subject) {
        boolean missing_set = true;
        Container container = this.disks_dstscan.getContainerByName(ware.getDest(this.merge_mode, this.implicit_merge).getNormalizedName());
        if (null != container) {
            missing_set = false;
            if (disks.size() > 0) {
                report_subject.setFound();
                ArrayList<Entry> disks_found = new ArrayList<Entry>();
                Map<String, Disk> disks_byname = Disk.getDisksByName(disks);
                OpenContainer add_set = null;
                OpenContainer delete_set = null;
                OpenContainer rename_before_set = null;
                OpenContainer rename_after_set = null;
                OpenContainer duplicate_set = null;
                for (Disk disk : disks) {
                    disk.setStatus(EntityStatus.KO);
                    Entry found_entry = null;
                    Map<String, Entry> entries_byname = container.getEntriesByName();
                    for (Entry candidate_entry : container.getEntries()) {
                        if (candidate_entry.equals(disk)) {
                            if (!disk.getNormalizedName().equals(candidate_entry.getName())) {
                                Disk another_disk = disks_byname.get(candidate_entry.getName());
                                if (null != another_disk && candidate_entry.equals(another_disk)) {
                                    if (entries_byname.containsKey(disk.getNormalizedName())) continue;
                                    report_subject.add(new EntryMissingDuplicate(disk, candidate_entry));
                                    duplicate_set = OpenContainer.getInstance(duplicate_set, directory, this.format, 0L);
                                    duplicate_set.addAction(new DuplicateEntry(disk.getName(), candidate_entry));
                                    found_entry = candidate_entry;
                                    continue;
                                }
                                if (entries_byname.containsKey(disk.getNormalizedName())) continue;
                                report_subject.add(new EntryWrongName(disk, candidate_entry));
                                rename_before_set = OpenContainer.getInstance(rename_before_set, directory, this.format, 0L);
                                rename_before_set.addAction(new RenameEntry(candidate_entry));
                                rename_after_set = OpenContainer.getInstance(rename_after_set, directory, this.format, 0L);
                                rename_after_set.addAction(new RenameEntry(disk.getName(), candidate_entry));
                                found_entry = candidate_entry;
                                break;
                            }
                            found_entry = candidate_entry;
                            break;
                        }
                        if (!disk.getNormalizedName().equals(candidate_entry.getName())) continue;
                        report_subject.add(new EntryWrongHash(disk, candidate_entry));
                        break;
                    }
                    if (found_entry == null) {
                        ++Scan.report.stats.missing_disks_cnt;
                        for (DirScan scan : this.allscans) {
                            found_entry = scan.find_byhash(disk);
                            if (null == found_entry) continue;
                            report_subject.add(new EntryAdd(disk, found_entry));
                            add_set = OpenContainer.getInstance(add_set, directory, this.format, 0L);
                            add_set.addAction(new AddEntry(disk, found_entry));
                            break;
                        }
                        if (found_entry != null) continue;
                        report_subject.add(new EntryMissing(disk));
                        continue;
                    }
                    disk.setStatus(EntityStatus.OK);
                    report_subject.add(new EntryOK(disk));
                    disks_found.add(found_entry);
                }
                if (!this.ignore_unneeded_entries) {
                    List unneeded = container.getEntries().stream().filter(Scan.not(new HashSet(disks_found)::contains)).collect(Collectors.toList());
                    for (Entry unneeded_entry : unneeded) {
                        report_subject.add(new EntryUnneeded(unneeded_entry));
                        rename_before_set = OpenContainer.getInstance(rename_before_set, directory, this.format, 0L);
                        rename_before_set.addAction(new RenameEntry(unneeded_entry));
                        delete_set = OpenContainer.getInstance(delete_set, directory, this.format, 0L);
                        delete_set.addAction(new DeleteEntry(unneeded_entry));
                    }
                }
                ContainerAction.addToList(this.rename_before_actions, rename_before_set);
                ContainerAction.addToList(this.add_actions, add_set);
                ContainerAction.addToList(this.duplicate_actions, duplicate_set);
                ContainerAction.addToList(this.delete_actions, delete_set);
                ContainerAction.addToList(this.rename_after_actions, rename_after_set);
            }
        } else {
            for (Disk disk : disks) {
                disk.setStatus(EntityStatus.KO);
            }
            if (this.create_mode && disks.size() > 0) {
                int disks_found = 0;
                boolean partial_set = false;
                CreateContainer createset = null;
                for (Disk disk : disks) {
                    ++Scan.report.stats.missing_disks_cnt;
                    Entry found_entry = null;
                    for (DirScan scan : this.allscans) {
                        found_entry = scan.find_byhash(disk);
                        if (null == found_entry) continue;
                        report_subject.add(new EntryAdd(disk, found_entry));
                        createset = CreateContainer.getInstance(createset, directory, this.format, 0L);
                        createset.addAction(new AddEntry(disk, found_entry));
                        ++disks_found;
                        break;
                    }
                    if (found_entry != null) continue;
                    report_subject.add(new EntryMissing(disk));
                    partial_set = true;
                }
                if (!(disks_found <= 0 || this.createfull_mode && partial_set)) {
                    report_subject.setCreateFull();
                    if (partial_set) {
                        report_subject.setCreate();
                    }
                    ContainerAction.addToList(this.create_actions, createset);
                }
            }
        }
        return missing_set;
    }

    private boolean scanRoms(Anyware ware, List<Rom> roms, Container archive, SubjectSet report_subject) {
        boolean missing_set = true;
        Container container = this.roms_dstscan.getContainerByName(ware.getDest(this.merge_mode, this.implicit_merge).getNormalizedName() + (Object)((Object)this.format.getExt()));
        if (null != container) {
            missing_set = false;
            if (roms.size() > 0) {
                report_subject.setFound();
                ArrayList<Entry> roms_found = new ArrayList<Entry>();
                Map<String, Rom> roms_byname = Rom.getRomsByName(roms);
                BackupContainer backup_set = null;
                OpenContainer add_set = null;
                OpenContainer delete_set = null;
                OpenContainer rename_before_set = null;
                ContainerAction rename_after_set = null;
                OpenContainer duplicate_set = null;
                for (Rom rom : roms) {
                    rom.setStatus(EntityStatus.KO);
                    Entry found_entry = null;
                    Map<String, Entry> entries_byname = container.getEntriesByName();
                    for (Entry candidate_entry : container.getEntries()) {
                        String efile = candidate_entry.getName();
                        if (candidate_entry.equals(rom)) {
                            if (!rom.getNormalizedName().equals(efile)) {
                                Rom another_rom = roms_byname.get(efile);
                                if (null != another_rom && candidate_entry.equals(another_rom)) {
                                    if (entries_byname.containsKey(rom.getNormalizedName())) continue;
                                    report_subject.add(new EntryMissingDuplicate(rom, candidate_entry));
                                    duplicate_set = OpenContainer.getInstance(duplicate_set, archive, this.format, roms.stream().mapToLong(Entity::getSize).sum());
                                    duplicate_set.addAction(new DuplicateEntry(rom.getName(), candidate_entry));
                                    found_entry = candidate_entry;
                                    break;
                                }
                                if (entries_byname.containsKey(rom.getNormalizedName())) continue;
                                report_subject.add(new EntryWrongName(rom, candidate_entry));
                                backup_set = BackupContainer.getInstance(backup_set, archive);
                                backup_set.addAction(new BackupEntry(candidate_entry));
                                duplicate_set = OpenContainer.getInstance(duplicate_set, archive, this.format, roms.stream().mapToLong(Entity::getSize).sum());
                                duplicate_set.addAction(new DuplicateEntry(rom.getName(), candidate_entry));
                                delete_set = OpenContainer.getInstance(delete_set, archive, this.format, roms.stream().mapToLong(Entity::getSize).sum());
                                delete_set.addAction(new DeleteEntry(candidate_entry));
                                found_entry = candidate_entry;
                                break;
                            }
                            found_entry = candidate_entry;
                            break;
                        }
                        if (!rom.getNormalizedName().equals(efile)) continue;
                        report_subject.add(new EntryWrongHash(rom, candidate_entry));
                        break;
                    }
                    if (found_entry == null) {
                        ++Scan.report.stats.missing_roms_cnt;
                        for (DirScan scan : this.allscans) {
                            found_entry = scan.find_byhash(rom);
                            if (null == found_entry) continue;
                            report_subject.add(new EntryAdd(rom, found_entry));
                            add_set = OpenContainer.getInstance(add_set, archive, this.format, roms.stream().mapToLong(Entity::getSize).sum());
                            add_set.addAction(new AddEntry(rom, found_entry));
                            break;
                        }
                        if (found_entry != null) continue;
                        report_subject.add(new EntryMissing(rom));
                        continue;
                    }
                    rom.setStatus(EntityStatus.OK);
                    report_subject.add(new EntryOK(rom));
                    roms_found.add(found_entry);
                }
                if (!this.ignore_unneeded_entries) {
                    List unneeded = container.getEntries().stream().filter(Scan.not(new HashSet(roms_found)::contains)).collect(Collectors.toList());
                    for (Entry unneeded_entry : unneeded) {
                        report_subject.add(new EntryUnneeded(unneeded_entry));
                        backup_set = BackupContainer.getInstance(backup_set, archive);
                        backup_set.addAction(new BackupEntry(unneeded_entry));
                        rename_before_set = OpenContainer.getInstance(rename_before_set, archive, this.format, roms.stream().mapToLong(Entity::getSize).sum());
                        rename_before_set.addAction(new RenameEntry(unneeded_entry));
                        delete_set = OpenContainer.getInstance(delete_set, archive, this.format, roms.stream().mapToLong(Entity::getSize).sum());
                        delete_set.addAction(new DeleteEntry(unneeded_entry));
                    }
                }
                ContainerAction.addToList(this.backup_actions, backup_set);
                ContainerAction.addToList(this.rename_before_actions, rename_before_set);
                ContainerAction.addToList(this.add_actions, add_set);
                ContainerAction.addToList(this.duplicate_actions, duplicate_set);
                ContainerAction.addToList(this.delete_actions, delete_set);
                ContainerAction.addToList(this.rename_after_actions, rename_after_set);
            }
        } else {
            for (Rom rom : roms) {
                rom.setStatus(EntityStatus.KO);
            }
            if (this.create_mode && roms.size() > 0) {
                int roms_found = 0;
                boolean partial_set = false;
                CreateContainer createset = null;
                for (Rom rom : roms) {
                    ++Scan.report.stats.missing_roms_cnt;
                    Entry entry_found = null;
                    for (DirScan scan : this.allscans) {
                        entry_found = scan.find_byhash(rom);
                        if (null == entry_found) continue;
                        report_subject.add(new EntryAdd(rom, entry_found));
                        createset = CreateContainer.getInstance(createset, archive, this.format, roms.stream().mapToLong(Entity::getSize).sum());
                        createset.addAction(new AddEntry(rom, entry_found));
                        ++roms_found;
                        break;
                    }
                    if (entry_found != null) continue;
                    report_subject.add(new EntryMissing(rom));
                    partial_set = true;
                }
                if (!(roms_found <= 0 || this.createfull_mode && partial_set)) {
                    report_subject.setCreateFull();
                    if (partial_set) {
                        report_subject.setCreate();
                    }
                    ContainerAction.addToList(this.create_actions, createset);
                }
            }
        }
        return missing_set;
    }

    private void scanSamples(Samples set) {
        SubjectSet report_subject;
        boolean missing_set = true;
        Container archive = this.format.getExt().isDir() ? new Directory(new File(this.samples_dstscan.getDir(), set.getName()), set) : new Archive(new File(this.samples_dstscan.getDir(), set.getName() + (Object)((Object)this.format.getExt())), set);
        if (!this.scanSamples(set, archive, report_subject = new SubjectSet(set))) {
            missing_set = false;
        }
        if (this.create_mode && report_subject.getStatus() == SubjectSet.Status.UNKNOWN) {
            report_subject.setMissing();
        }
        if (missing_set) {
            ++Scan.report.stats.missing_set_cnt;
        }
        if (report_subject.getStatus() != SubjectSet.Status.UNKNOWN) {
            report.add(report_subject);
        }
        this.prepTZip(report_subject, archive, set);
    }

    private boolean scanSamples(Samples set, Container archive, SubjectSet report_subject) {
        boolean missing_set = true;
        Container container = this.samples_dstscan.getContainerByName(archive.file.getName());
        if (null != container) {
            missing_set = false;
            report_subject.setFound();
            ArrayList<Entry> samples_found = new ArrayList<Entry>();
            ContainerAction add_set = null;
            OpenContainer delete_set = null;
            OpenContainer rename_before_set = null;
            ContainerAction rename_after_set = null;
            ContainerAction duplicate_set = null;
            for (Object sample : set) {
                ((EntityBase)sample).setStatus(EntityStatus.KO);
                Entry found_entry = null;
                for (Entry candidate_entry : container.getEntries()) {
                    if (!candidate_entry.equals(sample)) continue;
                    found_entry = candidate_entry;
                    break;
                }
                if (found_entry == null) {
                    ++Scan.report.stats.missing_samples_cnt;
                    block2: for (DirScan scan : this.allscans) {
                        for (FormatOptions.Ext ext : EnumSet.allOf(FormatOptions.Ext.class)) {
                            Container found_container = scan.getContainerByName(set.getName() + (Object)((Object)ext));
                            if (null != found_container) {
                                for (Entry entry : found_container.entries_byname.values()) {
                                    if (entry.getName().equals(((NameBase)sample).getNormalizedName())) {
                                        found_entry = entry;
                                    }
                                    if (null == found_entry) continue;
                                    break;
                                }
                            }
                            if (null == found_entry) continue;
                            continue block2;
                        }
                    }
                    if (found_entry != null) continue;
                    report_subject.add(new EntryMissing((EntityBase)sample));
                    continue;
                }
                ((EntityBase)sample).setStatus(EntityStatus.OK);
                report_subject.add(new EntryOK((EntityBase)sample));
                samples_found.add(found_entry);
            }
            if (!this.ignore_unneeded_entries) {
                List unneeded = container.getEntries().stream().filter(Scan.not(new HashSet(samples_found)::contains)).collect(Collectors.toList());
                for (Entry unneeded_entry : unneeded) {
                    report_subject.add(new EntryUnneeded(unneeded_entry));
                    rename_before_set = OpenContainer.getInstance(rename_before_set, archive, this.format, Long.MAX_VALUE);
                    rename_before_set.addAction(new RenameEntry(unneeded_entry));
                    delete_set = OpenContainer.getInstance(delete_set, archive, this.format, Long.MAX_VALUE);
                    delete_set.addAction(new DeleteEntry(unneeded_entry));
                }
            }
            ContainerAction.addToList(this.rename_before_actions, rename_before_set);
            ContainerAction.addToList(this.add_actions, add_set);
            ContainerAction.addToList(this.duplicate_actions, duplicate_set);
            ContainerAction.addToList(this.delete_actions, delete_set);
            ContainerAction.addToList(this.rename_after_actions, rename_after_set);
        } else {
            for (Sample sample : set) {
                sample.setStatus(EntityStatus.KO);
            }
            if (this.create_mode) {
                int samples_found = 0;
                boolean partial_set = false;
                CreateContainer createset = null;
                for (Sample sample : set) {
                    ++Scan.report.stats.missing_samples_cnt;
                    Entry entry_found = null;
                    for (DirScan scan : this.allscans) {
                        for (FormatOptions.Ext ext : EnumSet.allOf(FormatOptions.Ext.class)) {
                            Container found_container = scan.getContainerByName(set.getName() + (Object)((Object)ext));
                            if (null != found_container) {
                                for (Entry entry : found_container.entries_byname.values()) {
                                    if (entry.getName().equals(sample.getNormalizedName())) {
                                        entry_found = entry;
                                    }
                                    if (null == entry_found) continue;
                                    break;
                                }
                            }
                            if (null == entry_found) continue;
                            break;
                        }
                        if (null == entry_found) continue;
                        report_subject.add(new EntryAdd(sample, entry_found));
                        createset = CreateContainer.getInstance(createset, archive, this.format, Long.MAX_VALUE);
                        createset.addAction(new AddEntry(sample, entry_found));
                        ++samples_found;
                        break;
                    }
                    if (entry_found != null) continue;
                    report_subject.add(new EntryMissing(sample));
                    partial_set = true;
                }
                if (!(samples_found <= 0 || this.createfull_mode && partial_set)) {
                    report_subject.setCreateFull();
                    if (partial_set) {
                        report_subject.setCreate();
                    }
                    ContainerAction.addToList(this.create_actions, createset);
                }
            }
        }
        return missing_set;
    }

    private void scanWare(Anyware ware) {
        SubjectSet report_subject = new SubjectSet(ware);
        boolean missing_set = true;
        Directory directory = new Directory(new File(this.disks_dstscan.getDir(), ware.getDest(this.merge_mode, this.implicit_merge).getName()), ware);
        Container archive = this.format.getExt().isDir() ? new Directory(new File(this.roms_dstscan.getDir(), ware.getDest(this.merge_mode, this.implicit_merge).getName()), ware) : new Archive(new File(this.roms_dstscan.getDir(), ware.getDest(this.merge_mode, this.implicit_merge).getName() + (Object)((Object)this.format.getExt())), ware);
        List<Rom> roms = ware.filterRoms(this.merge_mode, this.hash_collision_mode);
        List<Disk> disks = ware.filterDisks(this.merge_mode, this.hash_collision_mode);
        if (!this.scanRoms(ware, roms, archive, report_subject)) {
            missing_set = false;
        }
        this.prepTZip(report_subject, archive, ware, roms);
        if (!this.scanDisks(ware, disks, directory, report_subject)) {
            missing_set = false;
        }
        if (roms.size() == 0 && disks.size() == 0) {
            if (!this.merge_mode.isMerge() || !ware.isClone()) {
                if (!missing_set) {
                    report_subject.setUnneeded();
                } else {
                    report_subject.setFound();
                }
            }
            missing_set = false;
        } else if (this.create_mode && report_subject.getStatus() == SubjectSet.Status.UNKNOWN) {
            report_subject.setMissing();
        }
        if (!this.ignore_unneeded_containers) {
            this.removeUnneededClone(ware, disks, roms);
            this.removeOtherFormats(ware);
        }
        if (missing_set) {
            ++Scan.report.stats.missing_set_cnt;
        }
        if (report_subject.getStatus() != SubjectSet.Status.UNKNOWN) {
            report.add(report_subject);
        }
    }
}

