/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jrm.profile.Profile;
import jrm.profile.data.AnywareBase;
import jrm.profile.data.AnywareStatus;
import jrm.profile.data.Disk;
import jrm.profile.data.Entity;
import jrm.profile.data.EntityBase;
import jrm.profile.data.EntityStatus;
import jrm.profile.data.Rom;
import jrm.profile.data.Sample;
import jrm.profile.data.Systm;
import jrm.profile.scan.options.HashCollisionOptions;
import jrm.profile.scan.options.MergeOptions;
import jrm.ui.basic.EnhTableModel;
import jrm.ui.profile.data.AnywareRenderer;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.StreamEx;

public abstract class Anyware
extends AnywareBase
implements Serializable,
EnhTableModel,
Systm {
    public String cloneof = null;
    public final StringBuffer description = new StringBuffer();
    public final StringBuffer year = new StringBuffer();
    public final Collection<Rom> roms = new ArrayList<Rom>();
    public final Collection<Disk> disks = new ArrayList<Disk>();
    public final Collection<Sample> samples = new ArrayList<Sample>();
    public final HashMap<String, Anyware> clones = new HashMap();
    public boolean selected = true;
    public static transient MergeOptions merge_mode;
    public static transient Boolean implicit_merge;
    public static transient HashCollisionOptions hash_collision_mode;
    protected transient boolean collision;
    private static transient EventListenerList listenerList;
    private static transient EnumSet<EntityStatus> filter;
    private transient List<EntityBase> table_entities;

    public Anyware() {
        this.initTransient();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransient();
    }

    private void initTransient() {
        if (merge_mode == null) {
            merge_mode = MergeOptions.SPLIT;
        }
        if (implicit_merge == null) {
            implicit_merge = false;
        }
        if (hash_collision_mode == null) {
            hash_collision_mode = HashCollisionOptions.SINGLEFILE;
        }
        this.collision = false;
        this.table_entities = null;
        if (listenerList == null) {
            listenerList = new EventListenerList();
        }
        if (filter == null) {
            filter = EnumSet.allOf(EntityStatus.class);
        }
    }

    public boolean isCollisionMode() {
        return this.collision;
    }

    public void setCollisionMode(boolean parent) {
        if (parent) {
            this.getDest().clones.forEach((n, m) -> {
                m.collision = true;
            });
        }
        this.collision = true;
    }

    public void resetCollisionMode() {
        this.collision = false;
        this.roms.forEach(Entity::resetCollisionMode);
        this.disks.forEach(Entity::resetCollisionMode);
    }

    public boolean isClone() {
        return this.parent != null && !this.getParent().isBios();
    }

    public Anyware getDest(MergeOptions merge_mode, boolean implicit_merge) {
        Anyware.merge_mode = merge_mode;
        Anyware.implicit_merge = implicit_merge;
        return this.getDest();
    }

    private Anyware getDest() {
        if (merge_mode.isMerge() && this.isClone()) {
            return this.getParent().getDest();
        }
        return this;
    }

    public abstract boolean isBios();

    public abstract boolean isRomOf();

    public List<Disk> filterDisks(MergeOptions merge_mode, HashCollisionOptions hash_collision_mode) {
        AbstractStreamEx stream;
        Anyware.merge_mode = merge_mode;
        Anyware.hash_collision_mode = hash_collision_mode;
        if (!this.selected) {
            stream = Stream.empty();
        } else if (merge_mode.isMerge()) {
            if (this.isClone() && this.getParent().selected) {
                stream = Stream.empty();
            } else {
                List disks_with_clones = Stream.concat(this.disks.stream(), this.clones.values().stream().flatMap(m -> m.disks.stream())).collect(Collectors.toList());
                StreamEx.of(disks_with_clones).groupingBy(Disk::getName).forEach((n, l) -> {
                    if (l.size() > 1 && ((StreamEx)StreamEx.of((Collection)l).distinct(Disk::hashString)).count() > 1L) {
                        l.forEach(Entity::setCollisionMode);
                    }
                });
                stream = StreamEx.of(disks_with_clones).distinct(Disk::getName);
            }
        } else {
            stream = this.disks.stream();
        }
        return stream.filter(d -> {
            if (d.status == Entity.Status.nodump) {
                return false;
            }
            if (merge_mode == MergeOptions.SPLIT && Anyware.containsInParent(this, d)) {
                return false;
            }
            if (merge_mode == MergeOptions.NOMERGE && Anyware.containsInParent(this, d)) {
                return true;
            }
            return this.isBios() || !Anyware.containsInParent(this, d);
        }).collect(Collectors.toList());
    }

    public List<Rom> filterRoms(MergeOptions merge_mode, HashCollisionOptions hash_collision_mode) {
        Object stream;
        Anyware.merge_mode = merge_mode;
        Anyware.hash_collision_mode = hash_collision_mode;
        if (!this.selected) {
            stream = Stream.empty();
        } else if (merge_mode.isMerge()) {
            if (this.isClone() && this.getParent().selected) {
                stream = Stream.empty();
            } else {
                List roms_with_clones = Stream.concat(this.roms.stream(), this.clones.values().stream().flatMap(m -> m.roms.stream())).collect(Collectors.toList());
                StreamEx.of(roms_with_clones).groupingBy(Rom::getName).forEach((n, l) -> {
                    if (l.size() > 1 && ((StreamEx)StreamEx.of((Collection)l).distinct(Rom::hashString)).count() > 1L) {
                        l.forEach(Entity::setCollisionMode);
                    }
                });
                if (HashCollisionOptions.HALFDUMB == hash_collision_mode) {
                    LinkedHashMap map = new LinkedHashMap();
                    this.roms.forEach(r -> map.put(r.hashString(), r));
                    this.clones.values().stream().sorted().forEach(w -> w.roms.stream().sorted().forEach(r -> map.putIfAbsent(r.hashString(), r)));
                    ArrayList clones_roms = new ArrayList(map.values());
                    clones_roms.removeAll(this.roms);
                    stream = Stream.concat(this.roms.stream(), clones_roms.stream());
                } else {
                    stream = StreamEx.of(roms_with_clones).distinct(Rom::getName);
                }
            }
        } else {
            stream = merge_mode.equals((Object)MergeOptions.SUPERFULLNOMERGE) ? (Profile.curr_profile.getProperty("exclude_games", false) ? (Profile.curr_profile.getProperty("exclude_machines", false) ? this.streamWithDevices(true, false, true) : this.streamWithDevices(true, false, true)) : this.streamWithDevices(false, true, false)) : this.roms.stream();
        }
        return stream.filter(r -> {
            if (r.status == Entity.Status.nodump) {
                return false;
            }
            if (r.crc == null) {
                return false;
            }
            if (r.name.isEmpty()) {
                return false;
            }
            if (merge_mode == MergeOptions.SUPERFULLNOMERGE) {
                return true;
            }
            if (merge_mode == MergeOptions.FULLNOMERGE) {
                return true;
            }
            if (merge_mode == MergeOptions.FULLMERGE) {
                return true;
            }
            if (merge_mode == MergeOptions.SPLIT && Anyware.containsInParent(this, r, false)) {
                return false;
            }
            if (merge_mode == MergeOptions.NOMERGE && Anyware.containsInParent(this, r, true)) {
                return false;
            }
            if (merge_mode == MergeOptions.NOMERGE && Anyware.wouldMerge(this, r)) {
                return true;
            }
            if (merge_mode == MergeOptions.MERGE && Anyware.containsInParent(this, r, true)) {
                return false;
            }
            if (merge_mode == MergeOptions.MERGE && Anyware.wouldMerge(this, r)) {
                return true;
            }
            return this.isBios() || !Anyware.containsInParent(this, r, false);
        }).collect(Collectors.toList());
    }

    abstract Stream<Rom> streamWithDevices(boolean var1, boolean var2, boolean var3);

    public static <T> Stream<T> streamInReverse(List<T> input) {
        return IntStream.range(1, input.size() + 1).mapToObj(i -> input.get(input.size() - i));
    }

    public static boolean wouldMerge(Anyware ware, Entity e) {
        return e.merge != null && ware.isRomOf() && ware.getParent() != null && ware.getParent().selected;
    }

    public static boolean containsInParent(Anyware ware, Rom r, boolean onlyBios) {
        if ((r.merge != null || implicit_merge.booleanValue()) && ware.getParent() != null && ware.getParent().selected) {
            if ((!onlyBios || ware.getParent().isBios()) && ware.getParent().roms.contains(r)) {
                return true;
            }
            return Anyware.containsInParent(ware.getParent(), r, onlyBios);
        }
        return false;
    }

    public static boolean containsInParent(Anyware ware, Disk d) {
        if ((d.merge != null || implicit_merge.booleanValue()) && ware.getParent() != null && ware.getParent().selected) {
            if (ware.getParent().disks.contains(d)) {
                return true;
            }
            return Anyware.containsInParent(ware.getParent(), d);
        }
        return false;
    }

    public void reset() {
        this.table_entities = null;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void setFilter(EnumSet<EntityStatus> filter) {
        Anyware.filter = filter;
        this.reset();
    }

    private List<EntityBase> getEntities() {
        if (this.table_entities == null) {
            this.table_entities = Stream.of(this.roms.stream(), this.disks.stream(), this.samples.stream()).flatMap(s -> s).filter(t -> filter.contains(t.getStatus())).sorted().collect(Collectors.toList());
        }
        return this.table_entities;
    }

    @Override
    public int getRowCount() {
        return this.getEntities().size();
    }

    @Override
    public int getColumnCount() {
        return AnywareRenderer.columns.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return AnywareRenderer.columns[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return AnywareRenderer.columnsTypes[columnIndex];
    }

    @Override
    public TableCellRenderer getColumnRenderer(int columnIndex) {
        return columnIndex < AnywareRenderer.columnsRenderers.length && AnywareRenderer.columnsRenderers[columnIndex] != null ? AnywareRenderer.columnsRenderers[columnIndex] : new DefaultTableCellRenderer();
    }

    @Override
    public TableCellRenderer[] getCellRenderers() {
        return AnywareRenderer.columnsRenderers;
    }

    @Override
    public int getColumnWidth(int columnIndex) {
        return AnywareRenderer.columnsWidths[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getEntities().get(rowIndex);
            }
            case 1: {
                return this.getEntities().get(rowIndex);
            }
            case 2: {
                return this.getEntities().get(rowIndex).getProperty("size");
            }
            case 3: {
                return this.getEntities().get(rowIndex).getProperty("crc");
            }
            case 4: {
                return this.getEntities().get(rowIndex).getProperty("md5");
            }
            case 5: {
                return this.getEntities().get(rowIndex).getProperty("sha1");
            }
            case 6: {
                return this.getEntities().get(rowIndex).getProperty("merge");
            }
            case 7: {
                return this.getEntities().get(rowIndex).getProperty("status");
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        listenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        listenerList.remove(TableModelListener.class, l);
    }

    public void fireTableChanged(TableModelEvent e) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    @Override
    public AnywareStatus getStatus() {
        EntityStatus estatus;
        AnywareStatus status = AnywareStatus.COMPLETE;
        boolean ok = false;
        for (Disk disk : this.disks) {
            estatus = disk.getStatus();
            if (estatus == EntityStatus.KO) {
                status = AnywareStatus.PARTIAL;
                continue;
            }
            if (estatus == EntityStatus.OK) {
                ok = true;
                continue;
            }
            if (estatus != EntityStatus.UNKNOWN) continue;
            status = AnywareStatus.UNKNOWN;
            break;
        }
        for (Rom rom : this.roms) {
            estatus = rom.getStatus();
            if (estatus == EntityStatus.KO) {
                status = AnywareStatus.PARTIAL;
                continue;
            }
            if (estatus == EntityStatus.OK) {
                ok = true;
                continue;
            }
            if (estatus != EntityStatus.UNKNOWN) continue;
            status = AnywareStatus.UNKNOWN;
            break;
        }
        for (Sample sample : this.samples) {
            estatus = sample.getStatus();
            if (estatus == EntityStatus.KO) {
                status = AnywareStatus.PARTIAL;
                continue;
            }
            if (estatus == EntityStatus.OK) {
                ok = true;
                continue;
            }
            if (estatus != EntityStatus.UNKNOWN) continue;
            status = AnywareStatus.UNKNOWN;
            break;
        }
        if (status == AnywareStatus.PARTIAL && !ok) {
            status = AnywareStatus.MISSING;
        }
        return status;
    }

    public int countHave() {
        return this.countHaveRoms() + this.countHaveDisks() + this.countHaveSamples();
    }

    public int countHaveRoms() {
        return this.roms.stream().mapToInt(r -> r.getStatus() == EntityStatus.OK ? 1 : 0).sum();
    }

    public int countHaveDisks() {
        return this.disks.stream().mapToInt(d -> d.getStatus() == EntityStatus.OK ? 1 : 0).sum();
    }

    public int countHaveSamples() {
        return this.samples.stream().mapToInt(s -> s.getStatus() == EntityStatus.OK ? 1 : 0).sum();
    }

    public int countAll() {
        return this.roms.size() + this.disks.size() + this.samples.size();
    }

    @Override
    public Anyware getParent() {
        return this.getParent(Anyware.class);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Anyware) {
            return this.name.equals(((Anyware)obj).name);
        }
        return super.equals(obj);
    }

    static {
        filter = null;
    }
}

