/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.tasks.internal;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.ide.visualstudio.TextProvider;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.plugins.ide.internal.generator.AbstractPersistableConfigurationObject;
import org.gradle.util.internal.TextUtil;

public class VisualStudioSolutionFile
extends AbstractPersistableConfigurationObject {
    private final List<Action<? super TextProvider>> actions = new ArrayList<Action<? super TextProvider>>();
    private final Map<File, String> projects = new LinkedHashMap<File, String>();
    private final Map<File, Set<ConfigurationSpec>> projectConfigurations = new LinkedHashMap<File, Set<ConfigurationSpec>>();
    private String baseText;

    protected String getDefaultResourceName() {
        return "default.sln";
    }

    public List<Action<? super TextProvider>> getActions() {
        return this.actions;
    }

    public void setProjects(List<ProjectSpec> projects) {
        for (ProjectSpec project : projects) {
            this.projects.put(project.projectFile, project.name);
            Set configs = this.projectConfigurations.computeIfAbsent(project.projectFile, f -> new HashSet());
            configs.addAll(project.configurations);
        }
    }

    public void load(InputStream inputStream) throws Exception {
        try (Scanner scanner = new Scanner(inputStream, StandardCharsets.UTF_8.name());){
            this.baseText = scanner.useDelimiter("\\A").next();
        }
    }

    public void store(OutputStream outputStream) {
        SimpleTextProvider provider = new SimpleTextProvider();
        this.generateContent(provider.asBuilder());
        for (Action<? super TextProvider> action : this.actions) {
            action.execute((Object)provider);
        }
        String text = TextUtil.convertLineSeparators((String)provider.getText(), (String)TextUtil.getWindowsLineSeparator());
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        try {
            writer.write(text);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    private void generateContent(StringBuilder builder) {
        builder.append(this.baseText);
        for (Map.Entry<File, String> project : this.projects.entrySet()) {
            File projectFile = project.getKey();
            String projectName = project.getValue();
            builder.append("\nProject(\"{8BC9CEB8-8B4A-11D0-8D11-00A0C91BC942}\") = \"" + projectName + "\", \"" + projectFile.getAbsolutePath() + "\", \"" + DefaultVisualStudioProject.getUUID(projectFile) + "\"\nEndProject");
        }
        builder.append("\nGlobal\n\tGlobalSection(SolutionConfigurationPlatforms) = preSolution");
        Set configurationNames = this.projectConfigurations.values().stream().flatMap(set -> set.stream().map(spec -> ((ConfigurationSpec)spec).name)).collect(Collectors.toCollection(TreeSet::new));
        for (String configurationName2 : configurationNames) {
            builder.append("\n\t\t").append(configurationName2).append(" = ").append(configurationName2);
        }
        builder.append("\n\tEndGlobalSection\n\tGlobalSection(ProjectConfigurationPlatforms) = postSolution");
        for (File projectFile : this.projects.keySet()) {
            List configurations = configurationNames.stream().flatMap(configurationName -> {
                ArrayList<String> result = new ArrayList<String>();
                ConfigurationSpec configuration = this.projectConfigurations.get(projectFile).stream().filter(spec -> ((ConfigurationSpec)spec).name.equals(configurationName)).findFirst().orElse(null);
                ConfigurationSpec lastConfiguration = this.projectConfigurations.get(projectFile).stream().sorted(Comparator.comparing(ConfigurationSpec::getName)).reduce((first, second) -> second).orElse(null);
                if (configuration == null) {
                    result.add(configurationName + ".ActiveCfg = " + lastConfiguration.name);
                } else {
                    result.add(configurationName + ".ActiveCfg = " + configuration.name);
                    if (configuration.buildable) {
                        result.add(configurationName + ".Build.0 = " + configuration.name);
                    }
                }
                return result.stream();
            }).collect(Collectors.toList());
            for (String configuration : configurations) {
                builder.append("\n\t\t").append(DefaultVisualStudioProject.getUUID(projectFile)).append(".").append(configuration);
            }
        }
        builder.append("\n\tEndGlobalSection\n\tGlobalSection(SolutionProperties) = preSolution\n\t\tHideSolutionNode = FALSE\n\tEndGlobalSection\nEndGlobal\n");
    }

    public static class ProjectSpec {
        private final String name;
        @VisibleForTesting
        final File projectFile;
        private final List<ConfigurationSpec> configurations;

        public ProjectSpec(String name, File projectFile, List<ConfigurationSpec> configurations) {
            this.name = name;
            this.projectFile = projectFile;
            this.configurations = configurations;
        }

        @Input
        public String getName() {
            return this.name;
        }

        @Input
        public String getProjectFilePath() {
            return this.projectFile.getAbsolutePath();
        }

        @Nested
        public List<ConfigurationSpec> getConfigurations() {
            return this.configurations;
        }
    }

    private static class SimpleTextProvider
    implements TextProvider {
        private final StringBuilder builder = new StringBuilder();

        private SimpleTextProvider() {
        }

        @Override
        public StringBuilder asBuilder() {
            return this.builder;
        }

        @Override
        public String getText() {
            return this.builder.toString();
        }

        @Override
        public void setText(String value) {
            this.builder.replace(0, this.builder.length(), value);
        }
    }

    public static class ConfigurationSpec {
        private final String name;
        private final boolean buildable;

        public ConfigurationSpec(String name, boolean buildable) {
            this.name = name;
            this.buildable = buildable;
        }

        @Input
        String getName() {
            return this.name;
        }

        @Input
        public boolean getBuildable() {
            return this.buildable;
        }
    }
}

