/*
 * Decompiled with CFR 0.152.
 */
package megamek.server.victory;

import java.io.Serializable;
import java.util.HashMap;
import megamek.common.IGame;
import megamek.common.Report;
import megamek.server.victory.Victory;
import megamek.server.victory.VictoryResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SummingThresholdVictory
implements Victory,
Serializable {
    private static final long serialVersionUID = 7211998189207932320L;
    protected Victory[] vs;
    protected int thr;

    public SummingThresholdVictory(int n, Victory[] victoryArray) {
        this.vs = victoryArray;
        this.thr = n;
    }

    @Override
    public Victory.Result victory(IGame iGame, HashMap<String, Object> hashMap) {
        boolean bl = false;
        VictoryResult victoryResult = new VictoryResult(true);
        for (Victory victory : this.vs) {
            Victory.Result result = victory.victory(iGame, hashMap);
            for (Report report : result.getReports()) {
                victoryResult.addReport(report);
            }
            if (result.victory()) {
                bl = true;
            }
            for (Object object : (Object)result.getPlayers()) {
                victoryResult.addPlayerScore((int)object, victoryResult.getPlayerScore((int)object) + result.getPlayerScore((int)object));
            }
            for (Object object : (Object)result.getTeams()) {
                victoryResult.addTeamScore((int)object, victoryResult.getTeamScore((int)object) + result.getTeamScore((int)object));
            }
        }
        double d = 0.0;
        for (int n : victoryResult.getPlayers()) {
            double d2 = victoryResult.getPlayerScore(n);
            victoryResult.addPlayerScore(n, d2 / (double)this.vs.length);
            if (!(d2 > d)) continue;
            d = d2;
        }
        for (int n : victoryResult.getTeams()) {
            double d3 = victoryResult.getTeamScore(n);
            victoryResult.addTeamScore(n, d3 / (double)this.vs.length);
            if (!(d3 > d)) continue;
            d = d3;
        }
        if (d < (double)this.thr) {
            bl = false;
        }
        victoryResult.setVictory(bl);
        return victoryResult;
    }
}

