/*
 * Decompiled with CFR 0.152.
 */
package megamek.server.commands;

import megamek.server.Server;
import megamek.server.commands.ServerCommand;

public class NukeCommand
extends ServerCommand {
    public NukeCommand(Server server) {
        super(server, "nuke", "Drops a nuke onto the board, to be exploded atthe end of the next weapons attack phase.");
    }

    public void run(int n, String[] stringArray) {
        if (!this.server.getGame().getOptions().booleanOption("really_allow_nukes") || !this.server.getGame().getOptions().booleanOption("allow_nukes")) {
            this.server.sendServerChat(n, "Command-line nukes are not enabled in this game.");
            return;
        }
        if (stringArray.length == 4) {
            try {
                int[] nArray = new int[3];
                for (int i = 1; i < 4; ++i) {
                    nArray[i - 1] = Integer.parseInt(stringArray[i]);
                }
                if (!this.server.getGame().getBoard().contains(nArray[0] - 1, nArray[1] - 1)) {
                    this.server.sendServerChat(n, "Specified hex is not on the board.");
                    return;
                }
                this.server.addScheduledNuke(nArray);
                this.server.sendServerChat(n, "A nuke is incoming!  Take cover!");
            }
            catch (Exception exception) {
                this.server.sendServerChat(n, "Nuke command failed (1).  Proper format is \"/nuke <x> <y> <type>\" or \"/nuke <x> <y> <damage> <degredation> <secondary radius> <craterdepth>\"");
            }
        } else if (stringArray.length == 7) {
            try {
                int[] nArray = new int[6];
                for (int i = 1; i < 7; ++i) {
                    nArray[i - 1] = Integer.parseInt(stringArray[i]);
                }
                if (!this.server.getGame().getBoard().contains(nArray[0] - 1, nArray[1] - 1)) {
                    this.server.sendServerChat(n, "Specified hex is not on the board.");
                    return;
                }
                this.server.addScheduledNuke(nArray);
                this.server.sendServerChat(n, "A nuke is incoming!  Take cover!");
            }
            catch (Exception exception) {
                this.server.sendServerChat(n, "Nuke command failed (2).  Proper format is \"/nuke <x> <y> <type>\" or \"/nuke <x> <y> <damage> <degredation> <secondary radius> <craterdepth>\"");
            }
        } else {
            this.server.sendServerChat(n, "Nuke command failed (3).  Proper format is \"/nuke <x> <y> <type>\" or \"/nuke <x> <y> <damage> <degredation> <secondary radius> <craterdepth>\"");
        }
    }
}

