/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import megamek.common.ASFBay;
import megamek.common.Aero;
import megamek.common.AmmoType;
import megamek.common.ArtilleryTracker;
import megamek.common.BattleArmor;
import megamek.common.BattleArmorHandles;
import megamek.common.Bay;
import megamek.common.BipedMech;
import megamek.common.BombType;
import megamek.common.Building;
import megamek.common.BuildingTarget;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.CriticalSlot;
import megamek.common.DockingCollar;
import megamek.common.Dropship;
import megamek.common.Engine;
import megamek.common.EntitySelector;
import megamek.common.EntityWeightClass;
import megamek.common.EquipmentType;
import megamek.common.FighterSquadron;
import megamek.common.HexTarget;
import megamek.common.HitData;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.INarcPod;
import megamek.common.Infantry;
import megamek.common.InfernoTracker;
import megamek.common.Jumpship;
import megamek.common.LargeSupportTank;
import megamek.common.LocationFullException;
import megamek.common.LosEffects;
import megamek.common.Mech;
import megamek.common.MechWarrior;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.MoveStep;
import megamek.common.NarcPod;
import megamek.common.Pilot;
import megamek.common.PilotingRollData;
import megamek.common.PlanetaryConditions;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.Report;
import megamek.common.RoundUpdated;
import megamek.common.Sensor;
import megamek.common.SmallCraft;
import megamek.common.SmallCraftBay;
import megamek.common.Tank;
import megamek.common.TargetRoll;
import megamek.common.Targetable;
import megamek.common.TeleMissileTracker;
import megamek.common.Transporter;
import megamek.common.TroopSpace;
import megamek.common.TurnOrdered;
import megamek.common.WeaponType;
import megamek.common.actions.AbstractAttackAction;
import megamek.common.actions.ChargeAttackAction;
import megamek.common.actions.DfaAttackAction;
import megamek.common.actions.DisplacementAttackAction;
import megamek.common.actions.EntityAction;
import megamek.common.actions.PushAttackAction;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.event.GameEntityChangeEvent;
import megamek.common.preference.PreferenceManager;
import megamek.common.util.StringUtil;
import megamek.common.weapons.ACWeapon;
import megamek.common.weapons.BayWeapon;
import megamek.common.weapons.CapitalLaserBayWeapon;
import megamek.common.weapons.GaussWeapon;
import megamek.common.weapons.ISBombastLaser;
import megamek.common.weapons.WeaponHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Entity
extends TurnOrdered
implements Transporter,
Targetable,
RoundUpdated {
    private static final long serialVersionUID = 1430806396279853295L;
    public static final int NONE = -1;
    public static final int LOC_NONE = -1;
    public static final int LOC_DESTROYED = -2;
    public static final int MAX_C3_NODES = 12;
    public static final int GRAPPLE_BOTH = 0;
    public static final int GRAPPLE_RIGHT = 1;
    public static final int GRAPPLE_LEFT = 2;
    protected transient IGame game;
    protected int id = -1;
    protected int externalId = -1;
    protected float weight;
    protected boolean omni = false;
    protected String chassis;
    protected String model;
    protected String fluff = null;
    protected int year;
    protected int techLevel;
    protected Engine engine;
    protected boolean mixedTech = false;
    protected boolean designValid = true;
    protected String displayName = null;
    protected String shortName = null;
    public int duplicateMarker = 1;
    protected transient Player owner;
    protected int ownerId;
    public Pilot crew = new Pilot();
    protected boolean shutDown = false;
    protected boolean shutDownThisPhase = false;
    protected boolean doomed = false;
    protected boolean destroyed = false;
    protected Coords position = null;
    protected int facing = 0;
    protected int sec_facing = 0;
    protected int walkMP = 0;
    protected int jumpMP = 0;
    protected int targSys = 0;
    protected boolean done = false;
    protected boolean prone = false;
    protected boolean hullDown = false;
    protected boolean findingClub = false;
    protected boolean armsFlipped = false;
    protected boolean unjammingRAC = false;
    protected boolean hasSpotlight = false;
    protected boolean illuminated = false;
    protected boolean spotlightIsActive = false;
    protected boolean usedSearchlight = false;
    protected boolean stuckInSwamp = false;
    protected boolean canUnstickByJumping = false;
    protected int taggedBy = -1;
    protected boolean layingMines = false;
    protected boolean _isEMId = false;
    protected DisplacementAttackAction displacementAttack = null;
    public int heat = 0;
    public int heatBuildup = 0;
    public int heatFromExternal = 0;
    public int delta_distance = 0;
    public int mpUsed = 0;
    public int moved = 0;
    protected int mpUsedLastRound = 0;
    public boolean gotPavementBonus = false;
    public boolean hitThisRoundByAntiTSM = false;
    public boolean inReverse = false;
    private int[] exposure;
    private int[] armor;
    private int[] internal;
    private int[] orig_armor;
    private int[] orig_internal;
    public int damageThisPhase;
    public int damageThisRound;
    public int engineHitsThisRound;
    public boolean rolledForEngineExplosion = false;
    public boolean dodging;
    public boolean reckless;
    private boolean evading = false;
    public boolean spotting;
    private boolean clearingMinefield = false;
    protected int killerId = -1;
    private int offBoardDistance = 0;
    private int offBoardDirection = -1;
    private int retreatedDirection = -1;
    protected int[] vectors = new int[]{0, 0, 0, 0, 0, 0};
    private int recoveryTurn = 0;
    private Vector<Coords> passedThrough = new Vector();
    private boolean ramming;
    private boolean[] frontArcFired;
    private boolean[] rearArcFired;
    public InfernoTracker infernos = new InfernoTracker();
    public ArtilleryTracker aTracker = new ArtilleryTracker();
    public TeleMissileTracker tmTracker = new TeleMissileTracker();
    protected String c3NetIdString = null;
    protected int c3Master = -1;
    protected int c3CompanyMasterIndex = -2;
    protected int armorType = -1;
    protected int armorTechLevel = -1;
    protected int structureType = -1;
    protected String source = "";
    protected ArrayList<Mounted> equipmentList = new ArrayList();
    protected ArrayList<Mounted> weaponList = new ArrayList();
    protected ArrayList<Mounted> weaponBayList = new ArrayList();
    protected ArrayList<Mounted> weaponGroupList = new ArrayList();
    protected ArrayList<Mounted> totalWeaponList = new ArrayList();
    protected ArrayList<Mounted> ammoList = new ArrayList();
    protected ArrayList<Mounted> bombList = new ArrayList();
    protected ArrayList<Mounted> miscList = new ArrayList();
    protected ArrayList<INarcPod> pendingINarcPods = new ArrayList();
    protected ArrayList<INarcPod> iNarcPods = new ArrayList();
    protected ArrayList<NarcPod> pendingNarcPods = new ArrayList();
    protected ArrayList<NarcPod> narcPods = new ArrayList();
    protected ArrayList<String> failedEquipmentList = new ArrayList();
    protected long m_lNarcedBy = 0L;
    protected long m_lPendingNarc = 0L;
    protected CriticalSlot[][] crits;
    protected int movementMode = 0;
    protected boolean isHidden = false;
    protected boolean carcass = false;
    private Vector<Transporter> transports = new Vector();
    private Vector<Integer> pickedUpMechWarriors = new Vector();
    private int conveyance = -1;
    private boolean unloadedThisTurn = false;
    private int swarmTargetId = -1;
    private int swarmAttackerId = -1;
    private boolean salvageable = true;
    private int removalCondition = 0;
    private int deployRound = 0;
    private boolean deployed = false;
    private char unitNumber = (char)65535;
    private boolean seenByEnemy = false;
    private boolean visibleToEnemy = false;
    private boolean captured = false;
    protected int elevation = 0;
    private Vector<Integer> hitBySwarmsEntity = new Vector();
    private Vector<Integer> hitBySwarmsWeapon = new Vector();
    private boolean canon;
    private int assaultDropInProgress = 0;
    private boolean climbMode = false;
    protected int lastTarget = -1;
    private int spotTargetId = -1;
    private boolean isCommander = false;
    protected boolean isCarefulStanding = false;
    private Vector<Sensor> sensors = new Vector();
    private Sensor activeSensor;
    private Sensor nextSensor;
    private int sensorCheck;
    private int ghostTargetRoll;
    private int ghostTargetOverride;
    protected int heatSinkCoolantFailureFactor;
    protected int taserShutdownRounds = 0;
    protected boolean shutdownByBATaser = false;
    protected int taserFeedBackRounds = 0;
    protected int taserInterference = 0;
    protected int taserInterferenceRounds = 0;
    protected StringBuffer bvText = null;

    public Entity() {
        this.armor = new int[this.locations()];
        this.internal = new int[this.locations()];
        this.orig_armor = new int[this.locations()];
        this.orig_internal = new int[this.locations()];
        this.crits = new CriticalSlot[this.locations()][];
        this.exposure = new int[this.locations()];
        for (int i = 0; i < this.locations(); ++i) {
            this.crits[i] = new CriticalSlot[this.getNumberOfCriticals(i)];
        }
        this.setC3NetId(this);
    }

    public void restore() {
        for (Mounted mounted : this.equipmentList) {
            mounted.restore();
        }
        this.setGameOptions();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
        this.displayName = null;
        this.shortName = null;
    }

    public int getExternalId() {
        return this.externalId;
    }

    public void setExternalId(int n) {
        this.externalId = n;
    }

    public IGame getGame() {
        return this.game;
    }

    public void setGame(IGame iGame) {
        Object object;
        this.game = iGame;
        this.restore();
        if (null == this.owner) {
            if (-1 == this.ownerId) {
                throw new IllegalStateException("Entity doesn't know its owner's ID.");
            }
            object = iGame.getPlayer(this.ownerId);
            if (null == object) {
                System.err.println("Entity can't find player #" + this.ownerId);
            } else {
                this.setOwner((Player)object);
            }
        }
        object = this.getLoadedUnits().elements();
        while (object.hasMoreElements()) {
            object.nextElement().setGame(iGame);
        }
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String string) {
        this.model = string;
    }

    public String getChassis() {
        return this.chassis;
    }

    public void setChassis(String string) {
        this.chassis = string;
    }

    public String getFluff() {
        return this.fluff;
    }

    public void setFluff(String string) {
        this.fluff = string;
    }

    public int getTechLevel() {
        return this.techLevel;
    }

    public void setTechLevel(int n) {
        this.techLevel = n;
    }

    public int getRecoveryTurn() {
        return this.recoveryTurn;
    }

    public void setRecoveryTurn(int n) {
        this.recoveryTurn = n;
    }

    public boolean isClan() {
        return this.techLevel == 2 || this.techLevel == 6 || this.techLevel == 8 || this.techLevel == 10;
    }

    public boolean isClanArmor() {
        if (this.getArmorTechLevel() == -1) {
            return this.isClan();
        }
        return this.getArmorTechLevel() == 2 || this.getArmorTechLevel() == 6 || this.getArmorTechLevel() == 8 || this.getArmorTechLevel() == 10;
    }

    public boolean isMixedTech() {
        return this.mixedTech;
    }

    public void setMixedTech(boolean bl) {
        this.mixedTech = bl;
    }

    public boolean isDesignValid() {
        return this.designValid;
    }

    public void setDesignValid(boolean bl) {
        this.designValid = bl;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int n) {
        this.year = n;
    }

    public float getWeight() {
        return this.weight;
    }

    public int getWeightClass() {
        return EntityWeightClass.getWeightClass((int)this.getWeight());
    }

    public String getWeightClassName() {
        return EntityWeightClass.getClassName(this.getWeightClass());
    }

    public void setWeight(float f) {
        this.weight = f;
    }

    public boolean isOmni() {
        return this.omni;
    }

    public void setOmni(boolean bl) {
        this.omni = bl;
    }

    public abstract int locations();

    public Player getOwner() {
        return this.owner;
    }

    public void setOwner(Player player) {
        this.owner = player;
        this.ownerId = player.getId();
        this.generateDisplayName();
    }

    public int getOwnerId() {
        return this.ownerId;
    }

    public boolean isEnemyOf(Entity entity) {
        if (null == this.owner) {
            return this.id != entity.getId() && this.ownerId != entity.ownerId;
        }
        return this.id != entity.getId() && this.owner.isEnemyOf(entity.getOwner());
    }

    public Pilot getCrew() {
        return this.crew;
    }

    public void setCrew(Pilot pilot) {
        this.crew = pilot;
    }

    public boolean isShutDown() {
        return this.shutDown;
    }

    public void setShutDown(boolean bl) {
        this.shutDown = bl;
        this.setShutDownThisPhase(bl);
    }

    public void setShutDownThisPhase(boolean bl) {
        this.shutDownThisPhase = bl;
    }

    public boolean isShutDownThisPhase() {
        return this.shutDownThisPhase;
    }

    public boolean isDoomed() {
        return this.doomed;
    }

    public void setDoomed(boolean bl) {
        if (bl) {
            this.setRemovalCondition(512);
        }
        this.doomed = bl;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setDestroyed(boolean bl) {
        this.destroyed = bl;
    }

    @Override
    public int getTargetType() {
        return 0;
    }

    @Override
    public int getTargetId() {
        return this.getId();
    }

    @Override
    public int getHeight() {
        return this.height();
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean bl) {
        this.done = bl;
    }

    public void setUnloaded(boolean bl) {
        this.unloadedThisTurn = bl;
    }

    public boolean isActive() {
        return this.isActive(-1);
    }

    public boolean isActive(int n) {
        boolean bl;
        boolean bl2 = bl = !this.shutDown && !this.destroyed && this.getCrew().isActive() && !this.unloadedThisTurn;
        bl = n > -1 && bl ? !this.deployed && this.shouldDeploy(n) : bl && this.deployed;
        return bl;
    }

    public boolean isSelectableThisTurn() {
        return !this.done && this.conveyance == -1 && !this.unloadedThisTurn && !this.isClearingMinefield() && !this.isCarcass();
    }

    public boolean isLoadableThisTurn() {
        return this.delta_distance == 0 && this.conveyance == -1 && !this.unloadedThisTurn && !this.isClearingMinefield();
    }

    public boolean isUnloadedThisTurn() {
        return this.unloadedThisTurn;
    }

    public boolean isTargetable() {
        return !this.destroyed && !this.doomed && this.deployed && !this.isOffBoard();
    }

    public boolean isProne() {
        return this.prone;
    }

    public void setProne(boolean bl) {
        this.prone = bl;
        if (bl) {
            this.hullDown = false;
        }
    }

    public boolean isHullDown() {
        return this.hullDown;
    }

    public void setHullDown(boolean bl) {
        this.hullDown = bl;
        if (this.hullDown) {
            this.prone = false;
        }
    }

    @Override
    public boolean isImmobile() {
        return this.isShutDown() || this.crew.isUnconscious();
    }

    public boolean isCharging() {
        return this.displacementAttack instanceof ChargeAttackAction;
    }

    public boolean isPushing() {
        return this.displacementAttack instanceof PushAttackAction;
    }

    public boolean isMakingDfa() {
        return this.displacementAttack instanceof DfaAttackAction;
    }

    public boolean hasDisplacementAttack() {
        return this.displacementAttack != null;
    }

    public DisplacementAttackAction getDisplacementAttack() {
        return this.displacementAttack;
    }

    public void setDisplacementAttack(DisplacementAttackAction displacementAttackAction) {
        this.displacementAttack = displacementAttackAction;
    }

    public boolean isTargetOfDisplacementAttack() {
        return this.findTargetedDisplacement() != null;
    }

    public DisplacementAttackAction findTargetedDisplacement() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!entity.hasDisplacementAttack() || entity.getDisplacementAttack().getTargetId() != this.id) continue;
            return entity.getDisplacementAttack();
        }
        return null;
    }

    public boolean isUnjammingRAC() {
        return this.unjammingRAC;
    }

    public void setUnjammingRAC(boolean bl) {
        this.unjammingRAC = bl;
    }

    public boolean isFindingClub() {
        return this.findingClub;
    }

    public void setFindingClub(boolean bl) {
        this.findingClub = bl;
    }

    public void setArmsFlipped(boolean bl) {
        this.armsFlipped = bl;
        this.game.processGameEvent(new GameEntityChangeEvent((Object)this, this));
    }

    public boolean getArmsFlipped() {
        return this.armsFlipped;
    }

    @Override
    public Coords getPosition() {
        return this.position;
    }

    public void setPosition(Coords coords) {
        this.position = coords;
    }

    public Coords getPriorPosition() {
        if (this.passedThrough.size() < 2) {
            return this.getPosition();
        }
        return this.passedThrough.elementAt(this.passedThrough.size() - 2);
    }

    public void setElevation(int n) {
        this.elevation = n;
    }

    public int calcElevation(IHex iHex, IHex iHex2, int n, boolean bl, boolean bl2) {
        int n2 = n;
        if (this instanceof Aero) {
            return n2;
        }
        if (this.getMovementMode() == 9 || this.getMovementMode() == 18 && (iHex.containsTerrain(2) || iHex2.containsTerrain(2)) || this.getMovementMode() == 6 || this.getMovementMode() == 15 && (bl || bl2) && n > 0 || this.getMovementMode() == 14 && this.hasUMU() || this.getMovementMode() == 13 && this.hasUMU()) {
            n2 += iHex.surface();
            n2 -= iHex2.surface();
        } else {
            int n3;
            int n4;
            if (this.getMovementMode() != 5 && this.getMovementMode() != 7 && this.getMovementMode() != 8 && this.getMovementMode() != 15) {
                n4 = 0;
                if (iHex.containsTerrain(2)) {
                    n4 = iHex.terrainLevel(2);
                    if (!iHex.containsTerrain(17) || n < 0) {
                        n2 += iHex.terrainLevel(2);
                    }
                }
                if (iHex2.containsTerrain(2)) {
                    n3 = iHex2.terrainLevel(2);
                    if (iHex2.containsTerrain(17) && (n3 == 1 && n4 == 1 || n4 <= 2 && bl || n >= 0)) {
                        n2 += n3;
                    }
                    n2 -= n3;
                }
            }
            if (iHex2.containsTerrain(22) || iHex.containsTerrain(22)) {
                n4 = Math.max(0, iHex.terrainLevel(24));
                n3 = Math.max(0, iHex2.terrainLevel(24));
                if (n == n4 && bl && this instanceof Mech || n2 > n3) {
                    n2 = n3;
                } else if (n3 + iHex2.surface() > n4 + iHex.surface()) {
                    n2 += iHex.surface();
                    n2 -= iHex2.surface();
                }
            }
            if (this.getMovementMode() != 7 && this.getMovementMode() != 8 && (iHex2.containsTerrain(26) || iHex.containsTerrain(26))) {
                n4 = Math.max(-iHex2.depth(), iHex2.terrainLevel(28));
                if (Math.abs(iHex2.surface() + n4 - (iHex.surface() + n)) <= this.getMaxElevationChange() && (bl || Math.abs(iHex2.surface() + n2 - (iHex.surface() + n)) > this.getMaxElevationChange() || !this.isElevationValid(n2, iHex2))) {
                    n2 = n4;
                }
            }
        }
        return n2;
    }

    public int calcElevation(IHex iHex, IHex iHex2) {
        return this.calcElevation(iHex, iHex2, this.elevation, false, false);
    }

    @Override
    public int getElevation() {
        if (-1 != this.getTransportId()) {
            return this.game.getEntity(this.getTransportId()).getElevation();
        }
        if (null == this.getPosition() && this.isDeployed()) {
            throw new IllegalStateException("Entity #" + this.getId() + " does not know its position.");
        }
        if (this.isOffBoard()) {
            return 0;
        }
        return this.elevation;
    }

    public boolean canGoDown() {
        return this.canGoDown(this.elevation, this.getPosition());
    }

    public boolean canGoDown(int n, Coords coords) {
        boolean bl = false;
        IHex iHex = this.getGame().getBoard().getHex(coords);
        int n2 = n + iHex.surface();
        int n3 = iHex.surface();
        if (iHex.containsTerrain(1) || iHex.containsTerrain(2) || iHex.containsTerrain(5)) {
            bl = true;
        }
        switch (this.getMovementMode()) {
            case 10: 
            case 11: 
            case 12: {
                n3 -= Math.max(0, iHex.terrainLevel(25));
                break;
            }
            case 6: 
            case 15: {
                n3 = iHex.ceiling();
                if (!bl) break;
                ++n3;
                break;
            }
            case 16: 
            case 17: {
                if (!this.game.getBoard().inAtmosphere()) break;
                n2 = n;
                n3 = iHex.ceiling() + 1;
                if (((Aero)this).getSensorHits() <= 0) break;
                ++n3;
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 18: {
                n3 = iHex.floor();
                break;
            }
            default: {
                return false;
            }
        }
        return n2 > n3;
    }

    public boolean canGoUp(int n, Coords coords) {
        IHex iHex = this.getGame().getBoard().getHex(coords);
        int n2 = n + iHex.surface();
        int n3 = iHex.surface();
        switch (this.getMovementMode()) {
            case 10: 
            case 11: 
            case 12: {
                n3 += Math.max(0, iHex.terrainLevel(24));
                break;
            }
            case 6: {
                n3 = iHex.surface() + 50;
                break;
            }
            case 16: 
            case 17: {
                if (!this.game.getBoard().inAtmosphere()) break;
                n2 = n;
                n3 = 10;
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 18: {
                n3 = iHex.surface();
                break;
            }
            case 15: {
                n3 = iHex.surface() + 1;
                break;
            }
            default: {
                return false;
            }
        }
        return n2 < n3;
    }

    public boolean isElevationValid(int n, IHex iHex) {
        int n2 = n + iHex.surface();
        if (this.getMovementMode() == 6) {
            if (this instanceof Infantry && (iHex.containsTerrain(22) || iHex.containsTerrain(1) || iHex.containsTerrain(5))) {
                return n <= 50 && n2 >= iHex.floor();
            }
            if (iHex.containsTerrain(1) || iHex.containsTerrain(2) || iHex.containsTerrain(5)) {
                return n <= 50 && n2 > iHex.ceiling();
            }
            return n <= 50 && n2 >= iHex.ceiling();
        }
        if (this.getMovementMode() == 9 || this.getMovementMode() == 18 && iHex.containsTerrain(2) || this.getMovementMode() == 14 && this.hasUMU() || this.getMovementMode() == 13 && this.hasUMU()) {
            return n2 >= iHex.floor() && n2 <= iHex.surface();
        }
        if (this.getMovementMode() == 8 || this.getMovementMode() == 7) {
            return n2 == iHex.surface();
        }
        if (this.getMovementMode() == 15) {
            return n2 >= iHex.floor();
        }
        if ((iHex.containsTerrain(17) || this.getMovementMode() == 5 && iHex.containsTerrain(2)) && n2 == iHex.surface()) {
            return true;
        }
        if (iHex.containsTerrain(2) && n2 < iHex.surface() && !(this instanceof Mech) && !(this instanceof Protomech)) {
            return false;
        }
        if (n2 == iHex.floor()) {
            return true;
        }
        if (iHex.containsTerrain(26) && n == iHex.terrainLevel(28)) {
            return true;
        }
        return iHex.containsTerrain(22) && (this instanceof Mech || this instanceof Protomech || this instanceof Infantry) && n2 >= iHex.floor() && n2 <= iHex.ceiling();
    }

    public int height() {
        return 0;
    }

    @Override
    public int absHeight() {
        return this.getElevation() + this.height();
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            this.generateDisplayName();
        }
        return this.displayName;
    }

    public void generateDisplayName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.chassis);
        if (this.model != null && this.model.length() > 0) {
            stringBuffer.append(" ").append(this.model);
        }
        if (PreferenceManager.getClientPreferences().getShowUnitId()) {
            stringBuffer.append(" ID:").append(this.getId());
        } else if (this.duplicateMarker > 1) {
            stringBuffer.append(" #" + this.duplicateMarker);
        }
        if (this.getOwner() != null) {
            stringBuffer.append(" (").append(this.getOwner().getName()).append(")");
        }
        if (PreferenceManager.getClientPreferences().getShowUnitId()) {
            stringBuffer.append(" ID:").append(this.getId());
        }
        this.displayName = stringBuffer.toString();
    }

    public String getShortName() {
        if (this.shortName == null) {
            this.generateShortName();
        }
        return this.shortName;
    }

    public void generateShortName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.chassis);
        if (this.model != null && this.model.length() > 0) {
            stringBuffer.append(" ").append(this.model);
        }
        if (PreferenceManager.getClientPreferences().getShowUnitId()) {
            stringBuffer.append(" ID:").append(this.getId());
        } else if (this.duplicateMarker > 1) {
            stringBuffer.append(" #" + this.duplicateMarker);
        }
        this.shortName = stringBuffer.toString();
    }

    public String getShortNameRaw() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.chassis);
        if (this.model != null && this.model.length() > 0) {
            stringBuffer.append(" ").append(this.model);
        }
        return stringBuffer.toString();
    }

    public int getFacing() {
        if (-1 != this.conveyance) {
            return this.game.getEntity(this.conveyance).getFacing();
        }
        return this.facing;
    }

    public void setFacing(int n) {
        this.facing = n;
        if (this.game != null) {
            this.game.processGameEvent(new GameEntityChangeEvent((Object)this, this));
        }
    }

    public int getSecondaryFacing() {
        return this.sec_facing;
    }

    public void setSecondaryFacing(int n) {
        this.sec_facing = n;
        if (this.game != null) {
            this.game.processGameEvent(new GameEntityChangeEvent((Object)this, this));
        }
    }

    public abstract boolean canChangeSecondaryFacing();

    public abstract boolean isValidSecondaryFacing(int var1);

    public abstract int clipSecondaryFacing(int var1);

    public boolean canUnjamRAC() {
        for (Mounted mounted : this.getTotalWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.getAmmoType() != 23 || !mounted.isJammed() || mounted.isDestroyed()) continue;
            return true;
        }
        return false;
    }

    public boolean canFlipArms() {
        return false;
    }

    public int getOriginalWalkMP() {
        return this.walkMP;
    }

    public void setOriginalWalkMP(int n) {
        this.walkMP = n;
    }

    public int getWalkMP() {
        return this.getWalkMP(true, false);
    }

    public int getWalkMP(boolean bl, boolean bl2) {
        int n;
        int n2 = this.getOriginalWalkMP();
        if (!bl2) {
            n2 = Math.max(0, n2 - this.getHeatMPReduction());
        }
        n2 = Math.max(n2 - this.getCargoMpReduction(), 0);
        if (null != this.game && (n = this.game.getPlanetaryConditions().getMovementMods(this)) != 0) {
            n2 = Math.max(n2 + n, 0);
        }
        if (bl) {
            n2 = this.applyGravityEffectsOnMP(n2);
        }
        return n2;
    }

    public int getHeatMPReduction() {
        int n = this.game != null && this.game.getOptions().booleanOption("tacops_heat") ? (this.heat < 30 ? this.heat / 5 : (this.heat >= 49 ? 9 : (this.heat >= 43 ? 8 : (this.heat >= 37 ? 7 : (this.heat >= 31 ? 6 : 5))))) : this.heat / 5;
        return n;
    }

    public int getStandingHeat() {
        return 0;
    }

    public int getWalkHeat() {
        return 0;
    }

    protected int getOriginalRunMP() {
        return (int)Math.ceil((double)this.getOriginalWalkMP() * 1.5);
    }

    public int getRunMP() {
        return this.getRunMP(true, false);
    }

    public int getRunMP(boolean bl, boolean bl2) {
        return (int)Math.ceil((double)this.getWalkMP(bl, bl2) * 1.5);
    }

    public int getRunMPwithoutMASC() {
        return this.getRunMPwithoutMASC(true, false);
    }

    public abstract int getRunMPwithoutMASC(boolean var1, boolean var2);

    public String getRunMPasString() {
        return Integer.toString(this.getRunMP());
    }

    public int getRunHeat() {
        return 0;
    }

    public int getOriginalJumpMP() {
        if (this.hasModularArmor()) {
            return this.jumpMP - 1;
        }
        return this.jumpMP;
    }

    public void setOriginalJumpMP(int n) {
        this.jumpMP = n;
    }

    public int getJumpMP() {
        return this.getJumpMP(true);
    }

    public int getJumpMP(boolean bl) {
        if (bl) {
            return this.applyGravityEffectsOnMP(this.getOriginalJumpMP());
        }
        return this.getOriginalJumpMP();
    }

    public int getJumpType() {
        return 0;
    }

    public int getJumpHeat(int n) {
        return 0;
    }

    public int getJumpMPWithTerrain() {
        return this.getJumpMP();
    }

    public int elevationOccupied(IHex iHex) {
        if (iHex == null) {
            return 0;
        }
        if (this.movementMode == 6 || this.movementMode == 15) {
            return iHex.surface() + this.elevation;
        }
        if ((this.movementMode == 5 || this.movementMode == 7 || this.movementMode == 8 || iHex.containsTerrain(17)) && iHex.containsTerrain(2)) {
            return iHex.surface();
        }
        if (iHex.containsTerrain(24)) {
            return iHex.floor() + iHex.terrainLevel(24);
        }
        return iHex.floor();
    }

    public boolean isHexProhibited(IHex iHex) {
        if (iHex.containsTerrain(33)) {
            return true;
        }
        return iHex.containsTerrain(11) && this.doomedInSpace();
    }

    public boolean isBoardProhibited(int n) {
        if (n == 0 && this.doomedOnGround()) {
            return true;
        }
        if (n == 1 && this.doomedInAtmosphere()) {
            return true;
        }
        return n == 2 && this.doomedInSpace();
    }

    public abstract String getMovementString(int var1);

    public abstract String getMovementAbbr(int var1);

    public String getLocationName(HitData hitData) {
        return this.getLocationName(hitData.getLocation());
    }

    protected abstract String[] getLocationNames();

    public String getLocationName(int n) {
        String[] stringArray = this.getLocationNames();
        if (null == stringArray || n >= stringArray.length) {
            return "";
        }
        return stringArray[n];
    }

    protected abstract String[] getLocationAbbrs();

    public String getLocationAbbr(HitData hitData) {
        return this.getLocationAbbr(hitData.getLocation()) + (hitData.isRear() && this.hasRearArmor(hitData.getLocation()) ? "R" : "") + (hitData.getEffect() == 1 ? " (critical)" : "");
    }

    public String getLocationAbbr(int n) {
        String[] stringArray = this.getLocationAbbrs();
        if (null == stringArray || n >= stringArray.length) {
            return "";
        }
        return stringArray[n];
    }

    public int getLocationFromAbbr(String string) {
        for (int i = 0; i < this.locations(); ++i) {
            if (!this.getLocationAbbr(i).equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public abstract HitData rollHitLocation(int var1, int var2, int var3, int var4);

    public abstract HitData rollHitLocation(int var1, int var2);

    public abstract HitData getTransferLocation(HitData var1);

    public int getTransferLocation(int n) {
        return this.getTransferLocation(new HitData(n)).getLocation();
    }

    public abstract int getDependentLocation(int var1);

    public abstract boolean hasRearArmor(int var1);

    public int getArmor(int n) {
        return this.getArmor(n, false);
    }

    public int getArmor(HitData hitData) {
        return this.getArmor(hitData.getLocation(), hitData.isRear());
    }

    public int getArmor(int n, boolean bl) {
        if (n >= this.armor.length) {
            return -1;
        }
        return this.armor[n];
    }

    public int getOArmor(int n) {
        return this.getOArmor(n, false);
    }

    public int getOArmor(HitData hitData) {
        return this.getOArmor(hitData.getLocation(), hitData.isRear());
    }

    public int getOArmor(int n, boolean bl) {
        return this.orig_armor[n];
    }

    public void setArmor(int n, HitData hitData) {
        this.setArmor(n, hitData.getLocation(), hitData.isRear());
    }

    public void setArmor(int n, int n2) {
        this.setArmor(n, n2, false);
    }

    public void setArmor(int n, int n2, boolean bl) {
        this.armor[n2] = n;
    }

    public void refreshLocations() {
        this.armor = new int[this.locations()];
        this.internal = new int[this.locations()];
        this.orig_armor = new int[this.locations()];
        this.orig_internal = new int[this.locations()];
        this.crits = new CriticalSlot[this.locations()][];
        this.exposure = new int[this.locations()];
        for (int i = 0; i < this.locations(); ++i) {
            this.crits[i] = new CriticalSlot[this.getNumberOfCriticals(i)];
        }
    }

    public void initializeArmor(int n, int n2) {
        this.orig_armor[n2] = n;
        this.setArmor(n, n2);
    }

    public int getTotalArmor() {
        int n = 0;
        for (int i = 0; i < this.locations(); ++i) {
            if (this.getArmor(i) > 0) {
                n += this.getArmor(i);
            }
            if (!this.hasRearArmor(i) || this.getArmor(i, true) <= 0) continue;
            n += this.getArmor(i, true);
        }
        return n;
    }

    public int getTotalOArmor() {
        int n = 0;
        for (int i = 0; i < this.locations(); ++i) {
            if (this.getOArmor(i) > 0) {
                n += this.getOArmor(i);
            }
            if (!this.hasRearArmor(i) || this.getOArmor(i, true) <= 0) continue;
            n += this.getOArmor(i, true);
        }
        return n;
    }

    public double getArmorRemainingPercent() {
        if (this.getTotalOArmor() == 0) {
            return -1.0;
        }
        return (double)this.getTotalArmor() / (double)this.getTotalOArmor();
    }

    public int getInternal(HitData hitData) {
        return this.getInternal(hitData.getLocation());
    }

    public int getInternal(int n) {
        return this.internal[n];
    }

    public int getOInternal(HitData hitData) {
        return this.getOInternal(hitData.getLocation());
    }

    public int getOInternal(int n) {
        return this.orig_internal[n];
    }

    public void setInternal(int n, HitData hitData) {
        this.setInternal(n, hitData.getLocation());
    }

    public void setInternal(int n, int n2) {
        this.internal[n2] = n;
    }

    public void initializeInternal(int n, int n2) {
        this.orig_internal[n2] = n;
        this.setInternal(n, n2);
    }

    public abstract void autoSetInternal();

    public int getTotalInternal() {
        int n = 0;
        for (int i = 0; i < this.locations(); ++i) {
            if (this.getInternal(i) <= 0) continue;
            n += this.getInternal(i);
        }
        return n;
    }

    public int getTotalOInternal() {
        int n = 0;
        for (int i = 0; i < this.locations(); ++i) {
            if (this.getOInternal(i) <= 0) continue;
            n += this.getOInternal(i);
        }
        return n;
    }

    public double getInternalRemainingPercent() {
        return (double)this.getTotalInternal() / (double)this.getTotalOInternal();
    }

    public boolean isLocationBad(int n) {
        return this.getInternal(n) == -3;
    }

    public boolean isLocationDoomed(int n) {
        return this.getInternal(n) == -2;
    }

    public int getLocationStatus(int n) {
        return this.exposure[n];
    }

    public void setLocationStatus(int n, int n2) {
        if (this.exposure[n] > -1) {
            this.exposure[n] = n2;
        }
    }

    public boolean locationIsLeg(int n) {
        return false;
    }

    public String getArmorString(int n) {
        return this.getArmorString(n, false);
    }

    public String getArmorString(int n, boolean bl) {
        return Entity.armorStringFor(this.getArmor(n, bl));
    }

    public String getInternalString(int n) {
        return Entity.armorStringFor(this.getInternal(n));
    }

    public static String armorStringFor(int n) {
        if (n == -1) {
            return "N/A";
        }
        if (n == -2 || n == -3) {
            return "***";
        }
        return Integer.toString(n);
    }

    public int getHeatFiringModifier() {
        boolean bl;
        int n = 0;
        if (this.heat >= 8) {
            ++n;
        }
        if (this.heat >= 13) {
            ++n;
        }
        if (this.heat >= 17) {
            ++n;
        }
        if (this.heat >= 24) {
            ++n;
        }
        if ((bl = this.game.getOptions().booleanOption("tacops_heat")) && this.heat >= 33) {
            ++n;
        }
        if (bl && this.heat >= 41) {
            ++n;
        }
        if (bl && this.heat >= 48) {
            ++n;
        }
        return n;
    }

    public Mounted addEquipment(EquipmentType equipmentType, int n) throws LocationFullException {
        return this.addEquipment(equipmentType, n, false);
    }

    public Mounted addEquipment(EquipmentType equipmentType, int n, boolean bl) throws LocationFullException {
        return this.addEquipment(equipmentType, n, bl, false, false);
    }

    public Mounted addEquipment(EquipmentType equipmentType, int n, boolean bl, boolean bl2, boolean bl3) throws LocationFullException {
        Mounted mounted = new Mounted(this, equipmentType);
        mounted.setArmored(bl3);
        mounted.setBodyMounted(bl2);
        this.addEquipment(mounted, n, bl);
        return mounted;
    }

    public Mounted addEquipment(EquipmentType equipmentType, int n, boolean bl, int n2) throws LocationFullException {
        Mounted mounted = new Mounted(this, equipmentType);
        this.addEquipment(mounted, n, bl, n2);
        return mounted;
    }

    public Mounted addBomb(EquipmentType equipmentType, int n) throws LocationFullException {
        Mounted mounted = new Mounted(this, equipmentType);
        this.addBomb(mounted, n);
        return mounted;
    }

    public Mounted addWeaponGroup(EquipmentType equipmentType, int n) throws LocationFullException {
        Mounted mounted = new Mounted(this, equipmentType);
        this.addEquipment(mounted, n, false, true);
        return mounted;
    }

    public Mounted addEquipment(EquipmentType equipmentType, int n, boolean bl, boolean bl2) throws LocationFullException {
        Mounted mounted = new Mounted(this, equipmentType);
        mounted.setBodyMounted(bl2);
        this.addEquipment(mounted, n, bl);
        return mounted;
    }

    protected void addEquipment(Mounted mounted, int n, boolean bl, int n2) throws LocationFullException {
        if (mounted.getType() instanceof AmmoType && n2 > 1) {
            mounted.setByShot(true);
            mounted.setShotsLeft(n2);
        }
        this.addEquipment(mounted, n, bl);
    }

    protected void addBomb(Mounted mounted, int n) throws LocationFullException {
        mounted.setBombMounted(true);
        this.addEquipment(mounted, n, false);
    }

    protected void addEquipment(Mounted mounted, int n, boolean bl, boolean bl2) throws LocationFullException {
        mounted.setWeaponGroup(true);
        this.addEquipment(mounted, n, bl);
    }

    protected void addEquipment(Mounted mounted, int n, boolean bl) throws LocationFullException {
        mounted.setLocation(n, bl);
        this.equipmentList.add(mounted);
        if (mounted.getType() instanceof WeaponType) {
            this.totalWeaponList.add(mounted);
            if (mounted.isWeaponGroup()) {
                this.weaponGroupList.add(mounted);
            } else if (mounted.getType() instanceof BayWeapon) {
                this.weaponBayList.add(mounted);
            } else {
                this.weaponList.add(mounted);
            }
            if (mounted.getType().hasFlag(32768L)) {
                this.aTracker.addWeapon(mounted);
            }
            if (mounted.getType().hasFlag(16384L)) {
                Mounted mounted2 = new Mounted(this, AmmoType.getOneshotAmmo(mounted));
                mounted2.setShotsLeft(1);
                mounted.setLinked(mounted2);
                this.addEquipment(mounted2, -1, false);
            }
        }
        if (mounted.getType() instanceof AmmoType) {
            this.ammoList.add(mounted);
        }
        if (mounted.getType() instanceof BombType) {
            this.bombList.add(mounted);
        }
        if (mounted.getType() instanceof MiscType) {
            this.miscList.add(mounted);
        }
    }

    public void addFailedEquipment(String string) {
        this.failedEquipmentList.add(string);
    }

    public int getEquipmentNum(Mounted mounted) {
        if (mounted != null) {
            return this.equipmentList.indexOf(mounted);
        }
        return -1;
    }

    public ArrayList<Mounted> getEquipment() {
        return this.equipmentList;
    }

    public Mounted getEquipment(int n) {
        try {
            return this.equipmentList.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public EquipmentType getEquipmentType(CriticalSlot criticalSlot) {
        if (criticalSlot.getType() != 1) {
            return null;
        }
        Mounted mounted = this.equipmentList.get(criticalSlot.getIndex());
        return mounted.getType();
    }

    public Iterator<String> getFailedEquipment() {
        return this.failedEquipmentList.iterator();
    }

    public int getTotalAmmoOfType(EquipmentType equipmentType) {
        int n = 0;
        for (Mounted mounted : this.getAmmo()) {
            if (mounted.getType() != equipmentType || mounted.isDumping()) continue;
            n += mounted.getShotsLeft();
        }
        return n;
    }

    public int getTotalMunitionsOfType(EquipmentType equipmentType) {
        int n = 0;
        for (Mounted mounted : this.getAmmo()) {
            if (!mounted.getType().equals(equipmentType) || mounted.isDumping()) continue;
            n += mounted.getShotsLeft();
        }
        return n;
    }

    public abstract int getWeaponArc(int var1);

    public abstract boolean isSecondaryArcWeapon(int var1);

    public Iterator<Mounted> getWeapons() {
        if (this.usesWeaponBays()) {
            return this.weaponBayList.iterator();
        }
        if (this.isCapitalFighter()) {
            return this.weaponGroupList.iterator();
        }
        return this.weaponList.iterator();
    }

    public ArrayList<Mounted> getWeaponList() {
        if (this.usesWeaponBays()) {
            return this.weaponBayList;
        }
        if (this.isCapitalFighter()) {
            return this.weaponGroupList;
        }
        return this.weaponList;
    }

    public ArrayList<Mounted> getTotalWeaponList() {
        return this.totalWeaponList;
    }

    public ArrayList<Mounted> getWeaponBayList() {
        return this.weaponBayList;
    }

    public ArrayList<Mounted> getWeaponGroupList() {
        return this.weaponGroupList;
    }

    public int getFirstWeapon() {
        for (Mounted mounted : this.getWeaponList()) {
            if (!mounted.isReady()) continue;
            return this.getEquipmentNum(mounted);
        }
        return -1;
    }

    public int getNextWeapon(int n) {
        boolean bl = false;
        for (Mounted mounted : this.getWeaponList()) {
            if (bl && mounted != null && mounted.isReady() && !mounted.getType().hasFlag(0x800000L) && (mounted.getLinked() == null || mounted.getLinked().getShotsLeft() > 0)) {
                if (mounted.getType().hasFlag(0x4000000L) && this.game.getPhase() == IGame.Phase.PHASE_FIRING || mounted.getType().hasFlag(512L) && this.hasLinkedMGA(mounted)) continue;
                return this.getEquipmentNum(mounted);
            }
            if (this.getEquipmentNum(mounted) == n) {
                bl = true;
                continue;
            }
            if (!bl || this.getEquipmentNum(mounted) != n) continue;
            return this.getFirstWeapon();
        }
        return this.getFirstWeapon();
    }

    public void loadAllWeapons() {
        for (Mounted mounted : this.getTotalWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.getAmmoType() == -1) continue;
            this.loadWeapon(mounted);
        }
    }

    public void loadWeapon(Mounted mounted) {
        for (Mounted mounted2 : this.getAmmo()) {
            if (this.loadWeapon(mounted, mounted2)) break;
        }
    }

    public void loadWeaponWithSameAmmo(Mounted mounted) {
        for (Mounted mounted2 : this.getAmmo()) {
            if (!this.loadWeaponWithSameAmmo(mounted, mounted2)) continue;
            return;
        }
        this.loadWeapon(mounted);
    }

    public boolean loadWeapon(Mounted mounted, Mounted mounted2) {
        boolean bl = false;
        WeaponType weaponType = (WeaponType)mounted.getType();
        AmmoType ammoType = (AmmoType)mounted2.getType();
        if (mounted2.isAmmoUsable() && !weaponType.hasFlag(16384L) && ammoType.getAmmoType() == weaponType.getAmmoType() && ammoType.getRackSize() == weaponType.getRackSize()) {
            mounted.setLinked(mounted2);
            bl = true;
        }
        return bl;
    }

    public boolean loadWeaponWithSameAmmo(Mounted mounted, Mounted mounted2) {
        AmmoType ammoType = (AmmoType)mounted2.getType();
        Mounted mounted3 = mounted.getLinked();
        if (mounted3 != null && ((AmmoType)mounted3.getType()).getMunitionType() != ammoType.getMunitionType()) {
            return false;
        }
        return this.loadWeapon(mounted, mounted2);
    }

    public boolean weaponFiredFrom(int n) {
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            Mounted mounted;
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.getType() != 1 || !((mounted = this.getEquipment(criticalSlot.getIndex())).getType() instanceof WeaponType) || !mounted.isUsedThisRound()) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Mounted> getAmmo() {
        return this.ammoList;
    }

    public ArrayList<Mounted> getMisc() {
        return this.miscList;
    }

    public ArrayList<Mounted> getBombs() {
        return this.bombList;
    }

    public void removeMisc(String string) {
        for (Mounted mounted : this.getMisc()) {
            if (!mounted.getName().equals(string)) continue;
            this.miscList.remove(mounted);
            this.equipmentList.remove(mounted);
            break;
        }
    }

    public List<Mounted> getClubs() {
        ArrayList<Mounted> arrayList = new ArrayList<Mounted>();
        for (Mounted mounted : this.getMisc()) {
            if (!mounted.getType().hasFlag(0x2000000L)) continue;
            arrayList.add(mounted);
        }
        return arrayList;
    }

    public boolean hasWorkingMisc(long l, long l2) {
        for (Mounted mounted : this.miscList) {
            MiscType miscType;
            if (!(mounted.getType() instanceof MiscType) || !mounted.isReady() || !(miscType = (MiscType)mounted.getType()).hasFlag(l) || l2 != -1L && !miscType.hasSubType(l2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasWorkingMisc(long l, int n, int n2) {
        for (int i = 0; i < this.getNumberOfCriticals(n2); ++i) {
            MiscType miscType;
            Mounted mounted;
            CriticalSlot criticalSlot = this.getCritical(n2, i);
            if (null == criticalSlot || criticalSlot.getType() != 1 || (mounted = criticalSlot.getMount()) == null || !(mounted.getType() instanceof MiscType) || !mounted.isReady() || !(miscType = (MiscType)mounted.getType()).hasFlag(l) || n != -1 && !miscType.hasSubType(n)) continue;
            return true;
        }
        return false;
    }

    public abstract int getHeatCapacity();

    public abstract int getHeatCapacityWithWater();

    public abstract int getEngineCritHeat();

    public CriticalSlot getCritical(int n, int n2) {
        return this.crits[n][n2];
    }

    public void setCritical(int n, int n2, CriticalSlot criticalSlot) {
        this.crits[n][n2] = criticalSlot;
    }

    public boolean addCritical(int n, CriticalSlot criticalSlot) {
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            if (this.getCritical(n, i) != null) continue;
            this.crits[n][i] = criticalSlot;
            return true;
        }
        return false;
    }

    public boolean addCritical(int n, int n2, CriticalSlot criticalSlot) {
        if (this.getCritical(n, n2) == null) {
            this.setCritical(n, n2, criticalSlot);
            return true;
        }
        return this.addCritical(n, criticalSlot);
    }

    public void removeCriticals(int n, CriticalSlot criticalSlot) {
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            if (this.getCritical(n, i) == null || !this.getCritical(n, i).equals(criticalSlot)) continue;
            this.setCritical(n, i, null);
        }
    }

    public int getEmptyCriticals(int n) {
        int n2 = 0;
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            if (this.getCritical(n, i) != null) continue;
            ++n2;
        }
        return n2;
    }

    public int getHittableCriticals(int n) {
        int n2 = 0;
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            if (this.getCritical(n, i) == null || !this.getCritical(n, i).isHittable()) continue;
            ++n2;
        }
        return n2;
    }

    public boolean canTransferCriticals(int n) {
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.isDestroyed() || !criticalSlot.isEverHittable()) continue;
            return false;
        }
        return true;
    }

    public int getGyroType() {
        return -1;
    }

    public int getGoodCriticals(CriticalSlot criticalSlot, int n) {
        return this.getGoodCriticals(criticalSlot.getType(), criticalSlot.getIndex(), n);
    }

    public int getGoodCriticals(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = this.getNumberOfCriticals(n3);
        for (int i = 0; i < n5; ++i) {
            CriticalSlot criticalSlot = this.getCritical(n3, i);
            if (criticalSlot == null || criticalSlot.getType() != n || criticalSlot.getIndex() != n2 || criticalSlot.isDestroyed() || criticalSlot.isBreached()) continue;
            ++n4;
        }
        return n4;
    }

    public int getBadCriticals(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = this.getNumberOfCriticals(n3);
        for (int i = 0; i < n5; ++i) {
            CriticalSlot criticalSlot = this.getCritical(n3, i);
            if (criticalSlot == null || criticalSlot.getType() != n || criticalSlot.getIndex() != n2 || !criticalSlot.isDestroyed() && !criticalSlot.isBreached()) continue;
            ++n4;
        }
        return n4;
    }

    public int getHitCriticals(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = this.getNumberOfCriticals(n3);
        for (int i = 0; i < n5; ++i) {
            CriticalSlot criticalSlot = this.getCritical(n3, i);
            if (criticalSlot == null || criticalSlot.getType() != n || criticalSlot.getIndex() != n2 || !criticalSlot.isDamaged() && !criticalSlot.isBreached()) continue;
            ++n4;
        }
        return n4;
    }

    protected abstract int[] getNoOfSlots();

    public int getNumberOfCriticals(int n) {
        int[] nArray = this.getNoOfSlots();
        if (null == nArray || n >= nArray.length || n == -1) {
            return 0;
        }
        return nArray[n];
    }

    public int getNumberOfCriticals(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = this.getNumberOfCriticals(n3);
        for (int i = 0; i < n5; ++i) {
            CriticalSlot criticalSlot = this.getCritical(n3, i);
            if (criticalSlot == null || criticalSlot.getType() != n || criticalSlot.getIndex() != n2) continue;
            ++n4;
        }
        return n4;
    }

    public int getNumberOfCriticals(EquipmentType equipmentType, int n) {
        int n2 = 0;
        int n3 = this.getNumberOfCriticals(n);
        for (int i = 0; i < n3; ++i) {
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || this.getEquipmentType(criticalSlot) == null || !this.getEquipmentType(criticalSlot).equals(equipmentType)) continue;
            ++n2;
        }
        return n2;
    }

    public int getNumberOfCriticals(EquipmentType equipmentType) {
        int n = 0;
        int n2 = this.locations();
        for (int i = 0; i < n2; ++i) {
            n += this.getNumberOfCriticals(equipmentType, i);
        }
        return n;
    }

    public int getNumberOf(EquipmentType equipmentType) {
        int n = 0;
        for (Mounted mounted : this.equipmentList) {
            if (!mounted.getType().equals(equipmentType)) continue;
            ++n;
        }
        return n;
    }

    public boolean hasHipCrit() {
        return false;
    }

    public boolean hasLegActuatorCrit() {
        boolean bl = false;
        for (int i = 0; i < this.locations(); ++i) {
            if (!this.locationIsLeg(i) || this.getBadCriticals(0, 11, i) <= 0 && this.getBadCriticals(0, 12, i) <= 0 && this.getBadCriticals(0, 13, i) <= 0 && this.getBadCriticals(0, 14, i) <= 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean hasWorkingSystem(int n, int n2) {
        for (int i = 0; i < this.getNumberOfCriticals(n2); ++i) {
            CriticalSlot criticalSlot = this.getCritical(n2, i);
            if (criticalSlot == null || criticalSlot.getType() != 0 || criticalSlot.getIndex() != n || criticalSlot.isDamaged() || criticalSlot.isBreached()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSystem(int n, int n2) {
        for (int i = 0; i < this.getNumberOfCriticals(n2); ++i) {
            CriticalSlot criticalSlot = this.getCritical(n2, i);
            if (criticalSlot == null || criticalSlot.getType() != 0 || criticalSlot.getIndex() != n) continue;
            return true;
        }
        return false;
    }

    public boolean hasVibroblades() {
        return false;
    }

    public int getActiveVibrobladeHeat(int n) {
        return 0;
    }

    public boolean hasShield() {
        return false;
    }

    public int getNumberOfShields(long l) {
        return 0;
    }

    public boolean hasActiveShield(int n, boolean bl) {
        return true;
    }

    public boolean hasActiveShield(int n) {
        return false;
    }

    public boolean hasPassiveShield(int n, boolean bl) {
        return false;
    }

    public boolean hasPassiveShield(int n) {
        return false;
    }

    public boolean hasNoDefenseShield(int n) {
        return false;
    }

    public boolean hasUMU() {
        if (!(this instanceof Mech)) {
            return false;
        }
        int n = this.getActiveUMUCount();
        return n > 0;
    }

    public int getActiveUMUCount() {
        int n = 0;
        if (this.hasShield() && this.getNumberOfShields(4096L) > 0) {
            return 0;
        }
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(0x40000000L) || mounted.isDestroyed() || mounted.isMissing() || mounted.isBreached()) continue;
            ++n;
        }
        return n;
    }

    public int getAllUMUCount() {
        int n = 0;
        if (!(this instanceof Mech)) {
            return 0;
        }
        if (this.hasShield() && this.getNumberOfShields(4096L) > 0) {
            return 0;
        }
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(0x40000000L)) continue;
            ++n;
        }
        return n;
    }

    public boolean hasActiveECM() {
        if (this.game.getBoard().inSpace() && !this.game.getOptions().booleanOption("stratops_ecm")) {
            return false;
        }
        if (!this.isShutDown()) {
            for (Mounted mounted : this.getMisc()) {
                EquipmentType equipmentType = mounted.getType();
                if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(0x80000000000L) || !mounted.curMode().equals("ECM") && !mounted.curMode().equals("ECM & ECCM") && !mounted.curMode().equals("ECM & Ghost Targets")) continue;
                return !mounted.isInoperable();
            }
        }
        return false;
    }

    public boolean hasActiveAngelECM() {
        if (this.game.getBoard().inSpace() && !this.game.getOptions().booleanOption("stratops_ecm")) {
            return false;
        }
        if (this.game.getOptions().booleanOption("tacops_angel_ecm") && !this.isShutDown()) {
            for (Mounted mounted : this.getMisc()) {
                EquipmentType equipmentType = mounted.getType();
                if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(2048L) || !mounted.curMode().equals("ECM")) continue;
                return !mounted.isInoperable();
            }
        }
        return false;
    }

    public boolean hasGhostTargets(boolean bl) {
        if (this.game.getBoard().inSpace()) {
            return false;
        }
        if (bl && this.getGhostTargetRollMoS() < 0 || this.isShutDown()) {
            return false;
        }
        boolean bl2 = false;
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (equipmentType instanceof MiscType && equipmentType.hasFlag(0x80000000000L) && (mounted.curMode().equals("Ghost Targets") || mounted.curMode().equals("ECM & Ghost Targets") || mounted.curMode().equals("ECCM & Ghost Targets")) && !mounted.isInoperable() && !this.getCrew().isUnconscious()) {
                bl2 = true;
            }
            if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(0x200000000L) || !mounted.curMode().equals("Ghost Targets") || this.getTotalCommGearTons() < 7 || mounted.isInoperable() || this.getCrew().isUnconscious()) continue;
            bl2 = true;
        }
        return bl2;
    }

    public boolean hasActiveECCM() {
        if (this.game.getBoard().inSpace() && !this.game.getOptions().booleanOption("stratops_ecm")) {
            return false;
        }
        if ((this.game.getOptions().booleanOption("tacops_eccm") || this.game.getOptions().booleanOption("stratops_ecm")) && !this.isShutDown()) {
            for (Mounted mounted : this.getMisc()) {
                EquipmentType equipmentType = mounted.getType();
                if (!(equipmentType instanceof MiscType) || (!equipmentType.hasFlag(0x80000000000L) || !mounted.curMode().equals("ECCM") && !mounted.curMode().equals("ECM & ECCM") && !mounted.curMode().equals("ECCM & Ghost Targets")) && (!equipmentType.hasFlag(0x200000000L) || !mounted.curMode().equals("ECCM"))) continue;
                return !mounted.isInoperable();
            }
        }
        return false;
    }

    public boolean hasActiveAngelECCM() {
        if (this.game.getOptions().booleanOption("tacops_angel_ecm") && this.game.getOptions().booleanOption("tacops_eccm") && !this.isShutDown()) {
            for (Mounted mounted : this.getMisc()) {
                EquipmentType equipmentType = mounted.getType();
                if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(2048L) || !mounted.curMode().equals("ECCM")) continue;
                return !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached() && !this.isShutDown();
            }
        }
        return false;
    }

    public int getECMRange() {
        if (this.game.getBoard().inSpace() && !this.game.getOptions().booleanOption("stratops_ecm")) {
            return -1;
        }
        if (!this.isShutDown()) {
            for (Mounted mounted : this.getMisc()) {
                EquipmentType equipmentType = mounted.getType();
                if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(0x80000000000L) || mounted.isInoperable()) continue;
                if ("Single-Hex ECM".equals(equipmentType.getInternalName())) {
                    return 0;
                }
                if (this.game.getPlanetaryConditions().hasEMI()) {
                    return 12;
                }
                return 6;
            }
        }
        return -1;
    }

    public boolean hasBAP() {
        return this.hasBAP(true);
    }

    public boolean hasBAP(boolean bl) {
        if (this.game != null && this.game.getPlanetaryConditions().hasEMI() || this.isShutDown()) {
            return false;
        }
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(0x100000000000L) || mounted.isInoperable()) continue;
            if (equipmentType.getName().equals("Beagle Active Probe")) {
                return !bl || !Compute.isAffectedByAngelECM(this, this.getPosition(), this.getPosition());
            }
            return !bl || !Compute.isAffectedByECM(this, this.getPosition(), this.getPosition());
        }
        if ((this.crew.getOptions().booleanOption("cyber_eye_im") || this.crew.getOptions().booleanOption("mm_eye_im")) && this instanceof Infantry && !(this instanceof BattleArmor) || this.crew.getOptions().booleanOption("mm_eye_im") && (this.crew.getOptions().booleanOption("vdni") || this.crew.getOptions().booleanOption("bvdni"))) {
            return !bl || !Compute.isAffectedByECM(this, this.getPosition(), this.getPosition());
        }
        return false;
    }

    public int getBAPRange() {
        if (this.game.getPlanetaryConditions().hasEMI() || this.isShutDown()) {
            return -1;
        }
        int n = 0;
        if ((this.crew.getOptions().booleanOption("cyber_eye_im") || this.crew.getOptions().booleanOption("mm_eye_im")) && this instanceof Infantry && !(this instanceof BattleArmor) || this.crew.getOptions().booleanOption("mm_eye_im") && (this.crew.getOptions().booleanOption("vdni") || this.crew.getOptions().booleanOption("bvdni"))) {
            n = 1;
        }
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(0x100000000000L) || mounted.isInoperable()) continue;
            if (this.game.getBoard().inSpace()) {
                if (mounted.curMode().equals("Medium")) {
                    return 12 + n;
                }
                return 6 + n;
            }
            if (mounted.getName().equals("Bloodhound Active Probe (THB)") || mounted.getName().equals("BeagleActiveProbe")) {
                return 8 + n;
            }
            if (mounted.getType().getInternalName().equals("CLActiveProbe") || mounted.getType().getInternalName().equals("WatchdogECMSuite") || mounted.getType().getInternalName().equals("CLBALightActiveProbe")) {
                return 5 + n;
            }
            if (mounted.getType().getInternalName().equals("CLLightActiveProbe") || mounted.getType().getInternalName().equals("CLImprovedSensors")) {
                return 3 + n;
            }
            if (mounted.getType().getInternalName().equals("ISImprovedSensors")) {
                return 2 + n;
            }
            return 4 + n;
        }
        if (n > 0) {
            return 2;
        }
        return -1;
    }

    public boolean hasTargComp() {
        for (Mounted mounted : this.getMisc()) {
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(1024L)) continue;
            return !mounted.isInoperable();
        }
        return false;
    }

    public boolean hasAimModeTargComp() {
        if (this.hasActiveEiCockpit()) {
            if (this instanceof Mech) {
                if (((Mech)this).getCockpitStatus() == 2) {
                    return true;
                }
            } else {
                return true;
            }
        }
        for (Mounted mounted : this.getMisc()) {
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(1024L) || !mounted.curMode().equals("Aimed shot")) continue;
            return !mounted.isInoperable();
        }
        return false;
    }

    public boolean hasC3S() {
        if (this.isShutDown() || this.isOffBoard()) {
            return false;
        }
        for (Mounted mounted : this.getEquipment()) {
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(128L) || mounted.isInoperable()) continue;
            return true;
        }
        return false;
    }

    public boolean hasCASEII() {
        return false;
    }

    public boolean hasCASEII(int n) {
        return false;
    }

    public boolean hasC3M() {
        if (this.isShutDown() || this.isOffBoard()) {
            return false;
        }
        for (Mounted mounted : this.getEquipment()) {
            if (!(mounted.getType() instanceof WeaponType) || !mounted.getType().hasFlag(0x8000000L) || mounted.isInoperable()) continue;
            return !this.C3MasterIs(this) || this.c3CompanyMasterIndex != this.getEquipmentNum(mounted);
        }
        return false;
    }

    public boolean hasC3MM() {
        Object object;
        if (this.isShutDown() || this.isOffBoard()) {
            return false;
        }
        if (this.c3CompanyMasterIndex == -1) {
            return false;
        }
        if (this.c3CompanyMasterIndex == -2) {
            object = this.getEquipment().iterator();
            while (this.c3CompanyMasterIndex == -2 && object.hasNext()) {
                Mounted mounted = (Mounted)object.next();
                if (!(mounted.getType() instanceof WeaponType) || !mounted.getType().hasFlag(0x8000000L) || mounted.isInoperable()) continue;
                while (this.c3CompanyMasterIndex == -2 && object.hasNext()) {
                    mounted = (Mounted)object.next();
                    if (!(mounted.getType() instanceof WeaponType) || !mounted.getType().hasFlag(0x8000000L) || mounted.isInoperable()) continue;
                    this.c3CompanyMasterIndex = this.getEquipmentNum(mounted);
                }
            }
            if (this.c3CompanyMasterIndex == -2) {
                this.c3CompanyMasterIndex = -1;
                return false;
            }
        }
        return !((Mounted)(object = this.getEquipment(this.c3CompanyMasterIndex))).isDestroyed() && !((Mounted)object).isBreached();
    }

    public boolean hasC3() {
        return this.hasC3S() || this.hasC3M() || this.hasC3MM();
    }

    public boolean hasC3i() {
        if (this.isShutDown() || this.isOffBoard()) {
            return false;
        }
        for (Mounted mounted : this.getEquipment()) {
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(256L) || mounted.isInoperable()) continue;
            return true;
        }
        return this instanceof Infantry && this.crew.getOptions().booleanOption("mm_eye_im") && this.crew.getOptions().booleanOption("boost_comm_implant");
    }

    public String getC3NetId() {
        if (this.c3NetIdString == null) {
            if (this.hasC3()) {
                this.c3NetIdString = "C3." + this.getId();
            } else if (this.hasC3i()) {
                this.c3NetIdString = "C3i." + this.getId();
            }
        }
        return this.c3NetIdString;
    }

    public void setC3NetId(Entity entity) {
        if (this.isEnemyOf(entity)) {
            return;
        }
        this.c3NetIdString = entity.c3NetIdString;
    }

    public int calculateFreeC3MNodes() {
        int n;
        block7: {
            block6: {
                n = 0;
                if (!this.hasC3MM()) break block6;
                n = 2;
                if (this.game == null) break block7;
                Enumeration<Entity> enumeration = this.game.getEntities();
                while (enumeration.hasMoreElements()) {
                    Entity entity = enumeration.nextElement();
                    if (!entity.hasC3M() || entity == this) continue;
                    Entity entity2 = entity.getC3Master();
                    if (this.equals(entity2)) {
                        --n;
                    }
                    if (n > 0) continue;
                    return 0;
                }
                break block7;
            }
            if (this.hasC3M() && this.C3MasterIs(this)) {
                n = 3;
                if (this.game != null) {
                    Enumeration<Entity> enumeration = this.game.getEntities();
                    while (enumeration.hasMoreElements()) {
                        Entity entity = enumeration.nextElement();
                        if (!entity.hasC3() || entity == this) continue;
                        Entity entity3 = entity.getC3Master();
                        if (this.equals(entity3)) {
                            --n;
                        }
                        if (n > 0) continue;
                        return 0;
                    }
                }
            }
        }
        return n;
    }

    public int calculateFreeC3Nodes() {
        int n;
        block6: {
            block5: {
                n = 0;
                if (!this.hasC3i()) break block5;
                n = 5;
                if (this.game == null) break block6;
                Enumeration<Entity> enumeration = this.game.getEntities();
                while (enumeration.hasMoreElements()) {
                    Entity entity = enumeration.nextElement();
                    if (this.equals(entity) || !this.onSameC3NetworkAs(entity) || --n > 0) continue;
                    return 0;
                }
                break block6;
            }
            if (this.hasC3M()) {
                n = 3;
                if (this.game != null) {
                    Enumeration<Entity> enumeration = this.game.getEntities();
                    while (enumeration.hasMoreElements()) {
                        Entity entity = enumeration.nextElement();
                        if (!entity.hasC3() || this.equals(entity)) continue;
                        Entity entity2 = entity.getC3Master();
                        if (this.equals(entity2) && (!this.C3MasterIs(this) || !this.hasC3MM() || entity.hasC3S())) {
                            --n;
                        }
                        if (n > 0) continue;
                        return 0;
                    }
                }
            }
        }
        return n;
    }

    public Entity getC3Top() {
        Entity entity = this;
        Entity entity2 = entity.getC3Master();
        while (entity2 != null && !entity2.equals(entity) && entity2.hasC3() && !Compute.isAffectedByECM(entity, entity.getPosition(), entity2.getPosition()) && !Compute.isAffectedByECM(entity2, entity2.getPosition(), entity2.getPosition())) {
            entity = entity2;
            entity2 = entity.getC3Master();
        }
        return entity;
    }

    public Entity getC3Master() {
        if (this.c3Master == -1) {
            return null;
        }
        if (this.hasC3S() && this.c3Master > -1) {
            Entity entity = this.game.getEntity(this.c3Master);
            if (entity == null) {
                this.c3Master = -1;
            } else {
                if (entity.isShutDown()) {
                    return null;
                }
                if (entity.C3MasterIs(entity) && !entity.hasC3MM()) {
                    this.c3Master = -1;
                } else if (!entity.hasC3M()) {
                    this.c3Master = -1;
                }
            }
        } else if (this.hasC3M() && this.c3Master > -1) {
            Entity entity = this.game.getEntity(this.c3Master);
            if (entity == null) {
                this.c3Master = -1;
            } else {
                Entity entity2;
                if (entity.isShutDown()) {
                    return null;
                }
                if (entity.c3CompanyMasterIndex > -1 && !entity.hasC3MM() || entity.c3CompanyMasterIndex <= -1 && !entity.hasC3M()) {
                    this.c3Master = -1;
                } else if (entity != this && (entity2 = entity.getC3Master()) != null && entity2.getC3Master() != entity2) {
                    this.c3Master = -1;
                }
            }
        } else if (!this.isShutDown() && !this.hasC3MM() && this.c3Master > -1) {
            this.c3Master = -1;
        }
        if (this.c3Master == -1) {
            return null;
        }
        return this.game.getEntity(this.c3Master);
    }

    public int getC3MasterId() {
        this.getC3Master();
        return this.c3Master;
    }

    public boolean C3MasterIs(Entity entity) {
        if (entity == null) {
            return this.c3Master == -1;
        }
        return entity.id == this.c3Master;
    }

    public void setC3Master(Entity entity) {
        if (entity == null) {
            this.setC3Master(-1);
        } else {
            if (this.isEnemyOf(entity)) {
                return;
            }
            this.setC3Master(entity.id);
        }
    }

    public void setC3Master(int n) {
        Entity entity;
        Enumeration<Entity> enumeration;
        if (this.id == n != (this.id == this.c3Master)) {
            enumeration = this.game.getEntities();
            while (enumeration.hasMoreElements()) {
                entity = enumeration.nextElement();
                if (!entity.C3MasterIs(this) || this.equals(entity)) continue;
                entity.setC3Master(-1);
            }
        }
        if (this.hasC3()) {
            this.c3Master = n;
        }
        if (this.hasC3() && n == -1) {
            this.c3NetIdString = "C3." + this.id;
        } else if (this.hasC3i() && n == -1) {
            this.c3NetIdString = "C3i." + this.id;
        } else if (this.hasC3() || this.hasC3i()) {
            this.c3NetIdString = this.game.getEntity(n).getC3NetId();
        }
        enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            entity = enumeration.nextElement();
            if (!entity.C3MasterIs(this) || this.equals(entity)) continue;
            entity.c3NetIdString = this.c3NetIdString;
        }
    }

    public boolean onSameC3NetworkAs(Entity entity) {
        return this.onSameC3NetworkAs(entity, false);
    }

    public boolean onSameC3NetworkAs(Entity entity, boolean bl) {
        if (this.isEnemyOf(entity) || this.isShutDown() || entity.isShutDown()) {
            return false;
        }
        if (this instanceof Mech && this.isStealthActive()) {
            return false;
        }
        if (entity instanceof Mech && entity.isStealthActive()) {
            return false;
        }
        if (this.hasC3i() && entity.hasC3i() && this.getC3NetId().equals(entity.getC3NetId())) {
            if (bl) {
                return true;
            }
            return !Compute.isAffectedByECM(entity, entity.getPosition(), entity.getPosition()) && !Compute.isAffectedByECM(this, this.getPosition(), this.getPosition());
        }
        if (!this.hasC3() || !entity.hasC3()) {
            return false;
        }
        if (this.getC3Top() == null || entity.getC3Top() == null) {
            return false;
        }
        return this.getC3Top().equals(entity.getC3Top());
    }

    public boolean locationHasCase(int n) {
        for (Mounted mounted : this.getMisc()) {
            if (mounted.getLocation() != n || !mounted.getType().hasFlag(8L) || mounted.isDestroyed()) continue;
            return true;
        }
        return false;
    }

    public void hitAllCriticals(int n, int n2) {
        CriticalSlot criticalSlot = this.getCritical(n, n2);
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            CriticalSlot criticalSlot2 = this.getCritical(n, n2);
            if (criticalSlot2.getType() != criticalSlot.getType() || criticalSlot2.getIndex() != criticalSlot.getIndex()) continue;
            criticalSlot2.setHit(true);
        }
    }

    @Override
    public void newRound(int n) {
        this.unloadedThisTurn = false;
        this.done = false;
        this.delta_distance = 0;
        this.mpUsedLastRound = this.mpUsed;
        this.mpUsed = 0;
        this.damageThisRound = 0;
        if (this.assaultDropInProgress == 2) {
            this.assaultDropInProgress = 0;
        }
        this.moved = 0;
        this.gotPavementBonus = false;
        this.hitThisRoundByAntiTSM = false;
        this.inReverse = false;
        this.hitBySwarmsEntity.clear();
        this.hitBySwarmsWeapon.clear();
        this.setTaggedBy(-1);
        this.setLayingMines(false);
        this.setArmsFlipped(false);
        this.setDisplacementAttack(null);
        this.setFindingClub(false);
        this.setSpotting(false);
        this.spotTargetId = -1;
        this.setClearingMinefield(false);
        this.setUnjammingRAC(false);
        this.crew.setKoThisRound(false);
        this.m_lNarcedBy |= this.m_lPendingNarc;
        if (this.pendingINarcPods.size() > 0) {
            this.iNarcPods.addAll(this.pendingINarcPods);
            this.pendingINarcPods = new ArrayList();
        }
        if (this.pendingNarcPods.size() > 0) {
            this.narcPods.addAll(this.pendingNarcPods);
            this.pendingNarcPods.clear();
        }
        for (Mounted serializable : this.getEquipment()) {
            serializable.newRound(n);
        }
        this.setPassedThrough(new Vector<Coords>());
        this.resetFiringArcs();
        this.setEvading(false);
        this.sensorCheck = Compute.d6(2);
        if (null != this.nextSensor && this.nextSensor.isBAP() && !this.hasBAP(false)) {
            for (Sensor sensor : this.getSensors()) {
                if (sensor.isBAP()) continue;
                this.nextSensor = sensor;
                break;
            }
        }
        if (null != this.nextSensor) {
            this.activeSensor = this.nextSensor;
        }
        this.ghostTargetRoll = Compute.d6(2);
        this.ghostTargetOverride = Compute.d6(2);
        this.infernos.newRound(n);
        if (this.taserShutdownRounds > 0) {
            --this.taserShutdownRounds;
            if (this.taserShutdownRounds == 0) {
                this.shutdownByBATaser = false;
            }
        }
        if (this.taserInterferenceRounds > 0) {
            --this.taserInterferenceRounds;
            if (this.taserInterferenceRounds == 0) {
                this.taserInterference = 0;
            }
        }
        if (this.taserFeedBackRounds > 0) {
            --this.taserFeedBackRounds;
        }
    }

    public void applyDamage() {
        Serializable serializable;
        int n;
        for (Mounted mounted : this.getEquipment()) {
            if (!mounted.isHit() && !mounted.isMissing()) continue;
            mounted.setShotsLeft(0);
            mounted.setDestroyed(true);
        }
        for (n = 0; n < this.locations(); ++n) {
            for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
                serializable = this.getCritical(n, i);
                if (serializable == null) continue;
                ((CriticalSlot)serializable).setDestroyed(((CriticalSlot)serializable).isDamaged());
            }
        }
        for (n = 0; n < this.locations(); ++n) {
            if (this.getInternal(n) != -2) continue;
            this.setArmor(-3, n);
            this.setArmor(-3, n, true);
            this.setInternal(-3, n);
            Iterator<Serializable> iterator = this.narcPods.iterator();
            while (iterator.hasNext()) {
                serializable = iterator.next();
                if (((NarcPod)serializable).getLocation() != n) continue;
                iterator.remove();
            }
            iterator = this.iNarcPods.iterator();
            while (iterator.hasNext()) {
                serializable = (INarcPod)iterator.next();
                if (((INarcPod)serializable).getLocation() != n) continue;
                iterator.remove();
            }
            iterator = this.pendingNarcPods.iterator();
            while (iterator.hasNext()) {
                serializable = (NarcPod)iterator.next();
                if (((NarcPod)serializable).getLocation() != n) continue;
                iterator.remove();
            }
            iterator = this.pendingINarcPods.iterator();
            while (iterator.hasNext()) {
                serializable = (INarcPod)iterator.next();
                if (((INarcPod)serializable).getLocation() != n) continue;
                iterator.remove();
            }
        }
    }

    public void reloadEmptyWeapons() {
        for (Mounted mounted : this.getTotalWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.getAmmoType() == -1 || mounted.getLinked() != null && mounted.getLinked().getShotsLeft() > 0 && !mounted.getLinked().isDumping()) continue;
            this.loadWeaponWithSameAmmo(mounted);
        }
    }

    public void assignAMS(Vector<WeaponHandler> vector) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Mounted mounted : this.getWeaponList()) {
            if (!mounted.getType().hasFlag(0x800000L) || !mounted.isReady() || mounted.isMissing() || mounted.curMode().equals("Off")) continue;
            Mounted mounted2 = mounted.getLinked();
            if (!mounted.getType().hasFlag(131072L) && (mounted2 == null || mounted2.getShotsLeft() == 0 || mounted2.isDumping())) {
                this.loadWeapon(mounted);
                mounted2 = mounted.getLinked();
            }
            if (!mounted.getType().hasFlag(131072L) && (mounted2 == null || mounted2.getShotsLeft() == 0 || mounted2.isDumping())) continue;
            Vector<WeaponAttackAction> vector2 = new Vector<WeaponAttackAction>(vector.size());
            for (WeaponHandler weaponHandler : vector) {
                if (hashSet.contains(weaponHandler.waa) || !Compute.isInArc(this.game, this.getId(), this.getEquipmentNum(mounted), this.game.getEntity(weaponHandler.waa.getEntityId()))) continue;
                vector2.addElement(weaponHandler.waa);
            }
            WeaponAttackAction weaponAttackAction = Compute.getHighestExpectedDamage(this.game, vector2, true);
            if (weaponAttackAction == null) continue;
            weaponAttackAction.addCounterEquipment(mounted);
            hashSet.add(weaponAttackAction);
        }
    }

    public boolean isNarcedBy(int n) {
        for (NarcPod narcPod : this.narcPods) {
            if (narcPod.getTeam() != n) continue;
            return true;
        }
        return false;
    }

    public void attachNarcPod(NarcPod narcPod) {
        this.pendingNarcPods.add(narcPod);
    }

    public void attachINarcPod(INarcPod iNarcPod) {
        this.pendingINarcPods.add(iNarcPod);
    }

    public boolean isINarcedBy(int n) {
        for (INarcPod iNarcPod : this.iNarcPods) {
            if (iNarcPod.getTeam() != n || iNarcPod.getType() != 1) continue;
            return true;
        }
        return false;
    }

    public boolean isINarcedWith(long l) {
        for (INarcPod iNarcPod : this.iNarcPods) {
            if ((long)iNarcPod.getType() != l) continue;
            return true;
        }
        return false;
    }

    public void removeAllINarcPods() {
        this.iNarcPods.clear();
    }

    public boolean hasINarcPodsAttached() {
        return this.iNarcPods.size() > 0;
    }

    public Iterator<INarcPod> getINarcPodsAttached() {
        return this.iNarcPods.iterator();
    }

    public boolean removeINarcPod(INarcPod iNarcPod) {
        return this.iNarcPods.remove(iNarcPod);
    }

    public abstract int calculateBattleValue();

    public int calculateBattleValue(boolean bl, boolean bl2) {
        return this.calculateBattleValue();
    }

    public abstract Vector<Report> victoryReport();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Entity entity = (Entity)object;
        return entity.getId() == this.id;
    }

    public int getMovementMode() {
        return this.movementMode;
    }

    public String getMovementModeAsString() {
        switch (this.getMovementMode()) {
            case 0: {
                return "None";
            }
            case 1: 
            case 13: {
                return "Biped";
            }
            case 2: 
            case 14: {
                return "Quad";
            }
            case 3: {
                return "Tracked";
            }
            case 4: {
                return "Wheeled";
            }
            case 5: {
                return "Hover";
            }
            case 6: {
                return "VTOL";
            }
            case 7: {
                return "Naval";
            }
            case 8: {
                return "Hydrofoil";
            }
            case 9: 
            case 18: {
                return "Submarine";
            }
            case 10: {
                return "Leg";
            }
            case 11: {
                return "Motorized";
            }
            case 12: {
                return "Jump";
            }
            case 15: {
                return "WiGE";
            }
            case 16: {
                return "Aerodyne";
            }
            case 17: {
                return "Spheroid";
            }
        }
        return "ERROR";
    }

    public void setMovementMode(int n) {
        this.movementMode = n;
    }

    public boolean entityIsBiped() {
        return this.getMovementMode() == 1;
    }

    public boolean entityIsQuad() {
        return this.getMovementMode() == 2;
    }

    public boolean needsRollToStand() {
        return true;
    }

    public PilotingRollData getBasePilotingRoll() {
        return this.getBasePilotingRoll(this.moved);
    }

    public PilotingRollData getBasePilotingRoll(int n) {
        int n2 = this.getId();
        if (this.getCrew().isDead() || this.getCrew().isDoomed() || this.getCrew().getHits() >= 6) {
            return new PilotingRollData(n2, 0x7FFFFFFE, "Pilot dead");
        }
        if (!this.getCrew().isActive()) {
            return new PilotingRollData(n2, Integer.MAX_VALUE, "Pilot unconscious");
        }
        if (this.getBadCriticals(0, 4, 1) > 1 && this.getGyroType() != 3) {
            return new PilotingRollData(n2, 0x7FFFFFFE, this.getCrew().getPiloting() + 6, "Gyro destroyed");
        }
        if (this.getBadCriticals(0, 4, 1) > 2 && this.getGyroType() == 3) {
            return new PilotingRollData(n2, 0x7FFFFFFE, this.getCrew().getPiloting() + 6, "Gyro destroyed");
        }
        if (this instanceof BipedMech) {
            if (((BipedMech)this).countBadLegs() == 2) {
                return new PilotingRollData(n2, 0x7FFFFFFE, this.getCrew().getPiloting() + 10, "Both legs destroyed");
            }
        } else if (this instanceof QuadMech && ((QuadMech)this).countBadLegs() >= 3) {
            return new PilotingRollData(n2, 0x7FFFFFFE, this.getCrew().getPiloting() + ((Mech)this).countBadLegs() * 5, ((Mech)this).countBadLegs() + " legs destroyed");
        }
        if (this.isShutDown() && this.isShutDownThisPhase()) {
            return new PilotingRollData(n2, 0x7FFFFFFE, this.getCrew().getPiloting() + 3, "Reactor shut down");
        }
        if (this.isShutDown()) {
            return new PilotingRollData(n2, 0x7FFFFFFE, Integer.MAX_VALUE, "Reactor shut down");
        }
        PilotingRollData pilotingRollData = new PilotingRollData(n2, this.getCrew().getPiloting(), "Base piloting skill");
        pilotingRollData = this.addEntityBonuses(pilotingRollData);
        pilotingRollData = this.addConditionBonuses(pilotingRollData, n);
        if (this.isCarefulStand()) {
            pilotingRollData.addModifier(-2, "careful stand");
        }
        if (this.game.getOptions().booleanOption("tacops_fatigue") && this.crew.isPilotingFatigued(this.game.getRoundCount())) {
            pilotingRollData.addModifier(1, "fatigue");
        }
        if (this.taserInterference > 0) {
            pilotingRollData.addModifier(this.taserInterference, "taser interference");
        }
        return pilotingRollData;
    }

    public abstract PilotingRollData addEntityBonuses(PilotingRollData var1);

    public PilotingRollData addConditionBonuses(PilotingRollData pilotingRollData, int n) {
        int n2;
        int n3;
        int n4;
        PlanetaryConditions planetaryConditions = this.game.getPlanetaryConditions();
        if ((n == 2 || n == 5 || n == 10) && (n4 = planetaryConditions.getLightPilotPenalty()) > 0) {
            pilotingRollData.addModifier(n4, planetaryConditions.getLightCurrentName());
        }
        if ((n4 = planetaryConditions.getWeatherPilotPenalty()) != 0 && !this.game.getBoard().inSpace()) {
            pilotingRollData.addModifier(n4, planetaryConditions.getWeatherCurrentName());
        }
        if ((n3 = planetaryConditions.getWindPilotPenalty(this)) != 0 && !this.game.getBoard().inSpace()) {
            pilotingRollData.addModifier(n3, planetaryConditions.getWindCurrentName());
        }
        if ((n2 = planetaryConditions.getGravityPilotPenalty()) != 0 && !this.game.getBoard().inSpace()) {
            pilotingRollData.addModifier(n2, "high/low gravity");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkGetUp(MoveStep moveStep) {
        if (moveStep == null || moveStep.getType() != 5 && moveStep.getType() != 50) {
            return new PilotingRollData(this.id, -2147483647, "Check false: Entity is not attempting to get up.");
        }
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(moveStep.getParent().getLastStepMovementType());
        if (this instanceof BipedMech && ((Mech)this).countBadLegs() >= 1 && this.isLocationBad(5) && this.isLocationBad(4)) {
            pilotingRollData.addModifier(Integer.MAX_VALUE, "can't get up with destroyed leg and arms");
            return pilotingRollData;
        }
        if (this.isHullDown() && this instanceof QuadMech) {
            pilotingRollData.addModifier(Integer.MIN_VALUE, "getting up from hull down");
            return pilotingRollData;
        }
        if (!this.needsRollToStand() && this.getBadCriticals(0, 4, 1) < 2) {
            pilotingRollData.addModifier(Integer.MIN_VALUE, "\n" + this.getDisplayName() + " does not need to make a piloting skill check to stand up because it has all four of its legs.");
            return pilotingRollData;
        }
        pilotingRollData.append(new PilotingRollData(this.getId(), 0, "getting up"));
        this.addPilotingModifierForTerrain(pilotingRollData, moveStep);
        return pilotingRollData;
    }

    public PilotingRollData checkRunningWithDamage(int n) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(n);
        int n2 = this.getBadCriticals(0, 4, 1);
        if (this.getGyroType() == 3) {
            --n2;
        }
        if (n == 2 && !this.isProne() && (n2 > 0 || this.hasHipCrit())) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "running with damaged hip actuator or gyro"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: Entity is not attempting to run with damage");
        }
        this.addPilotingModifierForTerrain(pilotingRollData);
        return pilotingRollData;
    }

    public PilotingRollData checkRecklessMove(MoveStep moveStep, IHex iHex, Coords coords, Coords coords2, IHex iHex2) {
        boolean bl;
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(moveStep.getParent().getLastStepMovementType());
        if (moveStep.getParent().isCareful()) {
            pilotingRollData.addModifier(-2147483647, "moving carefully");
            return pilotingRollData;
        }
        boolean bl2 = this.game.getPlanetaryConditions().getFog() != 0;
        boolean bl3 = bl = this.game.getPlanetaryConditions().getLight() > 1;
        if (moveStep.getMovementType() == 3) {
            pilotingRollData.addModifier(-2147483647, "jumping is not reckless?");
            return pilotingRollData;
        }
        if ((bl2 || bl) && !coords.equals(coords2) && coords.equals(moveStep.getParent().getEntity().getPosition())) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "moving recklessly"));
        } else if ((bl2 || bl) && !coords.equals(coords2) && (iHex.movementCost(moveStep.getParent().getLastStepMovementType()) > 0 || null != iHex2 && iHex2.getElevation() != iHex.getElevation())) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "moving recklessly"));
        } else if (iHex.containsTerrain(17)) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "moving recklessly"));
        } else {
            pilotingRollData.addModifier(-2147483647, "not moving recklessly");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkLandingWithDamage(int n) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(n);
        if (this.getBadCriticals(0, 4, 1) > 0 && this.getGyroType() != 3 || this.getBadCriticals(0, 4, 1) > 1 && this.getGyroType() == 3 || this.hasLegActuatorCrit()) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "landing with damaged leg actuator or gyro"));
            this.addPilotingModifierForTerrain(pilotingRollData);
        } else {
            pilotingRollData.addModifier(-2147483647, "Entity does not have gyro or leg accutator damage -- checking for purposes of determining PSR after jump.");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkLandingOnIce(int n, IHex iHex) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(n);
        if (iHex.containsTerrain(17) && iHex.terrainLevel(2) > 0) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "landing on ice-covered water"));
            this.addPilotingModifierForTerrain(pilotingRollData);
        } else {
            pilotingRollData.addModifier(-2147483647, "hex is not covered by ice");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkMovedTooFast(MoveStep moveStep) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(moveStep.getParent().getLastStepMovementType());
        this.addPilotingModifierForTerrain(pilotingRollData, moveStep);
        switch (moveStep.getMovementType()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                if (moveStep.getMpUsed() > (int)Math.ceil((double)this.getOriginalWalkMP() * 1.5)) {
                    pilotingRollData.append(new PilotingRollData(this.getId(), 0, "used more MPs than at 1G possible"));
                    break;
                }
                pilotingRollData.addModifier(-2147483647, "Check false: Entity did not use more MPs walking/running than possible at 1G");
                break;
            }
            case 3: {
                if (moveStep.getMpUsed() > this.getJumpMP(false)) {
                    pilotingRollData.append(new PilotingRollData(this.getId(), 0, "used more MPs than at 1G possible"));
                    break;
                }
                pilotingRollData.addModifier(-2147483647, "Check false: Entity did not use more MPs jumping than possible at 1G");
            }
        }
        return pilotingRollData;
    }

    public PilotingRollData checkSkid(int n, IHex iHex, int n2, MoveStep moveStep, int n3, int n4, Coords coords, Coords coords2, boolean bl, int n5) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(n2);
        this.addPilotingModifierForTerrain(pilotingRollData, coords);
        if (!(n == 3 || iHex == null || !(moveStep.isPavementStep() && n2 == 2 && this.movementMode != 5 && this.movementMode != 15 || iHex.containsTerrain(17) && this.movementMode != 5 && this.movementMode != 15) && (this.movementMode != 5 && this.movementMode != 15 || this.game.getPlanetaryConditions().getWeather() != 7 && this.game.getPlanetaryConditions().getWindStrength() < 4) || n3 == n4 || coords.equals(coords2) || bl || moveStep.isHasJustStood())) {
            if (moveStep.isPavementStep() && !iHex.containsTerrain(17)) {
                if (this instanceof Mech) {
                    pilotingRollData.append(new PilotingRollData(this.getId(), this.getMovementBeforeSkidPSRModifier(n5), "running & turning on pavement"));
                } else {
                    pilotingRollData.append(new PilotingRollData(this.getId(), this.getMovementBeforeSkidPSRModifier(n5), "reckless driving on pavement"));
                }
            } else {
                pilotingRollData.append(new PilotingRollData(this.getId(), this.getMovementBeforeSkidPSRModifier(n5), "turning on ice"));
            }
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: Entity is not apparently skidding");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkRubbleMove(MoveStep moveStep, IHex iHex, Coords coords, Coords coords2) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(moveStep.getParent().getLastStepMovementType());
        this.addPilotingModifierForTerrain(pilotingRollData, coords2);
        if (!coords.equals(coords2) && moveStep.getMovementType() != 3 && iHex.terrainLevel(4) > 0 && this instanceof Mech) {
            int n = 0;
            if (iHex.terrainLevel(4) > 5) {
                ++n;
            }
            pilotingRollData.append(new PilotingRollData(this.getId(), n, "entering Rubble"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: Entity is not entering rubble");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkBogDown(MoveStep moveStep, IHex iHex, Coords coords, Coords coords2, int n, boolean bl) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(moveStep.getParent().getLastStepMovementType());
        int n2 = iHex.getBogDownModifier(this.getMovementMode(), this instanceof LargeSupportTank);
        if (!(coords.equals(coords2) && moveStep.getElevation() == n || n2 == Integer.MIN_VALUE || moveStep.getMovementType() == 3 || moveStep.getElevation() != 0 || bl)) {
            pilotingRollData.append(new PilotingRollData(this.getId(), n2, "avoid bogging down"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: Not entering bog-down terrain, or jumping/hovering over such terrain");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkWaterMove(MoveStep moveStep, IHex iHex, Coords coords, Coords coords2, boolean bl) {
        if (iHex.terrainLevel(2) > 0 && moveStep.getElevation() < 0 && !coords.equals(coords2) && moveStep.getMovementType() != 3 && this.getMovementMode() != 5 && this.getMovementMode() != 6 && this.getMovementMode() != 7 && this.getMovementMode() != 8 && this.getMovementMode() != 9 && this.getMovementMode() != 18 && this.getMovementMode() != 13 && this.getMovementMode() != 14 && this.getMovementMode() != 15 && !bl) {
            return this.checkWaterMove(iHex.terrainLevel(2), moveStep.getParent().getLastStepMovementType());
        }
        return this.checkWaterMove(0, moveStep.getParent().getLastStepMovementType());
    }

    public PilotingRollData checkWaterMove(int n, int n2) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(n2);
        int n3 = n == 1 ? -1 : (n == 2 ? 0 : 1);
        if (n > 0 && !this.hasUMU()) {
            pilotingRollData.append(new PilotingRollData(this.getId(), n3, "entering Depth " + n + " Water"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: No water here.");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkDislodgeSwarmers(MoveStep moveStep) {
        if (-1 == this.getSwarmAttackerId()) {
            return new PilotingRollData(this.getId(), -2147483647, "Check false: No swarmers attached");
        }
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(moveStep.getParent().getLastStepMovementType());
        pilotingRollData.append(new PilotingRollData(this.getId(), 0, "attempting to dislodge swarmers by dropping prone"));
        this.addPilotingModifierForTerrain(pilotingRollData, moveStep);
        return pilotingRollData;
    }

    public int checkMovementInBuilding(MoveStep moveStep, MoveStep moveStep2, Coords coords, Coords coords2) {
        if (coords2.equals(coords)) {
            return 0;
        }
        IHex iHex = this.game.getBoard().getHex(coords);
        IHex iHex2 = this.game.getBoard().getHex(coords2);
        if (this instanceof Infantry && moveStep.getMovementType() != 3) {
            return 0;
        }
        if (this instanceof Protomech && moveStep2 != null && moveStep2.getMovementType() == 3) {
            return 0;
        }
        int n = 0;
        if (moveStep.getElevation() < iHex.terrainLevel(24)) {
            n += 2;
        } else if ((moveStep.getElevation() == iHex.terrainLevel(24) || moveStep.getElevation() == iHex.terrainLevel(28)) && moveStep.getMovementType() != 3) {
            n += 4;
        }
        if (iHex2 != null) {
            int n2 = this.getElevation();
            if (moveStep2 != null) {
                n2 = moveStep2.getElevation();
            }
            if (n2 < iHex2.terrainLevel(24)) {
                ++n;
            }
        }
        if (n > 1) {
            Building building = null;
            building = this.game.getBoard().getBuildingAt(coords);
            if (building.getType() == 5) {
                return 4;
            }
        }
        if ((this instanceof Infantry || this instanceof Protomech) && n != 2) {
            n = 0;
        }
        return n;
    }

    public PilotingRollData rollMovementInBuilding(Building building, int n, String string, int n2) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(n2);
        int n3 = 0;
        String string2 = string == "" ? "moving through " : string + " ";
        switch (building.getType()) {
            case 1: {
                string2 = "Light";
                break;
            }
            case 2: {
                n3 = 1;
                string2 = "Medium";
                break;
            }
            case 3: {
                n3 = 2;
                string2 = "Heavy";
                break;
            }
            case 4: {
                n3 = 5;
                string2 = "Hardened";
                break;
            }
            case 5: {
                n3 = 12;
                string2 = "";
            }
        }
        pilotingRollData.append(new PilotingRollData(this.getId(), n3, "moving through " + string2 + " " + building.getName()));
        if (n >= 25) {
            pilotingRollData.addModifier(6, "moved 25+ hexes");
        } else if (n >= 18) {
            pilotingRollData.addModifier(5, "moved 18-24 hexes");
        } else if (n >= 10) {
            pilotingRollData.addModifier(4, "moved 10+ hexes");
        } else if (n >= 7) {
            pilotingRollData.addModifier(3, "moved 7-9 hexes");
        } else if (n >= 5) {
            pilotingRollData.addModifier(2, "moved 5-6 hexes");
        } else if (n >= 3) {
            pilotingRollData.addModifier(1, "moved 3-4 hexes");
        }
        return pilotingRollData;
    }

    public int getMovementBeforeSkidPSRModifier(int n) {
        int n2 = -1;
        n2 = n > 24 ? 6 : (n > 17 ? 5 : (n > 10 ? 4 : (n > 7 ? 2 : (n > 4 ? 1 : (n > 2 ? 0 : -1)))));
        if (this.getCrew().getOptions().booleanOption("maneuvering_ace")) {
            --n2;
        }
        return n2;
    }

    public abstract int getMaxElevationChange();

    public int getMaxElevationDown() {
        return this.getMaxElevationChange();
    }

    public static String encodeTransporters(Entity entity) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<Transporter> enumeration = entity.transports.elements();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(',');
            }
            Transporter transporter = enumeration.nextElement();
            stringBuffer.append(transporter.getClass().getName());
            if (!(transporter instanceof TroopSpace)) continue;
            stringBuffer.append("=").append(((TroopSpace)transporter).totalSpace);
        }
        return stringBuffer.toString();
    }

    public static void decodeTransporters(Entity entity, String string) throws IllegalStateException {
        Enumeration<String> enumeration = StringUtil.splitString(string, ",").elements();
        while (enumeration.hasMoreElements()) {
            try {
                String string2 = enumeration.nextElement();
                Class<?> clazz = Class.forName(string2);
                TroopSpace troopSpace = null;
                if (TroopSpace.class.getName().equals(string2)) {
                    int n = Integer.parseInt(string2.substring(string2.lastIndexOf("=")));
                    troopSpace = new TroopSpace(n);
                } else {
                    troopSpace = (TroopSpace)clazz.newInstance();
                }
                entity.addTransporter(troopSpace);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IllegalStateException(exception.getMessage());
            }
        }
    }

    public void addTransporter(Transporter transporter) {
        this.transports.insertElementAt(transporter, 0);
    }

    public void removeAllTransporters() {
        this.transports = new Vector();
    }

    @Override
    public boolean canLoad(Entity entity) {
        if (this instanceof Infantry) {
            return false;
        }
        if (!entity.isEnemyOf(this)) {
            Enumeration<Transporter> enumeration = this.transports.elements();
            while (enumeration.hasMoreElements()) {
                Transporter transporter = enumeration.nextElement();
                if (!transporter.canLoad(entity) || entity.getElevation() != this.getElevation()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void load(Entity entity) {
        Enumeration<Transporter> enumeration = this.transports.elements();
        while (enumeration.hasMoreElements()) {
            Transporter transporter = enumeration.nextElement();
            if (!transporter.canLoad(entity) || entity.getElevation() != this.getElevation()) continue;
            transporter.load(entity);
            return;
        }
        throw new IllegalArgumentException(this.getShortName() + " can not load " + entity.getShortName());
    }

    public void recover(Entity entity) {
        Enumeration<Transporter> enumeration = this.transports.elements();
        while (enumeration.hasMoreElements()) {
            Transporter transporter = enumeration.nextElement();
            if (!transporter.canLoad(entity) || entity.getElevation() != this.getElevation()) continue;
            if (transporter instanceof ASFBay) {
                ((ASFBay)transporter).recover(entity);
                return;
            }
            if (!(transporter instanceof SmallCraftBay)) continue;
            ((SmallCraftBay)transporter).recover(entity);
            return;
        }
        throw new IllegalArgumentException(this.getShortName() + " can not recover " + entity.getShortName());
    }

    public void updateBays() {
        Enumeration<Transporter> enumeration = this.transports.elements();
        while (enumeration.hasMoreElements()) {
            Transporter transporter = enumeration.nextElement();
            if (!(transporter instanceof ASFBay)) continue;
            ASFBay aSFBay = (ASFBay)transporter;
            aSFBay.updateSlots();
        }
    }

    public String damageBayDoor() {
        Transporter transporter;
        String string = "none";
        Vector<Bay> vector = new Vector<Bay>();
        Enumeration<Transporter> enumeration = this.transports.elements();
        while (enumeration.hasMoreElements()) {
            Bay bay;
            transporter = enumeration.nextElement();
            if (!(transporter instanceof Bay) || (bay = (Bay)transporter).getDoors() <= 0) continue;
            vector.add(bay);
        }
        if (vector.size() > 0) {
            transporter = (Bay)vector.elementAt(Compute.randomInt(vector.size()));
            ((Bay)transporter).destroyDoor();
            ((Bay)transporter).resetDoors();
            ((Bay)transporter).setDoors(((Bay)transporter).getDoors() - 1);
            string = ((Bay)transporter).getType();
        }
        return string;
    }

    public void damageDoorRecovery(Entity entity) {
        Enumeration<Transporter> enumeration = this.transports.elements();
        while (enumeration.hasMoreElements()) {
            Transporter transporter = enumeration.nextElement();
            if (transporter instanceof ASFBay && transporter.canLoad(entity)) {
                ((ASFBay)transporter).destroyDoor();
                break;
            }
            if (!(transporter instanceof SmallCraftBay) || !transporter.canLoad(entity)) continue;
            ((SmallCraftBay)transporter).destroyDoor();
            break;
        }
    }

    public boolean damageDockCollar() {
        Transporter transporter;
        boolean bl = false;
        Vector<DockingCollar> vector = new Vector<DockingCollar>();
        Enumeration<Transporter> enumeration = this.transports.elements();
        while (enumeration.hasMoreElements()) {
            DockingCollar dockingCollar;
            transporter = enumeration.nextElement();
            if (!(transporter instanceof DockingCollar) || (dockingCollar = (DockingCollar)transporter).isDamaged()) continue;
            vector.add(dockingCollar);
        }
        if (vector.size() > 0) {
            transporter = (DockingCollar)vector.elementAt(Compute.randomInt(vector.size()));
            ((DockingCollar)transporter).setDamaged(true);
            bl = true;
        }
        return bl;
    }

    public void pickUp(MechWarrior mechWarrior) {
        this.pickedUpMechWarriors.addElement(new Integer(mechWarrior.getId()));
    }

    @Override
    public Vector<Entity> getLoadedUnits() {
        Vector<Entity> vector = new Vector<Entity>();
        for (Transporter transporter : this.transports) {
            for (Entity entity : transporter.getLoadedUnits()) {
                vector.addElement(entity);
            }
        }
        return vector;
    }

    public int getDocks() {
        int n = 0;
        for (Transporter transporter : this.transports) {
            if (!(transporter instanceof DockingCollar)) continue;
            ++n;
        }
        return n;
    }

    public Vector<Entity> getBayLoadedUnits() {
        Vector<Entity> vector = new Vector<Entity>();
        for (Transporter transporter : this.transports) {
            if (!(transporter instanceof Bay)) continue;
            for (Entity entity : transporter.getLoadedUnits()) {
                vector.addElement(entity);
            }
        }
        return vector;
    }

    public Vector<Entity> getLoadedFighters() {
        Vector<Entity> vector = new Vector<Entity>();
        for (Transporter transporter : this.transports) {
            if (!(transporter instanceof ASFBay) || ((ASFBay)transporter).getDoors() <= 0) continue;
            for (Entity entity : transporter.getLoadedUnits()) {
                vector.addElement(entity);
            }
        }
        return vector;
    }

    public Vector<Entity> getLaunchableFighters() {
        Vector<Entity> vector = new Vector<Entity>();
        for (Transporter transporter : this.transports) {
            if (!(transporter instanceof ASFBay) || ((ASFBay)transporter).getDoors() <= 0) continue;
            Bay bay = (Bay)transporter;
            for (Entity entity : bay.getLaunchableUnits()) {
                vector.addElement(entity);
            }
        }
        return vector;
    }

    public Bay getLoadedBay(int n) {
        Vector<Bay> vector = this.getFighterBays();
        for (int i = 0; i < vector.size(); ++i) {
            Bay bay = vector.elementAt(i);
            Vector<Entity> vector2 = bay.getLoadedUnits();
            for (int j = 0; j < vector2.size(); ++j) {
                Entity entity = vector2.elementAt(j);
                if (entity.getId() != n) continue;
                return bay;
            }
        }
        return null;
    }

    public Vector<Bay> getFighterBays() {
        Vector<Bay> vector = new Vector<Bay>();
        for (Transporter transporter : this.transports) {
            if (!(transporter instanceof ASFBay) && !(transporter instanceof SmallCraftBay) || ((Bay)transporter).getDoors() <= 0) continue;
            vector.addElement((Bay)transporter);
        }
        return vector;
    }

    public Vector<Bay> getTransportBays() {
        Vector<Bay> vector = new Vector<Bay>();
        for (Transporter transporter : this.transports) {
            if (!(transporter instanceof Bay)) continue;
            vector.addElement((Bay)transporter);
        }
        return vector;
    }

    public void resetBayDoors() {
        for (Transporter transporter : this.transports) {
            if (!(transporter instanceof Bay)) continue;
            ((Bay)transporter).resetDoors();
        }
    }

    public int getFighterLaunchRate() {
        int n = 0;
        for (Transporter transporter : this.transports) {
            if (!(transporter instanceof ASFBay)) continue;
            n += 2 * ((ASFBay)transporter).getDoors();
        }
        return n;
    }

    public Vector<Entity> getLoadedSmallCraft() {
        Vector<Entity> vector = new Vector<Entity>();
        for (Transporter transporter : this.transports) {
            if (!(transporter instanceof SmallCraftBay) || ((SmallCraftBay)transporter).getDoors() <= 0) continue;
            for (Entity entity : transporter.getLoadedUnits()) {
                vector.addElement(entity);
            }
        }
        return vector;
    }

    public Vector<Entity> getLaunchableSmallCraft() {
        Vector<Entity> vector = new Vector<Entity>();
        for (Transporter transporter : this.transports) {
            if (!(transporter instanceof SmallCraftBay) || ((SmallCraftBay)transporter).getDoors() <= 0) continue;
            Bay bay = (Bay)transporter;
            for (Entity entity : bay.getLaunchableUnits()) {
                vector.addElement(entity);
            }
        }
        return vector;
    }

    public Vector<SmallCraftBay> getSmallCraftBays() {
        Vector<SmallCraftBay> vector = new Vector<SmallCraftBay>();
        for (Transporter transporter : this.transports) {
            if (!(transporter instanceof SmallCraftBay) || ((SmallCraftBay)transporter).getDoors() <= 0) continue;
            vector.addElement((SmallCraftBay)transporter);
        }
        return vector;
    }

    public int getSmallCraftLaunchRate() {
        int n = 0;
        for (Transporter transporter : this.transports) {
            if (!(transporter instanceof SmallCraftBay)) continue;
            n += 2 * ((SmallCraftBay)transporter).getDoors();
        }
        return n;
    }

    @Override
    public boolean unload(Entity entity) {
        Enumeration<Transporter> enumeration = this.transports.elements();
        while (enumeration.hasMoreElements()) {
            Transporter transporter = enumeration.nextElement();
            if (!transporter.unload(entity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getUnusedString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<Transporter> enumeration = this.transports.elements();
        while (enumeration.hasMoreElements()) {
            Transporter transporter = enumeration.nextElement();
            stringBuffer.append(transporter.getUnusedString());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isWeaponBlockedAt(int n, boolean bl) {
        for (Transporter transporter : this.transports) {
            if (!transporter.isWeaponBlockedAt(n, bl)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Entity getExteriorUnitAt(int n, boolean bl) {
        for (Transporter transporter : this.transports) {
            Entity entity = transporter.getExteriorUnitAt(n, bl);
            if (null == entity) continue;
            return entity;
        }
        return null;
    }

    public ArrayList<Entity> getExternalUnits() {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        for (Transporter transporter : this.transports) {
            arrayList.addAll(transporter.getExternalUnits());
        }
        return arrayList;
    }

    @Override
    public int getCargoMpReduction() {
        int n = 0;
        for (Transporter transporter : this.transports) {
            n += transporter.getCargoMpReduction();
        }
        return n;
    }

    public HitData getTrooperAtLocation(HitData hitData, Entity entity) {
        return this.rollHitLocation(0, 0);
    }

    public void setTransportId(int n) {
        this.conveyance = n;
        if (n == -1) {
            this.unloadedThisTurn = true;
            this.done = true;
        }
    }

    public int getTransportId() {
        return this.conveyance;
    }

    public boolean isStealthActive() {
        return false;
    }

    public boolean isStealthOn() {
        return false;
    }

    public boolean isNullSigActive() {
        return false;
    }

    public boolean isVoidSigActive() {
        return false;
    }

    public boolean isChameleonShieldActive() {
        return false;
    }

    public TargetRoll getStealthModifier(int n, Entity entity) {
        TargetRoll targetRoll = null;
        if (!this.isStealthActive()) {
            targetRoll = new TargetRoll(0, "stealth not active");
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                targetRoll = new TargetRoll(0, "stealth not installed");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown range constant: " + n);
            }
        }
        return targetRoll;
    }

    public void setSwarmTargetId(int n) {
        this.swarmTargetId = n;
        if (n == -1) {
            this.unloadedThisTurn = true;
            this.done = true;
        }
    }

    public int getSwarmTargetId() {
        return this.swarmTargetId;
    }

    public void setSwarmAttackerId(int n) {
        this.swarmAttackerId = n;
    }

    public int getSwarmAttackerId() {
        return this.swarmAttackerId;
    }

    public boolean hasInfernoAmmo() {
        boolean bl = false;
        for (Mounted mounted : this.getAmmo()) {
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (ammoType.getAmmoType() != 9 && ammoType.getAmmoType() != 45 || ammoType.getMunitionType() != 0x20000000L || mounted.getShotsLeft() <= 0) continue;
            bl = true;
        }
        return bl;
    }

    public void setSalvage(boolean bl) {
        if (!bl) {
            this.setRemovalCondition(1024);
        }
        this.salvageable = bl;
    }

    public boolean isSalvage() {
        return this.salvageable;
    }

    public boolean isRepairable() {
        return this.isSalvage();
    }

    public int getRemovalCondition() {
        return this.removalCondition;
    }

    public void setRemovalCondition(int n) {
        if (this.removalCondition < n) {
            this.removalCondition = n;
        }
    }

    public boolean isClearingMinefield() {
        return this.clearingMinefield;
    }

    public void setClearingMinefield(boolean bl) {
        this.clearingMinefield = bl;
    }

    public boolean isSpotting() {
        return this.spotting;
    }

    public void setSpotting(boolean bl) {
        this.spotting = bl;
    }

    public boolean canSpot() {
        if (this.game.getOptions().booleanOption("pilots_cannot_spot") && this instanceof MechWarrior) {
            return false;
        }
        return this.isActive() && !this.isOffBoard();
    }

    public String toString() {
        return "Entity [" + this.getDisplayName() + ", " + this.getId() + "]";
    }

    public String statusToString() {
        String string = "Entity [" + this.getDisplayName() + ", " + this.getId() + "]: ";
        if (this.getPosition() != null) {
            string = string + "Location: (" + (this.getPosition().x + 1) + ", " + (this.getPosition().y + 1) + ") ";
        }
        string = string + "Owner: " + this.owner.getName() + " Armor: " + this.getTotalArmor() + "/" + this.getTotalOArmor() + " Internal Structure: " + this.getTotalInternal() + "/" + this.getTotalOInternal();
        if (!this.isActive()) {
            string = string + " Inactive";
        }
        if (this.isImmobile()) {
            string = string + " Immobile";
        }
        if (this.isProne()) {
            string = string + " Prone";
        }
        if (this.isDone()) {
            string = string + " Done";
        }
        return string;
    }

    public String statusToString(int n) {
        if (n == -1) {
            return "No location given.";
        }
        return this.getLocationName(n) + " (" + this.getLocationAbbr(n) + "): Armor: " + this.getArmorString(n) + "/" + this.getOArmor(n) + " Structure: " + this.getInternalString(n) + "/" + this.getOInternal(n);
    }

    public String statusToString(String string) {
        int n = -1;
        n = this.getLocationFromAbbr(string);
        if (n == -1) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        return this.statusToString(n);
    }

    public void setDeployRound(int n) {
        this.deployRound = n;
    }

    public int getDeployRound() {
        return this.deployRound;
    }

    public void setDeployed(boolean bl) {
        this.deployed = bl;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public boolean shouldDeploy(int n) {
        return !this.deployed && this.getDeployRound() <= n && !this.isOffBoard();
    }

    public void setUnitNumber(char c) {
        this.unitNumber = c;
    }

    public char getUnitNumber() {
        return this.unitNumber;
    }

    public boolean canFlee() {
        Coords coords = this.getPosition();
        return coords != null && this.getWalkMP() > 0 && !this.isProne() && !this.isStuck() && !this.isShutDown() && !this.getCrew().isUnconscious() && (coords.x == 0 || coords.x == this.game.getBoard().getWidth() - 1 || coords.y == 0 || coords.y == this.game.getBoard().getHeight() - 1);
    }

    public void setSeenByEnemy(boolean bl) {
        this.seenByEnemy = bl;
    }

    public boolean isSeenByEnemy() {
        return this.seenByEnemy;
    }

    public void setVisibleToEnemy(boolean bl) {
        this.visibleToEnemy = bl;
    }

    public boolean isVisibleToEnemy() {
        return this.visibleToEnemy;
    }

    protected int applyGravityEffectsOnMP(int n) {
        int n2 = n;
        if (this.game != null) {
            float f = (float)n / this.game.getPlanetaryConditions().getGravity();
            f = (double)Math.abs((float)Math.round(f) - f) == 0.5 ? (float)Math.floor(f) : (float)Math.round(f);
            n2 = (int)f;
        }
        return n2;
    }

    public boolean canCharge() {
        return !this.isImmobile() && this.getWalkMP() > 0 && !this.isStuck() && !this.isProne();
    }

    public boolean canDFA() {
        return !this.isImmobile() && this.getJumpMP() > 0 && !this.isStuck() && !this.isProne();
    }

    public boolean canRam() {
        return false;
    }

    boolean isUsingManAce() {
        return this.getCrew().getOptions().booleanOption("maneuvering_ace");
    }

    public Enumeration<Entity> getKills() {
        final int n = this.id;
        return this.game.getSelectedOutOfGameEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                return n == entity.killerId;
            }
        });
    }

    public int getKillNumber() {
        final int n = this.id;
        return this.game.getSelectedOutOfGameEntityCount(new EntitySelector(){

            public boolean accept(Entity entity) {
                return n == entity.killerId;
            }
        });
    }

    public void addKill(Entity entity) {
        entity.killerId = this.id;
    }

    public boolean getGaveKillCredit() {
        return this.killerId != -1;
    }

    public boolean isEligibleFor(IGame.Phase phase) {
        if (phase == IGame.Phase.PHASE_DEPLOYMENT == this.isDeployed()) {
            return false;
        }
        if (this.isCarcass()) {
            return false;
        }
        switch (phase) {
            case PHASE_MOVEMENT: {
                return this.isEligibleForMovement();
            }
            case PHASE_FIRING: {
                return this.isEligibleForFiring();
            }
            case PHASE_PHYSICAL: {
                return this.isEligibleForPhysical();
            }
            case PHASE_TARGETING: {
                return this.isEligibleForTargetingPhase();
            }
            case PHASE_OFFBOARD: {
                return this.isEligibleForOffboard();
            }
        }
        return true;
    }

    public boolean canAssist(IGame.Phase phase) {
        if (phase != IGame.Phase.PHASE_PHYSICAL && phase != IGame.Phase.PHASE_FIRING && phase != IGame.Phase.PHASE_OFFBOARD) {
            return false;
        }
        if (this.isUnjammingRAC() || this.isCharging() || this.isMakingDfa() || this.isRamming() || this.isFindingClub() || this.isOffBoard()) {
            return false;
        }
        if (!this.isActive()) {
            return false;
        }
        return this.isUsingSpotlight();
    }

    public boolean isEligibleForFiring() {
        if (this.isUnjammingRAC() || this.isCharging() || this.isMakingDfa() || this.isRamming()) {
            return false;
        }
        if (this.isOffBoard() || this.isAssaultDropInProgress()) {
            return false;
        }
        if (!this.game.getOptions().booleanOption("skip_ineligable_firing")) {
            return true;
        }
        return this.isActive();
    }

    public boolean isEligibleForMovement() {
        if (this.isOffBoard() || this.isAssaultDropInProgress()) {
            return false;
        }
        if (!this.game.getOptions().booleanOption("skip_ineligable_movement")) {
            return true;
        }
        return this.isActive() && !this.isImmobile();
    }

    public boolean isEligibleForOffboard() {
        if (this.isUnjammingRAC() || this.isCharging() || this.isMakingDfa()) {
            return false;
        }
        if (this.isOffBoard() || this.isAssaultDropInProgress()) {
            return false;
        }
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (!weaponType.hasFlag(0x4000000L) || !mounted.isReady()) continue;
            return true;
        }
        return false;
    }

    public boolean isAttackingThisTurn() {
        Vector<EntityAction> vector = this.game.getActionsVector();
        for (EntityAction entityAction : vector) {
            if (entityAction.getEntityId() != this.getId() || !(entityAction instanceof AbstractAttackAction)) continue;
            return true;
        }
        return false;
    }

    public boolean isEligibleForPhysical() {
        Object object;
        boolean bl = false;
        boolean bl2 = this.game.getOptions().booleanOption("friendly_fire");
        if (!(this instanceof Mech || this instanceof Protomech || this instanceof Infantry)) {
            return false;
        }
        if (this.isUnjammingRAC() || this.isCharging() || this.isMakingDfa() || this.isFindingClub() || this.isOffBoard() || this.isAssaultDropInProgress()) {
            return false;
        }
        if (this.game.getOptions().booleanOption("no_clan_physical") && this.isClan() && !this.hasINarcPodsAttached() && this.getSwarmAttackerId() == -1) {
            return false;
        }
        if (this.hasVibroblades()) {
            return true;
        }
        if (!this.game.getOptions().booleanOption("skip_ineligable_physical")) {
            return true;
        }
        if (!this.isActive()) {
            return false;
        }
        if (this.getPosition() == null) {
            return false;
        }
        if (this.hasINarcPodsAttached() && this instanceof Mech) {
            return true;
        }
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (!bl && enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!this.isEnemyOf((Entity)object) && (!bl2 || this.getId() == ((Entity)object).getId()) || ((Entity)object).getPosition() == null || this.getPosition().distance(((Entity)object).getPosition()) > 1) continue;
            bl |= Compute.canPhysicalTarget(this.game, this.getId(), (Targetable)object);
            bl |= this instanceof Mech && !this.isProne() && this.getCrew().getOptions().booleanOption("dodge_maneuver") && Compute.canPhysicalTarget(this.game, ((Entity)object).getId(), this);
        }
        object = this.game.getBoard().getBuildings();
        while (!bl && object.hasMoreElements()) {
            Building building = (Building)object.nextElement();
            Enumeration<Coords> enumeration2 = building.getCoords();
            while (!bl && enumeration2.hasMoreElements()) {
                Coords coords = enumeration2.nextElement();
                if (this.getPosition().distance(coords) > 1) continue;
                BuildingTarget buildingTarget = new BuildingTarget(coords, this.game.getBoard(), false);
                bl |= Compute.canPhysicalTarget(this.game, this.getId(), buildingTarget);
            }
        }
        return bl;
    }

    public boolean isEligibleForTargetingPhase() {
        if (this.isAssaultDropInProgress()) {
            return false;
        }
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType == null || !weaponType.hasFlag(32768L)) continue;
            return true;
        }
        return false;
    }

    public int getTroopCarryingSpace() {
        int n = 0;
        for (Transporter transporter : this.transports) {
            if (!(transporter instanceof TroopSpace)) continue;
            n = (int)((double)n + ((TroopSpace)transporter).totalSpace);
        }
        return n;
    }

    public boolean hasBattleArmorHandles() {
        for (Transporter transporter : this.transports) {
            if (!(transporter instanceof BattleArmorHandles)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOffBoard() {
        return this.offBoardDistance > 0;
    }

    public void setOffBoard(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("negative number given for distance offboard");
        }
        if (n2 < -1 || n2 > 3) {
            throw new IllegalArgumentException("bad direction");
        }
        if (0 == n && -1 != n2) {
            throw new IllegalArgumentException("onboard unit was given an offboard direction");
        }
        if (0 != n && -1 == n2) {
            throw new IllegalArgumentException("offboard unit was not given an offboard direction");
        }
        switch (n2) {
            case 0: {
                this.setFacing(3);
                break;
            }
            case 1: {
                this.setFacing(0);
                break;
            }
            case 3: {
                this.setFacing(2);
                break;
            }
            case 2: {
                this.setFacing(4);
            }
        }
        this.offBoardDistance = n;
        this.offBoardDirection = n2;
    }

    public int getOffBoardDistance() {
        return this.offBoardDistance;
    }

    public int getOffBoardDirection() {
        return this.offBoardDirection;
    }

    public void deployOffBoard() {
        if (null == this.game) {
            throw new IllegalStateException("game not set; possible serialization error");
        }
        switch (this.offBoardDirection) {
            case -1: {
                break;
            }
            case 0: {
                this.setPosition(new Coords(this.game.getBoard().getWidth() / 2 + this.game.getBoard().getWidth() % 2, -this.getOffBoardDistance()));
                this.setFacing(3);
                this.setDeployed(true);
                break;
            }
            case 1: {
                this.setPosition(new Coords(this.game.getBoard().getWidth() / 2 + this.game.getBoard().getWidth() % 2, this.game.getBoard().getHeight() + this.getOffBoardDistance()));
                this.setFacing(0);
                this.setDeployed(true);
                break;
            }
            case 2: {
                this.setPosition(new Coords(this.game.getBoard().getWidth() + this.getOffBoardDistance(), this.game.getBoard().getHeight() / 2 + this.game.getBoard().getHeight() % 2));
                this.setFacing(5);
                this.setDeployed(true);
                break;
            }
            case 3: {
                this.setPosition(new Coords(-this.getOffBoardDistance(), this.game.getBoard().getHeight() / 2 + this.game.getBoard().getHeight() % 2));
                this.setFacing(1);
                this.setDeployed(true);
            }
        }
    }

    public Vector<Integer> getPickedUpMechWarriors() {
        return this.pickedUpMechWarriors;
    }

    public boolean isCaptured() {
        return this.captured && !this.isDestroyed();
    }

    public void setCaptured(boolean bl) {
        this.captured = bl;
    }

    public void setSpotlight(boolean bl) {
        this.hasSpotlight = bl;
    }

    public boolean hasSpotlight() {
        for (Mounted mounted : this.getMisc()) {
            if (!mounted.getType().hasFlag(0x1000000L) || mounted.isInoperable()) continue;
            return true;
        }
        return this.hasSpotlight;
    }

    public void setSpotlightState(boolean bl) {
        if (this.hasSpotlight) {
            this.spotlightIsActive = bl;
            if (bl) {
                this.illuminated = true;
            }
        }
    }

    public boolean isIlluminated() {
        return this.illuminated;
    }

    public void setIlluminated(boolean bl) {
        this.illuminated = bl;
    }

    public boolean isUsingSpotlight() {
        return this.hasSpotlight && this.spotlightIsActive;
    }

    public void setUsedSearchlight(boolean bl) {
        this.usedSearchlight = bl;
    }

    public boolean usedSearchlight() {
        return this.usedSearchlight;
    }

    public void illuminateTarget(HexTarget hexTarget) {
        if (this.hasSpotlight && this.spotlightIsActive && hexTarget != null) {
            this.illuminated = true;
            ArrayList<Coords> arrayList = Coords.intervening(this.getPosition(), hexTarget.getPosition());
            for (Coords coords : arrayList) {
                Enumeration<Entity> enumeration = this.game.getEntities(coords);
                while (enumeration.hasMoreElements()) {
                    Entity entity = enumeration.nextElement();
                    entity.setIlluminated(true);
                }
            }
        }
    }

    public boolean isStuck() {
        return this.stuckInSwamp;
    }

    public void setStuck(boolean bl) {
        this.stuckInSwamp = bl;
    }

    public boolean canUnstickByJumping() {
        return this.canUnstickByJumping;
    }

    public void setCanUnstickByJumping(boolean bl) {
        this.canUnstickByJumping = bl;
    }

    public String destroy(String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 512;
        if (!bl2) {
            this.setSalvage(bl2);
            n = 1024;
        }
        if (this.isDoomed() || this.isDestroyed()) {
            return stringBuffer.toString();
        }
        this.setDoomed(true);
        Enumeration<Integer> enumeration = this.getPickedUpMechWarriors().elements();
        while (enumeration.hasMoreElements()) {
            Integer n2 = enumeration.nextElement();
            Entity entity = this.game.getEntity(n2);
            entity.setDestroyed(true);
            this.game.removeEntity(entity.getId(), n);
            stringBuffer.append("\n*** ").append(entity.getDisplayName() + " died in the wreckage. ***\n");
        }
        return stringBuffer.toString();
    }

    public void addTargetedBySwarm(int n, int n2) {
        this.hitBySwarmsEntity.addElement(new Integer(n));
        this.hitBySwarmsWeapon.addElement(new Integer(n2));
    }

    public boolean getTargetedBySwarm(int n, int n2) {
        for (int i = 0; i < this.hitBySwarmsEntity.size(); ++i) {
            Integer n3 = this.hitBySwarmsEntity.elementAt(i);
            Integer n4 = this.hitBySwarmsWeapon.elementAt(i);
            if (n != n3 || n2 != n4) continue;
            return true;
        }
        return false;
    }

    public int getShortRangeModifier() {
        if (this.getTargSysType() == 3) {
            return -1;
        }
        if (this.getTargSysType() == 2) {
            return 1;
        }
        return 0;
    }

    public int getMediumRangeModifier() {
        return 2;
    }

    public int getLongRangeModifier() {
        if (this.getTargSysType() == 3) {
            return 5;
        }
        if (this.getTargSysType() == 2) {
            return 3;
        }
        return 4;
    }

    public int getExtremeRangeModifier() {
        return 6;
    }

    public int getTargSysType() {
        return this.targSys;
    }

    public void setTargSysType(int n) {
        this.targSys = n;
    }

    public void setArmorType(int n) {
        this.armorType = n;
    }

    public void setStructureType(int n) {
        this.structureType = n;
    }

    public void setArmorType(String string) {
        this.setArmorType(EquipmentType.getArmorType(string));
    }

    public void setStructureType(String string) {
        this.setStructureType(EquipmentType.getStructureType(string));
    }

    public int getArmorType() {
        return this.armorType;
    }

    public void setArmorTechLevel(int n) {
        this.armorTechLevel = n;
    }

    public int getArmorTechLevel() {
        return this.armorTechLevel;
    }

    public int getStructureType() {
        return this.structureType;
    }

    public void setWeaponDestroyed(Mounted mounted) {
        if (this.weaponList.contains(mounted)) {
            mounted.setDestroyed(true);
        }
    }

    public void setTaggedBy(int n) {
        this.taggedBy = n;
    }

    public int getTaggedBy() {
        return this.taggedBy;
    }

    public abstract double getCost();

    public int getWeaponsAndEquipmentCost() {
        int n = 0;
        for (Mounted mounted : this.getEquipment()) {
            if (mounted.isWeaponGroup()) continue;
            int n2 = (int)mounted.getType().getCost(this, mounted.isArmored());
            if (n2 == Integer.MIN_VALUE) {
                n2 = mounted.getType().resolveVariableCost(this, mounted.isArmored());
            }
            n += n2;
        }
        return n;
    }

    public boolean removePartialCoverHits(int n, int n2, int n3) {
        if (n2 > 0) {
            switch (n2) {
                case 1: {
                    if (n != 7) break;
                    return true;
                }
                case 2: {
                    if (n != 6) break;
                    return true;
                }
                case 4: {
                    if (n != 7 && n != 5 && n != 3) break;
                    return true;
                }
                case 8: {
                    if (n != 6 && n != 4 && n != 2) break;
                    return true;
                }
                case 3: {
                    if (n != 7 && n != 6) break;
                    return true;
                }
                case 12: {
                    return n != 7 && n != 6;
                }
                case 15: {
                    return true;
                }
                case 7: {
                    return n != 4 && n != 6;
                }
                case 11: {
                    return n != 7 && n != 5;
                }
            }
        }
        return false;
    }

    public boolean isOnSameSheet(Coords coords) {
        if (this.game.getOptions().booleanOption("a4homing_target_area")) {
            return coords.distance(this.getPosition()) <= 8;
        }
        return coords.x / 16 == this.getPosition().x / 16 && coords.y / 17 == this.getPosition().y / 17;
    }

    public abstract boolean doomedInVacuum();

    public abstract boolean doomedOnGround();

    public abstract boolean doomedInAtmosphere();

    public abstract boolean doomedInSpace();

    public double getArmorWeight() {
        double d = 16.0 * EquipmentType.getArmorPointMultiplier(this.armorType, this.armorTechLevel);
        if (this.armorType == 4) {
            d = 8.0;
        }
        double d2 = this.getTotalOArmor();
        double d3 = d2 / d;
        d3 = Math.ceil(d3 * 2.0) / 2.0;
        return d3;
    }

    public boolean hasTAG() {
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType == null || !weaponType.hasFlag(0x4000000L)) continue;
            return true;
        }
        return false;
    }

    public boolean isCanon() {
        return this.canon;
    }

    public void setCanon(boolean bl) {
        this.canon = bl;
    }

    public boolean climbMode() {
        return this.climbMode;
    }

    public void setClimbMode(boolean bl) {
        this.climbMode = bl;
    }

    public boolean usedTag() {
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (!mounted.isUsedThisRound() || !weaponType.hasFlag(0x4000000L)) continue;
            return true;
        }
        return false;
    }

    public boolean hasEiCockpit() {
        return this.game != null && this.game.getOptions().booleanOption("all_have_ei_cockpit");
    }

    public boolean hasActiveEiCockpit() {
        return this.hasEiCockpit() && this.getCrew().getOptions().booleanOption("ei_implant");
    }

    public boolean isLayingMines() {
        return this.layingMines;
    }

    public void setLayingMines(boolean bl) {
        this.layingMines = bl;
    }

    public boolean canLayMine() {
        Iterator<Mounted> iterator = this.miscList.iterator();
        while (iterator.hasNext()) {
            Mounted mounted;
            Mounted mounted2 = mounted = iterator.next();
            EquipmentType equipmentType = mounted2.getType();
            if (mounted2.isMissing() || !equipmentType.hasFlag(131072L) || this.isLayingMines()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int sideTable(Coords coords) {
        return this.sideTable(coords, false);
    }

    public int sideTable(Coords coords, boolean bl) {
        return this.sideTable(coords, bl, this.facing);
    }

    public int sideTable(Coords coords, boolean bl, int n) {
        boolean bl2;
        Object object;
        Coords coords2 = this.position;
        if (bl) {
            coords2 = this.getPriorPosition();
        }
        if (coords.equals(coords2)) {
            return 0;
        }
        int n2 = (coords2.degree(coords) + (6 - n) * 60) % 360;
        int n3 = 2;
        if (n2 % 30 == 0) {
            IHex iHex = this.game.getBoard().getHex(coords);
            object = this.game.getBoard().getHex(this.getPosition());
            if (iHex != null && object != null) {
                LosEffects.AttackInfo attackInfo = LosEffects.buildAttackInfo(coords, this.getPosition(), 1, this.getElevation(), iHex.floor(), object.floor());
                ArrayList<Coords> arrayList = Coords.intervening(attackInfo.attackPos, attackInfo.targetPos, true);
                n3 = LosEffects.dividedLeftBetter(arrayList, this.game, attackInfo, Compute.isInBuilding(this.game, this), new LosEffects());
            }
        }
        boolean bl3 = bl2 = this instanceof Tank || this.game.getOptions().booleanOption("tacops_advanced_mech_hit_locations") && this instanceof QuadMech;
        if (bl2) {
            if (n3 == 1 && n2 == 150) {
                return 1;
            }
            if (n3 == 1 && n2 == 30) {
                return 3;
            }
            if (n3 == 0 && n2 == 330) {
                return 2;
            }
            if (n3 == 0 && n2 == 210) {
                return 1;
            }
            if (n2 > 30 && n2 <= 150) {
                return 3;
            }
            if (n2 > 150 && n2 < 210) {
                return 1;
            }
            if (n2 >= 210 && n2 < 330) {
                return 2;
            }
            return 0;
        }
        if (this instanceof Aero) {
            object = (Aero)this;
            if (((Aero)object).isSpheroid() && this.game.getBoard().inAtmosphere()) {
                n2 = coords2.degree(coords);
                if (n2 >= 0 && n2 < 180) {
                    return 3;
                }
                return 2;
            }
            if (n3 == 1 && n2 == 150) {
                return 1;
            }
            if (n3 == 1 && n2 == 30) {
                if (((Aero)object).isRolled()) {
                    return 2;
                }
                return 3;
            }
            if (n3 == 0 && n2 == 330) {
                if (((Aero)object).isRolled()) {
                    return 3;
                }
                return 2;
            }
            if (n3 == 0 && n2 == 210) {
                return 1;
            }
            if (n2 > 30 && n2 <= 150) {
                if (((Aero)object).isRolled()) {
                    return 2;
                }
                return 3;
            }
            if (n2 > 150 && n2 < 210) {
                return 1;
            }
            if (n2 >= 210 && n2 < 330) {
                if (((Aero)object).isRolled()) {
                    return 3;
                }
                return 2;
            }
            return 0;
        }
        if (n2 == 90 && n3 == 1) {
            return 3;
        }
        if (n2 == 150 && n3 == 1 || n3 == 0 && n2 == 210) {
            return 1;
        }
        if (n3 == 0 && n2 == 270) {
            return 2;
        }
        if (n2 > 90 && n2 <= 150) {
            return 3;
        }
        if (n2 > 150 && n2 < 210) {
            return 1;
        }
        if (n2 >= 210 && n2 < 270) {
            return 2;
        }
        return 0;
    }

    public boolean canGoHullDown() {
        return false;
    }

    public boolean canAssaultDrop() {
        return false;
    }

    public void setAssaultDropInProgress(boolean bl) {
        this.assaultDropInProgress = bl ? 1 : 0;
    }

    public void setLandedAssaultDrop() {
        this.assaultDropInProgress = 2;
        this.moved = 3;
    }

    public boolean isAssaultDropInProgress() {
        return this.assaultDropInProgress != 0;
    }

    public void addPilotingModifierForTerrain(PilotingRollData pilotingRollData, Coords coords) {
        if (coords == null || pilotingRollData == null) {
            return;
        }
        if (this.isOffBoard() || !this.isDeployed()) {
            return;
        }
        IHex iHex = this.game.getBoard().getHex(coords);
        int n = iHex.terrainPilotingModifier(this.getMovementMode());
        if (n != 0) {
            pilotingRollData.addModifier(n, "difficult terrain");
        }
    }

    public void addPilotingModifierForTerrain(PilotingRollData pilotingRollData, MoveStep moveStep) {
        if (moveStep.getElevation() > 0) {
            return;
        }
        this.addPilotingModifierForTerrain(pilotingRollData, moveStep.getPosition());
    }

    public void addPilotingModifierForTerrain(PilotingRollData pilotingRollData) {
        if (this.getElevation() > 0) {
            return;
        }
        this.addPilotingModifierForTerrain(pilotingRollData, this.getPosition());
    }

    public boolean fixElevation() {
        if (!this.isDeployed() || this.isOffBoard() || !this.game.getBoard().contains(this.getPosition())) {
            return false;
        }
        if (!this.isElevationValid(this.getElevation(), this.game.getBoard().getHex(this.getPosition()))) {
            System.err.println(this.getDisplayName() + " in hex " + HexTarget.coordsToId(this.getPosition()) + " is at invalid elevation: " + this.getElevation());
            this.setElevation(this.elevationOccupied(this.game.getBoard().getHex(this.getPosition())));
            System.err.println("   moved to elevation " + this.getElevation());
            return true;
        }
        return false;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public boolean itemOppositeTech(String string) {
        if (this.isClan()) {
            return string.toLowerCase().indexOf("(IS)") != -1 || string.toLowerCase().indexOf("Inner Sphere") != -1;
        }
        return string.toLowerCase().indexOf("(C)") != -1 || string.toLowerCase().indexOf("Clan") != -1;
    }

    public int getRetreatedDirection() {
        return this.retreatedDirection;
    }

    public void setRetreatedDirection(int n) {
        this.retreatedDirection = n;
    }

    public void setLastTarget(int n) {
        this.lastTarget = n;
    }

    public int getLastTarget() {
        return this.lastTarget;
    }

    public boolean isSufferingEMI() {
        return this._isEMId;
    }

    public void setEMI(boolean bl) {
        this._isEMId = bl;
    }

    public abstract boolean isNuclearHardened();

    public void setHidden(boolean bl) {
        this.isHidden = bl;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isCarcass() {
        return this.carcass;
    }

    public void setCarcass(boolean bl) {
        this.carcass = bl;
    }

    public void destroyLocation(int n) {
        if (this.getInternal(n) < 0) {
            return;
        }
        this.setArmor(-2, n, false);
        this.setInternal(-2, n);
        if (this.hasRearArmor(n)) {
            this.setArmor(-2, n, true);
        }
        for (Mounted serializable : this.getEquipment()) {
            if ((serializable.getLocation() != n || !serializable.getType().isHittable()) && (!serializable.isSplit() || serializable.getSecondLocation() != n)) continue;
            serializable.setMissing(true);
        }
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null) continue;
            if (criticalSlot.getType() == 0 && criticalSlot.getIndex() == 3 && !criticalSlot.isDamaged()) {
                ++this.engineHitsThisRound;
            }
            criticalSlot.setMissing(true);
        }
        if (this.getDependentLocation(n) != -1 && this.getInternal(this.getDependentLocation(n)) >= 0) {
            this.destroyLocation(this.getDependentLocation(n));
        }
        Iterator<Serializable> iterator = this.pendingINarcPods.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getLocation() != n) continue;
            iterator.remove();
        }
        iterator = this.iNarcPods.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getLocation() != n) continue;
            iterator.remove();
        }
        iterator = this.pendingNarcPods.iterator();
        while (iterator.hasNext()) {
            if (((NarcPod)iterator.next()).getLocation() != n) continue;
            iterator.remove();
        }
        iterator = this.narcPods.iterator();
        while (iterator.hasNext()) {
            if (((NarcPod)iterator.next()).getLocation() != n) continue;
            iterator.remove();
        }
    }

    public PilotingRollData checkSideSlip(int n, IHex iHex, int n2, MoveStep moveStep, int n3, int n4, Coords coords, Coords coords2, int n5) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(n2);
        if (!(n == 3 || iHex == null || n5 <= 1 || n2 != 2 && n2 != 5 || n3 == n4 || coords.equals(coords2) || this instanceof Infantry)) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "flanking and turning"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: not apparently sideslipping");
        }
        return pilotingRollData;
    }

    public boolean isFlying() {
        if (this.getMovementMode() == 6) {
            if (this.game.getBoard().getHex(this.getPosition()).terrainLevel(24) >= this.getElevation() || this.game.getBoard().getHex(this.getPosition()).terrainLevel(28) >= this.getElevation()) {
                return false;
            }
            return this.getElevation() > 0;
        }
        return false;
    }

    public void setSpotTargetId(int n) {
        this.spotTargetId = n;
    }

    public int getSpotTargetId() {
        return this.spotTargetId;
    }

    public void setCommander(boolean bl) {
        this.isCommander = bl;
    }

    public boolean isCommander() {
        return this.isCommander;
    }

    public boolean hasLinkedMGA(Mounted mounted) {
        for (Mounted mounted2 : this.getWeaponList()) {
            if (mounted2.getLocation() != mounted.getLocation() || !mounted2.getType().hasFlag(0x100000000L) || mounted2.isDestroyed() || mounted2.isBreached() || !mounted2.getType().hasModes() || !mounted2.curMode().equals("Linked") || ((WeaponType)mounted2.getType()).getDamage() != ((WeaponType)mounted.getType()).getDamage()) continue;
            return true;
        }
        return false;
    }

    public void setReckless(boolean bl) {
        this.reckless = bl;
    }

    public boolean isReckless() {
        return this.reckless;
    }

    public boolean isFighter() {
        return this instanceof Aero && !(this instanceof SmallCraft) && !(this instanceof Jumpship) && !(this instanceof FighterSquadron);
    }

    public boolean isCapitalFighter() {
        if (null == this.game) {
            return false;
        }
        return this.game.getOptions().booleanOption("stratops_capital_fighter") && this.isFighter();
    }

    public boolean isCapitalScale() {
        return this instanceof Jumpship || this instanceof FighterSquadron || this.isCapitalFighter();
    }

    public boolean usesWeaponBays() {
        return this instanceof Jumpship || this instanceof Dropship;
    }

    public Mounted whichBay(int n) {
        for (Mounted mounted : this.getWeaponBayList()) {
            for (int n2 : mounted.getBayWeapons()) {
                if (n2 != n) continue;
                return mounted;
            }
        }
        return null;
    }

    public Mounted getFirstBay(WeaponType weaponType, int n, boolean bl) {
        int n2 = weaponType.getRoundShortAV();
        if (weaponType.isCapital()) {
            n2 *= 10;
        }
        for (Mounted mounted : this.getWeaponBayList()) {
            BayWeapon bayWeapon = (BayWeapon)mounted.getType();
            int n3 = bayWeapon.getRoundShortAV() + n2;
            if (bayWeapon.getAtClass() != weaponType.getAtClass() || mounted.getLocation() != n || mounted.isRearMounted() != bl || n3 > 700) continue;
            return mounted;
        }
        return null;
    }

    public int getHeatInArc(int n, boolean bl) {
        int n2 = 0;
        for (Mounted mounted : this.getTotalWeaponList()) {
            if (mounted.isDestroyed() || mounted.isJammed() || mounted.getLocation() != n || mounted.isRearMounted() != bl) continue;
            n2 += mounted.getCurrentHeat();
        }
        return n2;
    }

    public int[] getVectors() {
        return this.vectors;
    }

    public void setVectors(int[] nArray) {
        if (nArray == null || nArray.length != 6) {
            return;
        }
        this.vectors = nArray;
    }

    public int getVector(int n) {
        if (n < 6) {
            return this.vectors[n];
        }
        return 0;
    }

    public int getVelocity() {
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            n += this.getVector(i);
        }
        return n;
    }

    public int chooseSide(Coords coords, boolean bl) {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < 6; ++i) {
            int n4;
            n = this.getVector(i);
            if (n == 0) continue;
            if (n > n2) {
                n2 = n;
                n3 = this.sideTable(coords, bl, i);
            }
            if (n != n2 || (n4 = this.sideTable(coords, bl, i)) != 2 && n4 != 3) continue;
            n4 = n3;
        }
        return n3;
    }

    public Vector<Integer> getHeading() {
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        int n2 = this.getFacing();
        for (int i = 0; i < 6; ++i) {
            int n3 = this.getVector(i);
            if (n3 < n || n3 <= 0) continue;
            if (n3 == n) {
                vector.addElement(n2);
            }
            n = this.getVector(i);
            n2 = i;
        }
        vector.addElement(n2);
        return vector;
    }

    public void setPassedThrough(Vector<Coords> vector) {
        this.passedThrough = vector;
    }

    public Vector<Coords> getPassedThrough() {
        return this.passedThrough;
    }

    public void addPassedThrough(Coords coords) {
        this.passedThrough.add(coords);
    }

    public void setRamming(boolean bl) {
        this.ramming = bl;
    }

    public boolean isRamming() {
        return this.ramming;
    }

    public void resetFiringArcs() {
        this.frontArcFired = new boolean[this.locations()];
        this.rearArcFired = new boolean[this.locations()];
        for (int i = 0; i < this.locations(); ++i) {
            this.frontArcFired[i] = false;
            this.rearArcFired[i] = false;
        }
    }

    public boolean hasArcFired(int n, boolean bl) {
        if (null == this.frontArcFired || null == this.rearArcFired) {
            this.resetFiringArcs();
        }
        if (n > this.locations() || n < 0) {
            return false;
        }
        if (bl) {
            return this.rearArcFired[n];
        }
        return this.frontArcFired[n];
    }

    public void setArcFired(int n, boolean bl) {
        if (null == this.frontArcFired || null == this.rearArcFired) {
            this.resetFiringArcs();
        }
        if (n > this.locations() || n < 0) {
            return;
        }
        if (bl) {
            this.rearArcFired[n] = true;
        } else {
            this.frontArcFired[n] = true;
        }
    }

    public void setRapidFire() {
        for (Mounted mounted : this.getTotalWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.getAmmoType() == 23) {
                mounted.setMode("6-shot");
                continue;
            }
            if (weaponType.getAmmoType() != 20) continue;
            mounted.setMode("Ultra");
        }
    }

    public void extendBlade(int n) {
        for (Mounted mounted : this.getEquipment()) {
            if (mounted.getLocation() != n || mounted.isDestroyed() || mounted.isBreached() || !(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(0x2000000L) || !mounted.getType().hasSubType(0x800000L)) continue;
            mounted.setMode("extended");
            return;
        }
    }

    public void destroyRetractableBlade(int n) {
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            Mounted mounted;
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.getType() != 1 || (mounted = this.getEquipment(criticalSlot.getIndex())).getLocation() != n || mounted.isDestroyed() || mounted.isBreached() || !(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(0x2000000L) || !mounted.getType().hasSubType(0x800000L)) continue;
            criticalSlot.setDestroyed(true);
            mounted.setDestroyed(true);
            return;
        }
    }

    public TeleMissileTracker getTMTracker() {
        return this.tmTracker;
    }

    public void setGrappled(int n, boolean bl) {
    }

    public boolean isGrappleAttacker() {
        return false;
    }

    public int getGrappled() {
        return -1;
    }

    public void setGameOptions() {
        String[] stringArray;
        if (this.game == null) {
            return;
        }
        if (this instanceof SmallCraft && !this.hasActiveECM() && this.isMilitary()) {
            try {
                this.addEquipment(EquipmentType.get("Single-Hex ECM"), 0, false);
            }
            catch (LocationFullException locationFullException) {
                // empty catch block
            }
        }
        for (Mounted mounted : this.getWeaponList()) {
            if (mounted.getType() instanceof GaussWeapon && this.game.getOptions().booleanOption("tacops_gauss_weapons")) {
                String[] stringArray2 = new String[]{"Powered Up", "Powered Down"};
                ((WeaponType)mounted.getType()).setModes(stringArray2);
                ((WeaponType)mounted.getType()).setInstantModeSwitch(false);
                continue;
            }
            if (mounted.getType() instanceof ACWeapon && this.game.getOptions().booleanOption("tacops_rapid_ac")) {
                String[] stringArray3 = new String[]{"", "Rapid"};
                ((WeaponType)mounted.getType()).setModes(stringArray3);
                continue;
            }
            if (mounted.getType() instanceof ISBombastLaser) {
                stringArray = new ArrayList();
                String[] stringArray4 = new String[]{};
                for (int i = 12; i >= 7; --i) {
                    stringArray.add("Damage " + i);
                }
                ((WeaponType)mounted.getType()).setModes(stringArray.toArray(stringArray4));
                continue;
            }
            if (!((WeaponType)mounted.getType()).isCapital() || ((WeaponType)mounted.getType()).getAtClass() == 19 || ((WeaponType)mounted.getType()).getAtClass() == 20) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            stringArray = new String[]{};
            arrayList.add("");
            if (this.game.getOptions().booleanOption("stratops_bracket_fire")) {
                arrayList.add("Bracket 80%");
                arrayList.add("Bracket 60%");
                arrayList.add("Bracket 40%");
            }
            if (mounted.getType() instanceof CapitalLaserBayWeapon && this.game.getOptions().booleanOption("stratops_aaa_laser")) {
                arrayList.add("AAA");
                ((WeaponType)mounted.getType()).addEndTurnMode("AAA");
            }
            if (arrayList.size() <= 1) continue;
            ((WeaponType)mounted.getType()).setModes(arrayList.toArray(stringArray));
        }
        for (Mounted mounted : this.getMisc()) {
            ArrayList<String> arrayList;
            if (mounted.getType().hasFlag(0x100000000000L) && this instanceof Aero && this.game.getOptions().booleanOption("stratops_ecm")) {
                arrayList = new ArrayList();
                stringArray = new String[]{};
                arrayList.add("Short");
                arrayList.add("Medium");
                ((MiscType)mounted.getType()).setModes(arrayList.toArray(stringArray));
                ((MiscType)mounted.getType()).setInstantModeSwitch(false);
            }
            if (!mounted.getType().hasFlag(0x80000000000L)) continue;
            arrayList = new ArrayList<String>();
            arrayList.add("ECM");
            stringArray = new String[]{};
            if (this.game.getOptions().booleanOption("tacops_eccm")) {
                arrayList.add("ECCM");
                if (mounted.getType().hasFlag(2048L)) {
                    arrayList.add("ECM & ECCM");
                }
            } else if (this.game.getOptions().booleanOption("stratops_ecm") && this instanceof Aero) {
                arrayList.add("ECCM");
                if (mounted.getType().hasFlag(2048L)) {
                    arrayList.add("ECM & ECCM");
                }
            }
            if (this.game.getOptions().booleanOption("tacops_ghost_target")) {
                if (mounted.getType().hasFlag(2048L)) {
                    arrayList.add("ECM & Ghost Targets");
                    arrayList.add("ECCM & Ghost Targets");
                } else {
                    arrayList.add("Ghost Targets");
                }
            }
            ((MiscType)mounted.getType()).setModes(arrayList.toArray(stringArray));
        }
    }

    public void setGrappleSide(int n) {
    }

    public int getGrappleSide() {
        return -1;
    }

    public boolean hasFunctionalArmAES(int n) {
        return false;
    }

    public boolean hasFunctionalLegAES() {
        return false;
    }

    public boolean isEvading() {
        return this.evading;
    }

    public void setEvading(boolean bl) {
        this.evading = bl;
    }

    public int getEvasionBonus() {
        if (this.isProne()) {
            return 0;
        }
        if (this instanceof SmallCraft) {
            return 2;
        }
        if (this instanceof Jumpship) {
            return 1;
        }
        if (this instanceof Aero) {
            return 3;
        }
        if (this.game.getOptions().booleanOption("tacops_skilled_evasion")) {
            int n = this.crew.getPiloting();
            if (n < 2) {
                return 3;
            }
            if (n < 4) {
                return 2;
            }
            if (n < 6) {
                return 1;
            }
        } else {
            return 1;
        }
        return 0;
    }

    public void setCarefulStand(boolean bl) {
        this.isCarefulStanding = bl;
    }

    public boolean isCarefulStand() {
        return false;
    }

    public Vector<Sensor> getSensors() {
        return this.sensors;
    }

    public Sensor getActiveSensor() {
        return this.activeSensor;
    }

    public Sensor getNextSensor() {
        return this.nextSensor;
    }

    public void setNextSensor(Sensor sensor) {
        this.nextSensor = sensor;
    }

    public int getSensorCheck() {
        return this.sensorCheck;
    }

    public boolean hasModularArmor() {
        return this.hasModularArmor(0);
    }

    public boolean hasModularArmor(int n) {
        return false;
    }

    public int getDamageReductionFromModularArmor(int n, int n2, Vector<Report> vector) {
        if (!this.hasModularArmor(n)) {
            return n2;
        }
        for (Mounted mounted : this.getEquipment()) {
            Report report;
            if (mounted.getLocation() != n || mounted.isDestroyed() || !(mounted.getType() instanceof MiscType) || !((MiscType)mounted.getType()).hasFlag(0x200000000000L)) continue;
            int n3 = mounted.getBaseDamageCapacity() - mounted.getDamageTaken();
            if (n3 > n2) {
                mounted.damageTaken += n2;
                report = new Report(3535);
                report.subject = this.getId();
                report.add(n2);
                report.indent(1);
                report.newlines = 0;
                vector.addElement(report);
                Report.addNewline(vector);
                return 0;
            }
            if (n3 == n2) {
                Report.addNewline(vector);
                report = new Report(3535);
                report.subject = this.getId();
                report.add(n2);
                report.indent(1);
                report.newlines = 0;
                vector.addElement(report);
                report = new Report(3536);
                report.subject = this.getId();
                report.indent();
                vector.addElement(report);
                mounted.damageTaken += n2;
                mounted.setDestroyed(true);
                mounted.setHit(true);
                return 0;
            }
            if (n3 >= n2) continue;
            Report.addNewline(vector);
            report = new Report(3535);
            report.subject = this.getId();
            report.add(n3);
            report.indent(1);
            report.newlines = 0;
            vector.addElement(report);
            report = new Report(3536);
            report.subject = this.getId();
            report.indent(1);
            vector.addElement(report);
            n2 -= mounted.baseDamageAbsorptionRate - mounted.damageTaken;
            mounted.damageTaken = mounted.baseDamageAbsorptionRate;
            mounted.setDestroyed(true);
            mounted.setHit(true);
        }
        return n2;
    }

    public int getGhostTargetRoll() {
        return this.ghostTargetRoll;
    }

    public int getGhostTargetRollMoS() {
        return this.ghostTargetRoll - (this.getCrew().getSensorOps() + 2);
    }

    public int getGhostTargetOverride() {
        return this.ghostTargetOverride;
    }

    public int getCoolantFailureAmount() {
        return 0;
    }

    public void addCoolantFailureAmount(int n) {
    }

    public int getExtraCommGearTons() {
        int n = 0;
        for (Mounted mounted : this.miscList) {
            if (!mounted.getType().hasFlag(0x200000000L)) continue;
            n = (int)((float)n + mounted.getType().getTonnage(this));
        }
        return n;
    }

    public double getECMStrength() {
        int n = 0;
        for (Mounted mounted : this.getMisc()) {
            if (mounted.getType().hasFlag(0x80000000000L) && n < 1) {
                n = 1;
            }
            if (!mounted.getType().hasFlag(2048L) || n >= 2) continue;
            n = 2;
        }
        return n;
    }

    public double getECCMStrength() {
        double d = 0.0;
        for (Mounted mounted : this.getMisc()) {
            if (mounted.getType().hasFlag(0x200000000L)) {
                if (this.getTotalCommGearTons() > 3 && d < 0.5) {
                    d = 0.5;
                }
                if (this.getTotalCommGearTons() > 6 && d < 1.0) {
                    d = 1.0;
                }
            }
            if (mounted.getType().hasFlag(0x80000000000L) && d < 1.0) {
                d = 1.0;
            }
            if (!mounted.getType().hasFlag(2048L) || !(d < 2.0)) continue;
            d = 2.0;
        }
        return d;
    }

    public abstract int getTotalCommGearTons();

    public int getHQIniBonus() {
        int n = 0;
        for (Mounted mounted : this.getMisc()) {
            if (!mounted.getType().hasFlag(0x200000000L) || !mounted.curMode().equals("Default")) continue;
            if (this.getTotalCommGearTons() >= 3) {
                ++n;
            }
            if (this.getTotalCommGearTons() < 7) break;
            ++n;
            break;
        }
        return n;
    }

    public int getMDIniBonus() {
        if (this.crew.getOptions().booleanOption("comm_implant") || this.crew.getOptions().booleanOption("boost_comm_implant")) {
            return 1;
        }
        return 0;
    }

    public void applySantaAnna() {
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector<Mounted> vector3 = new Vector<Mounted>();
        Vector<String> vector4 = new Vector<String>();
        for (Mounted mounted : this.getAmmo()) {
            if (mounted.getNSantaAnna() <= 0) continue;
            int n = mounted.getNSantaAnna();
            mounted.setShotsLeft(Math.max(mounted.getShotsLeft() - n, 0));
            vector.add(mounted.getLocation());
            vector2.add(n);
            if (mounted.getType().getInternalName().indexOf("AR10") != -1) {
                vector4.add("AR10 SantaAnna Ammo");
            } else {
                vector4.add("SantaAnna Ammo");
            }
            if (null == this.getBayByAmmo(mounted)) {
                System.err.println("cannot find the right bay for Santa Anna ammo");
                return;
            }
            vector3.add(this.getBayByAmmo(mounted));
            mounted.setNSantaAnna(0);
        }
        if (vector2.size() != vector.size() || vector2.size() != vector4.size() || vector2.size() != vector3.size()) {
            System.err.println("cannot load santa anna ammo");
            return;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            try {
                Mounted mounted;
                mounted = this.addEquipment(EquipmentType.get((String)vector4.elementAt(i)), (int)((Integer)vector.elementAt(i)), false, (int)((Integer)vector2.elementAt(i)));
                ((Mounted)vector3.elementAt(i)).addAmmoToBay(this.getEquipmentNum(mounted));
                continue;
            }
            catch (LocationFullException locationFullException) {
                // empty catch block
            }
        }
    }

    public Mounted getBayByAmmo(Mounted mounted) {
        for (Mounted mounted2 : this.getWeaponBayList()) {
            for (int n : mounted2.getBayAmmo()) {
                Mounted mounted3 = this.getEquipment(n);
                if (mounted3 != mounted) continue;
                return mounted2;
            }
        }
        return null;
    }

    public int getVibroClaws() {
        return 0;
    }

    public void baTaserShutdown(int n) {
        this.setShutDown(true);
        this.taserShutdownRounds = n;
        this.shutdownByBATaser = true;
    }

    public int getTaserShutdownRounds() {
        return this.taserShutdownRounds;
    }

    public void setTaserShutdownRounds(int n) {
        this.taserShutdownRounds = n;
    }

    public boolean isBATaserShutdown() {
        return this.shutdownByBATaser;
    }

    public void setBATaserShutdown(boolean bl) {
        this.shutdownByBATaser = bl;
    }

    public void setTaserFeedback(int n) {
        this.taserFeedBackRounds = n;
    }

    public int getTaserFeedBackRounds() {
        return this.taserFeedBackRounds;
    }

    public void setTaserInterference(int n, int n2) {
        this.taserInterference = n;
        this.taserInterferenceRounds = n2;
    }

    public int getTaserInterference() {
        return this.taserInterference;
    }

    public int getTaserInterferenceRounds() {
        return this.taserInterferenceRounds;
    }

    public boolean isMilitary() {
        return true;
    }

    public boolean isLargeCraft() {
        return this instanceof Dropship || this instanceof Jumpship;
    }

    public boolean loadedUnitsHaveActiveECM() {
        return false;
    }

    public boolean isPartOfFighterSquadron() {
        if (this.game == null) {
            return false;
        }
        if (this.conveyance == -1) {
            return false;
        }
        return this.game.getEntity(this.conveyance) instanceof FighterSquadron;
    }

    public String getBVText() {
        if (this.bvText == null) {
            return "";
        }
        return this.bvText.toString();
    }

    public int getBARRating() {
        return 10;
    }

    public boolean hasBARArmor() {
        return this.getBARRating() < 10;
    }

    public boolean hasArmoredChassis() {
        return false;
    }

    public boolean hasEnvironmentalSealing() {
        for (Mounted mounted : this.miscList) {
            if (!mounted.getType().hasFlag(0x8000000000L)) continue;
            return true;
        }
        return false;
    }

    public Vector<Report> doCheckEngineStallRoll(Vector<Report> vector) {
        return vector;
    }

    public void checkUnstall(Vector<Report> vector) {
    }

    public boolean hasArmoredEngine() {
        return false;
    }

    public boolean isStalled() {
        return false;
    }

    public boolean isSurfaceNaval() {
        return this.getElevation() == 0 && (this.getMovementMode() == 7 || this.getMovementMode() == 8 || this.getMovementMode() == 9);
    }

    public void setSource(String string) {
        if (string != null) {
            this.source = string;
        }
    }

    public String getSource() {
        if (this.source == null) {
            return "";
        }
        return this.source;
    }
}

