/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import megamek.client.ui.swing.widget.PMLabel;

public class PMSimpleLabel
implements PMLabel {
    String string;
    int x = 0;
    int y = 0;
    int width;
    int height;
    int descent;
    Color color;
    Font f;
    FontMetrics fm;
    boolean visible = true;

    public PMSimpleLabel(String string, FontMetrics fontMetrics, Color color) {
        this.string = string;
        this.fm = fontMetrics;
        this.width = fontMetrics.stringWidth(this.string);
        this.height = fontMetrics.getHeight();
        this.descent = fontMetrics.getMaxDescent();
        this.color = color;
    }

    public void setString(String string) {
        this.string = string;
        this.width = (int)Math.ceil((double)this.fm.stringWidth(this.string) * 1.4);
        this.height = this.fm.getHeight();
        this.descent = this.fm.getMaxDescent();
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void moveTo(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void translate(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public void drawInto(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        graphics.setColor(this.color);
        graphics.setFont(this.fm.getFont());
        graphics.drawString(this.string, this.x, this.y);
        graphics.setColor(color);
        graphics.setFont(font);
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y - this.height + this.descent, this.width, this.height);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public int getDescent() {
        return this.descent;
    }
}

