/*
 * Decompiled with CFR 0.152.
 */
package mapchecker;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import mapchecker.ArchExit;
import mapchecker.DaiArtifact;
import mapchecker.DaiEvent;
import mapchecker.DaiExit;
import mapchecker.DaiMap;
import mapchecker.DaiObject;
import mapchecker.DaiObjectList;
import mapchecker.DaiWaypoint;

public class RunChecks
extends Thread {
    private JTextArea progress;
    private File logF;
    private String logFilePath;
    private PrintWriter log;
    private File mapF;
    private String archRootDir;
    private String mapFilePath;
    private String mapRootDir;
    private int mapRootLen;
    private boolean checkActive = false;
    private ArrayList<DaiMap> maps = new ArrayList();
    private Map<String, Integer> mapToMap = new HashMap<String, Integer>();
    private ArrayList<DaiObject> archList = new ArrayList();
    private Map<String, DaiObject> archMap = new HashMap<String, DaiObject>();
    private Map<String, ArchExit> exitMap = new HashMap<String, ArchExit>();
    private Map<String, DaiArtifact> artMap = new HashMap<String, DaiArtifact>();
    private int mapCount = 0;
    private final int[] crossRef = new int[]{2, 3, 0, 1, 6, 7, 4, 5};
    private final String[] tileCardinal = new String[]{"N", "E", "S", "W", "NE", "SE", "SW", "NW"};
    private boolean checkPathLogged = false;
    private int warnings = 0;
    private int errors = 0;
    private int archCount = 0;
    private JTextField mapT;
    private String[] scriptPathExceptions = new String[]{"scripts", "scripts_private", "special", "dmbuster"};
    private boolean errorReported = false;
    private BufferedReader inMap;
    private String line;
    private int mapSizeX;
    private int mapSizeY;
    private boolean ignoreMissingFloors;
    private String version;

    public RunChecks(File mapFile, File logFile, String rootDir, int rootLen, String archRoot, JTextField mapText, JTextArea progressText, boolean ignore, String v2) {
        this.mapF = mapFile;
        this.logF = logFile;
        this.archRootDir = archRoot;
        this.mapRootDir = rootDir;
        this.mapRootLen = rootLen;
        this.mapT = mapText;
        this.progress = progressText;
        this.ignoreMissingFloors = ignore;
        this.version = v2;
    }

    @Override
    public void run() {
        this.checkActive = true;
        try {
            this.logFilePath = this.logF.getCanonicalPath();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.Progress("Creating log file...");
        if (this.logF.isDirectory()) {
            this.Progress("Log file cannot be a directory");
            return;
        }
        if (this.logF.exists()) {
            this.logF.delete();
            this.Progress("Deleted old log file.");
        }
        try {
            if (!this.logF.createNewFile()) {
                this.Progress("Failed to create log file");
                return;
            }
            this.Progress("Log file created.");
            this.log = new PrintWriter(new BufferedWriter(new FileWriter(this.logF)));
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy.MM.dd kk:mm:ss");
            String date = dateFormatter.format(new Date());
            this.log.println("MapChecker " + this.version + " - log file created on " + date);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            this.mapFilePath = this.mapF.getCanonicalPath();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.LogProgress("Building archetypes list from archetypes file...", true);
        this.buildArchList();
        this.LogProgress(this.archCount + " archetypes found.", false);
        this.LogProgress("Checking other_arch in archetypes", true);
        this.checkOtherArch();
        this.LogProgress("Building artifacts list from artifacts files...", true);
        this.doArtFile(this.archRootDir + "artifacts");
        this.appendArtifacts(new File(this.mapRootDir));
        this.LogProgress("Checking maps in " + this.mapFilePath + " and below.", true);
        this.LogProgress("Collecting map info...", false);
        if (this.buildTree(this.mapF)) {
            this.LogProgress("...done.", false);
            this.mapCount = this.maps.size();
            this.LogProgress(this.mapCount + " maps found.", false);
            this.LogProgress("Checking tile paths...", true);
            for (DaiMap map : this.maps) {
                this.checkTilePaths(map);
            }
            this.LogProgress("Checking exits...", true);
            for (DaiMap map : this.maps) {
                this.checkExits(map);
            }
            this.LogProgress("Checking events...", true);
            for (DaiMap map : this.maps) {
                this.checkEvents(map);
            }
            this.LogProgress("Checking waypoints...", true);
            for (DaiMap map : this.maps) {
                this.checkWaypoints(map);
            }
            this.LogProgress("Checking map squares...", true);
            for (DaiMap map : this.maps) {
                this.checkMapsquares(map);
            }
        } else {
            this.FinishCheck("Failed to build tree.");
            return;
        }
        this.LogProgress("\r\n" + this.warnings + " warnings\r\n" + this.errors + " errors\r\n", false);
        this.FinishCheck("Map checks completed.");
    }

    private void Progress(String text) {
        if (this.progress != null) {
            this.progress.append(text + "\n");
            this.progress.setCaretPosition(this.progress.getDocument().getLength());
        } else {
            System.out.println(text);
        }
    }

    private void LogProgress(String text, boolean logLine) {
        this.Progress(text);
        if (this.log != null) {
            if (logLine) {
                this.log.println();
            }
            this.log.println(text);
        }
    }

    public boolean getActive() {
        return this.checkActive;
    }

    public boolean Shutdown() {
        this.FinishCheck("Check interrupted by Exit.");
        this.checkActive = false;
        return true;
    }

    private void FinishCheck(String strReason) {
        this.LogProgress(strReason, false);
        if (this.log != null) {
            this.log.println("Log file closed.");
            this.log.close();
        }
        this.checkActive = false;
    }

    private void buildArchList() {
        BufferedReader in;
        String archLine = null;
        String object = "";
        String name = "";
        String title = "";
        String other_arch = "";
        boolean walk_on = false;
        boolean fly_on = false;
        boolean system = false;
        int type = 0;
        int layer = 0;
        int exitType = 66;
        String s2 = this.archRootDir + "archetypes";
        try {
            in = new BufferedReader(new FileReader(new File(s2)));
        }
        catch (FileNotFoundException ex) {
            this.log.println("Could not open archetypes file " + s2);
            return;
        }
        archLine = this.getLine(in);
        while (archLine != null) {
            if (archLine.startsWith("Object")) {
                object = archLine.substring(7);
                if (object.startsWith("floor")) {
                    boolean i = false;
                }
                walk_on = false;
                fly_on = false;
                system = false;
                type = 0;
                layer = 0;
                name = "";
                title = "";
                other_arch = "";
            } else if (archLine.startsWith("name")) {
                name = archLine.substring(5);
            } else if (archLine.startsWith("title")) {
                title = archLine.substring(6);
            } else if (archLine.startsWith("other_arch")) {
                other_arch = archLine.substring(11);
            } else if (archLine.startsWith("layer")) {
                layer = Integer.parseInt(archLine.substring(6));
            } else if (archLine.startsWith("type")) {
                type = Integer.parseInt(archLine.substring(5));
            } else if (archLine.startsWith("walk_on")) {
                walk_on = Integer.parseInt(archLine.substring(8)) == 1;
            } else if (archLine.startsWith("fly_on")) {
                fly_on = Integer.parseInt(archLine.substring(7)) == 1;
            } else if (archLine.startsWith("sys_object")) {
                system = Integer.parseInt(archLine.substring(11)) == 1;
            } else if (archLine.equals("end")) {
                if (type == 66) {
                    this.exitMap.put(object, new ArchExit(object, walk_on, fly_on));
                }
                DaiObject obj = new DaiObject(object, name, title, other_arch, type, layer, 0, system);
                this.archList.add(obj);
                this.archMap.put(object, obj);
                ++this.archCount;
            }
            archLine = this.getLine(in);
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void checkOtherArch() {
        for (DaiObject arch : this.archList) {
            String other = arch.getOtherArch();
            if (other.length() <= 0 || this.archMap.containsKey(other)) continue;
            this.log.println("**Error: " + arch.getObject() + " references other_arch " + other + ", but this does not exist.");
            ++this.errors;
        }
    }

    private void appendArtifacts(File mapRoot) {
        File[] dirList = mapRoot.listFiles();
        if (dirList == null) {
            this.FinishCheck("Could not list files in directory " + mapRoot.getPath());
        } else {
            for (File f2 : dirList) {
                String s2 = f2.getName();
                if (f2.isDirectory()) {
                    if (s2.equals(".svn")) continue;
                    this.appendArtifacts(f2);
                    continue;
                }
                if (!s2.contains(".art")) continue;
                this.doArtFile(f2.getPath());
            }
        }
    }

    private String getLine(BufferedReader in) {
        String archLine = null;
        try {
            archLine = in.readLine();
            if (archLine != null && archLine.startsWith("msg")) {
                while (archLine != null && !archLine.startsWith("endmsg")) {
                    archLine = in.readLine();
                }
                archLine = in.readLine();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return archLine;
    }

    private boolean buildTree(File map) {
        boolean ok = false;
        File[] dirList = map.listFiles();
        if (dirList == null) {
            this.FinishCheck("Could not list files in directory " + map.getPath());
        } else {
            for (File f2 : dirList) {
                DaiMap m2;
                String s2 = f2.getName();
                if (f2.isDirectory()) {
                    if (s2.equals(".svn")) continue;
                    this.buildTree(f2);
                    continue;
                }
                if (s2.contains(".") || !(m2 = new DaiMap(f2, this.mapRootDir, this.exitMap)).isValid()) continue;
                this.maps.add(m2);
                this.mapToMap.put(m2.getPath(), this.mapCount);
                if (this.mapT != null) {
                    this.mapT.setText(m2.getPath().substring(this.mapRootLen));
                    this.mapT.setCaretPosition(this.mapT.getDocument().getLength());
                }
                ++this.mapCount;
            }
            ok = true;
        }
        return ok;
    }

    private void doArtFile(String s2) {
        BufferedReader in = null;
        String artLine = null;
        String artifact = "";
        String def_arch = "";
        String name = "";
        String title = "";
        int layer = 0;
        int type = 0;
        this.errorReported = false;
        this.LogProgress("Processing artifacts file " + s2, false);
        try {
            in = new BufferedReader(new FileReader(new File(s2)));
        }
        catch (FileNotFoundException ex) {
            this.log.println("Could not open artifacts file " + s2);
            return;
        }
        artLine = this.getLine(in);
        while (artLine != null) {
            if (!artLine.startsWith("#")) {
                if (artLine.startsWith("Allowed")) {
                    artifact = "";
                    def_arch = "";
                    name = "";
                    title = "";
                    layer = 0;
                    type = 0;
                } else if (artLine.startsWith("artifact")) {
                    artifact = artLine.substring(9);
                } else if (artLine.startsWith("def_arch")) {
                    def_arch = artLine.substring(9);
                } else if (artLine.startsWith("name")) {
                    name = artLine.substring(5);
                } else if (artLine.startsWith("title")) {
                    title = artLine.substring(6);
                } else if (artLine.startsWith("layer")) {
                    layer = Integer.parseInt(artLine.substring(6));
                } else if (artLine.startsWith("type")) {
                    type = Integer.parseInt(artLine.substring(5));
                } else if (artLine.equals("end")) {
                    if (this.archMap.containsKey(def_arch)) {
                        DaiObject arch = this.archMap.get(def_arch);
                        if (this.artMap.containsKey(artifact)) {
                            this.logArtFileError(s2, artifact, "duplicates artifact in " + this.artMap.get(artifact).getPath());
                        } else if (this.archMap.containsKey(artifact)) {
                            this.logArtFileError(s2, artifact, "has same name as an archetype.");
                        } else {
                            if (name.isEmpty()) {
                                name = arch.getName();
                            }
                            if (title.isEmpty()) {
                                title = arch.getTitle();
                            }
                            this.artMap.put(artifact, new DaiArtifact(artifact, name, title, def_arch, s2, type, layer));
                        }
                    } else {
                        this.logArtFileError(s2, artifact, "references default archetype " + def_arch + "\r\n\tbut archetype does not exist.");
                    }
                }
            }
            artLine = this.getLine(in);
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    void logArtFileError(String path, String arch, String text) {
        if (!this.errorReported) {
            this.errorReported = true;
            this.log.println("\r\nArtifact file " + path);
        }
        this.log.println("**Error: artifact " + arch + " " + text);
        ++this.errors;
    }

    private void checkTilePaths(DaiMap map) {
        String thisPath = map.getPath();
        String shortPath = thisPath.substring(this.mapRootLen);
        if (this.mapT != null) {
            this.mapT.setText(shortPath);
            this.mapT.setCaretPosition(this.mapT.getDocument().getLength());
        }
        for (int tileIndex = 0; tileIndex < 8; ++tileIndex) {
            String refPath = map.getTilePath(tileIndex);
            if (refPath == null) continue;
            String shortRefPath = refPath.substring(this.mapRootLen);
            if (!this.mapToMap.containsKey(refPath)) {
                this.logTileFirstPart(shortPath, tileIndex, shortRefPath);
                this.log.println("\tbut map does not exist.");
                ++this.errors;
            } else {
                int mapIndex = this.mapToMap.get(refPath);
                DaiMap refMap = this.maps.get(mapIndex);
                String backRef = refMap.getTilePath(this.crossRef[tileIndex]);
                if (backRef == null) {
                    this.logTileFirstPart(shortPath, tileIndex, shortRefPath);
                    this.log.println("\tbut that map has no " + this.tileCardinal[this.crossRef[tileIndex]] + " connection.");
                    ++this.errors;
                } else if (!backRef.equals(thisPath)) {
                    String shortBackRef = backRef.substring(this.mapRootLen);
                    this.logTileFirstPart(shortPath, tileIndex, shortRefPath);
                    this.log.println("\tbut that map's " + this.tileCardinal[this.crossRef[tileIndex]] + " tile path connects to " + shortBackRef);
                    ++this.errors;
                }
            }
            if (!map.getTilePathAbs(tileIndex)) continue;
            this.log.println();
            this.log.println("**Warning: map " + shortPath + " " + this.tileCardinal[tileIndex] + " tile path");
            this.log.println("\tis an absolute reference.");
            ++this.warnings;
        }
    }

    private void logTileFirstPart(String shortPath, int tileIndex, String shortRefPath) {
        this.log.println();
        this.log.println("**Error: map " + shortPath + " " + this.tileCardinal[tileIndex] + " tile path");
        this.log.println("\tconnects to map " + shortRefPath + ",");
    }

    private void checkExits(DaiMap map) {
        String thisPath = map.getPath();
        String shortPath = thisPath.substring(this.mapRootLen);
        if (this.mapT != null) {
            this.mapT.setText(shortPath);
            this.mapT.setCaretPosition(this.mapT.getDocument().getLength());
        }
        for (int exitIndex = 0; exitIndex < map.getNumExits(); ++exitIndex) {
            DaiExit exit = map.getExit(exitIndex);
            String refPath = exit.getRefPath();
            if (refPath.length() <= 0) continue;
            String shortRefPath = refPath.substring(this.mapRootLen);
            if (!this.mapExists(refPath)) {
                this.logExitFirstPart("**Error", exit, shortPath, shortRefPath);
                this.log.println("\tbut map does not exist.");
                ++this.errors;
            }
            if (!exit.isAbs()) continue;
            this.logExitFirstPart("**Warning", exit, shortPath, shortRefPath);
            this.log.println("\tbut reference is absolute.");
            ++this.warnings;
        }
    }

    private void logExitFirstPart(String which, DaiExit exit, String shortPath, String shortRefPath) {
        this.log.println();
        this.log.println(which + ": Exit on map " + shortPath + " [" + exit.getEnvDesc() + "]");
        if (shortRefPath != null) {
            this.log.println("\treferences map " + shortRefPath + ",");
        }
    }

    private void checkEvents(DaiMap map) {
        String thisPath = map.getPath();
        String shortPath = thisPath.substring(this.mapRootLen);
        if (this.mapT != null) {
            this.mapT.setText(shortPath);
            this.mapT.setCaretPosition(this.mapT.getDocument().getLength());
        }
        for (int eventIndex = 0; eventIndex < map.getNumEvents(); ++eventIndex) {
            DaiEvent event = map.getEvent(eventIndex);
            String scriptPath = event.getScriptPath();
            if (scriptPath.length() <= 0) continue;
            File f2 = new File(scriptPath);
            String shortScriptPath = scriptPath.substring(this.mapRootLen);
            if (!f2.exists()) {
                this.logEventFirstPart("**Error", event, shortPath, shortScriptPath);
                this.log.println("\tbut script file does not exist.");
                ++this.errors;
            }
            if (!event.isAbs()) continue;
            boolean ignoreWarning = false;
            String firstDir = shortScriptPath.substring(1);
            int i = firstDir.indexOf(File.separatorChar);
            if (i > 0) {
                firstDir = firstDir.substring(0, i);
                for (String s2 : this.scriptPathExceptions) {
                    if (!firstDir.equalsIgnoreCase(s2)) continue;
                    ignoreWarning = true;
                    break;
                }
            }
            if (ignoreWarning) continue;
            this.logEventFirstPart("**Warning", event, shortPath, shortScriptPath);
            this.log.println("\tbut reference is absolute.");
            ++this.warnings;
        }
    }

    private void logEventFirstPart(String which, DaiEvent event, String shortPath, String shortScriptPath) {
        this.log.println("\r\n" + which + ": Event on map " + shortPath + " [" + event.getEnvDesc() + "]");
        if (shortScriptPath != null) {
            this.log.println("\treferences script " + shortScriptPath + ",");
        }
    }

    private void checkWaypoints(DaiMap map) {
        String thisPath = map.getPath();
        String shortPath = thisPath.substring(this.mapRootLen);
        if (this.mapT != null) {
            this.mapT.setText(shortPath);
            this.mapT.setCaretPosition(this.mapT.getDocument().getLength());
        }
        for (int waypointIndex = 0; waypointIndex < map.getNumWaypoints(); ++waypointIndex) {
            DaiWaypoint waypoint = map.getWaypoint(waypointIndex);
            String refPath = waypoint.getRefPath();
            if (refPath.length() <= 0) continue;
            String shortRefPath = refPath.substring(this.mapRootLen);
            if (!this.mapExists(refPath)) {
                this.logWaypointFirstPart("**Error", waypoint, shortPath, shortRefPath);
                this.log.println("\tbut map does not exist.");
                ++this.errors;
            }
            if (!waypoint.isAbs()) continue;
            this.logWaypointFirstPart("**Warning", waypoint, shortPath, shortRefPath);
            this.log.println("\tbut reference is absolute.");
            ++this.warnings;
        }
    }

    private void logWaypointFirstPart(String which, DaiWaypoint waypoint, String shortPath, String shortRefPath) {
        this.log.println("\r\n" + which + ": Waypoint on map " + shortPath + " [" + waypoint.getEnvDesc() + "]");
        if (shortRefPath != null) {
            this.log.println("\treferences map " + shortRefPath + ",");
        }
    }

    private void checkMapsquares(DaiMap map) {
        int y2;
        int x;
        boolean curX = false;
        boolean curY = false;
        boolean valid = true;
        int typeFloor = 71;
        int typeSpawn = 81;
        int typeMob = 80;
        int typeSpMob = 83;
        this.errorReported = false;
        this.mapSizeX = map.getWidth();
        this.mapSizeY = map.getHeight();
        DaiObjectList[][] objlist = new DaiObjectList[this.mapSizeX][this.mapSizeY];
        for (x = 0; x < this.mapSizeX; ++x) {
            for (y2 = 0; y2 < this.mapSizeY; ++y2) {
                objlist[x][y2] = new DaiObjectList();
            }
        }
        String thisPath = map.getPath();
        String shortPath = thisPath.substring(this.mapRootLen);
        if (this.mapT != null) {
            this.mapT.setText(shortPath);
            this.mapT.setCaretPosition(this.mapT.getDocument().getLength());
        }
        try {
            this.inMap = new BufferedReader(new FileReader(map.getFile()));
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        this.line = this.getLine(this.inMap);
        if (this.line != null && this.line.equals("arch map")) {
            this.line = this.getLine(this.inMap);
            while (valid && this.line != null) {
                if (this.line.startsWith("arch ")) {
                    valid = this.processArch(objlist, shortPath, 0, 0, 0);
                }
                this.line = this.getLine(this.inMap);
            }
        } else {
            valid = false;
        }
        try {
            this.inMap.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (!valid) {
            this.log.println("\r\nError: Map " + shortPath + " has errors and cannot be processed.");
            ++this.errors;
        }
        for (x = 0; x < this.mapSizeX; ++x) {
            block8: for (y2 = 0; y2 < this.mapSizeY; ++y2) {
                DaiObjectList list = objlist[x][y2];
                int listSize = list.size();
                if (listSize <= 0) continue;
                int count = 0;
                boolean hasSpawnPoint = false;
                boolean hasMob = false;
                boolean hasSpMob = false;
                for (DaiObject obj : list) {
                    int type = obj.getType();
                    if (type == 81) {
                        hasSpawnPoint = true;
                    } else if (type == 80) {
                        hasMob = true;
                    } else if (type == 83) {
                        hasSpMob = true;
                    } else if (obj.getLayer() == 1) {
                        ++count;
                    }
                    if (!obj.isSysObject() || obj.getLayer() == 0) continue;
                    this.logMapsquareError("Warning", shortPath, x, y2, "system object not on layer 0");
                    ++this.warnings;
                }
                if (count == 0) {
                    if (!this.ignoreMissingFloors) {
                        this.logMapsquareError("Warning", shortPath, x, y2, "has objects but no floor");
                        ++this.warnings;
                    }
                } else if (count > 1) {
                    this.logMapsquareError("Error", shortPath, x, y2, "more than one floor");
                    ++this.errors;
                }
                if (hasSpawnPoint && !hasSpMob) {
                    this.logMapsquareError("Warning", shortPath, x, y2, "empty spawn point");
                    ++this.warnings;
                }
                if (hasMob) {
                    this.logMapsquareError("Error", shortPath, x, y2, "monster/NPC not in spawn point");
                    ++this.errors;
                }
                boolean error = false;
                for (int i = 0; i < listSize - 1; ++i) {
                    DaiObject iObj = (DaiObject)list.get(i);
                    int iLayer = iObj.getLayer();
                    if (iObj.getEnvLevel() > 0 || iLayer < 2) continue;
                    for (int j2 = i + 1; j2 < listSize; ++j2) {
                        DaiObject jObj = (DaiObject)list.get(j2);
                        if (jObj.getEnvLevel() != 0 || jObj.getLayer() != iLayer) continue;
                        this.logMapsquareError("Warning", shortPath, x, y2, "more than one object on same layer");
                        ++this.warnings;
                        error = true;
                        break;
                    }
                    if (error) continue block8;
                }
            }
        }
    }

    private boolean processArch(DaiObjectList[][] list, String shortPath, int curX, int curY, int envLevel) {
        DaiObject arch = null;
        DaiArtifact art = null;
        String object = this.line.substring(5);
        String name = "";
        String title = "";
        String other_arch = "";
        String def_arch = "";
        int type = 0;
        int layer = 0;
        boolean system = false;
        boolean valid = true;
        boolean exists = true;
        if (this.archMap.containsKey(object)) {
            arch = this.archMap.get(object);
            name = arch.getName();
            title = arch.getTitle();
            type = arch.getType();
            layer = arch.getLayer();
        } else if (this.artMap.containsKey(object)) {
            art = this.artMap.get(object);
            arch = this.archMap.get(art.getDefArch());
            name = art.getName();
            title = art.getTitle();
            type = art.getType();
            layer = art.getLayer();
        } else {
            exists = false;
        }
        if (exists) {
            other_arch = arch.getOtherArch();
            system = arch.isSysObject();
        }
        while (this.line != null) {
            this.line = this.getLine(this.inMap);
            if (this.line.startsWith("arch ")) {
                if (this.processArch(list, shortPath, curX, curY, envLevel + 1)) continue;
                return false;
            }
            if (this.line.equals("end")) {
                if (!exists) {
                    this.logMapsquareError("Error", shortPath, curX, curY, "object " + object + " does not exist!");
                    ++this.errors;
                }
                if (curX < 0 || curY < 0 || curX >= this.mapSizeX || curY >= this.mapSizeY) {
                    valid = false;
                } else {
                    list[curX][curY].add(new DaiObject(object, name, title, other_arch, type, layer, envLevel, system));
                }
                return valid;
            }
            if (this.line.startsWith("x ")) {
                curX = Integer.parseInt(this.line.substring(2));
                continue;
            }
            if (this.line.startsWith("y ")) {
                curY = Integer.parseInt(this.line.substring(2));
                continue;
            }
            if (this.line.startsWith("name ")) {
                name = this.line.substring(5);
                continue;
            }
            if (this.line.startsWith("title ")) {
                title = this.line.substring(6);
                continue;
            }
            if (this.line.startsWith("type ")) {
                type = Integer.parseInt(this.line.substring(5));
                continue;
            }
            if (this.line.startsWith("layer ")) {
                layer = Integer.parseInt(this.line.substring(6));
                continue;
            }
            if (!this.line.startsWith("sys_object ")) continue;
            system = Integer.parseInt(this.line.substring(11)) == 1;
        }
        return false;
    }

    private void logMapsquareError(String which, String shortPath, int x, int y2, String text) {
        if (!this.errorReported) {
            this.errorReported = true;
            this.log.println("\r\nMap " + shortPath);
        }
        this.log.println("**" + which + ": square (" + x + ", " + y2 + ") " + text);
    }

    private boolean mapExists(String refPath) {
        boolean ok = false;
        ok = this.mapToMap.containsKey(refPath);
        if (!ok) {
            File f2 = new File(refPath);
            ok = f2.exists();
        }
        return ok;
    }
}

