/* $Id: TestDSA.java,v 1.5 2000/07/28 20:06:11 gelderen Exp $
 *
 * Copyright (C) 1995-1999 The Cryptix Foundation Limited.
 * All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce.test;


import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.*;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

final class TestDSA
extends Test
{
    private static SecureRandom random = new SecureRandom();

    private static final String NAME = "DSA";


    protected TestDSA()
    {
        super(NAME);
    }


    protected void testExistence(String alg)
    throws Exception
    {
        beginTest("Algorithm available as "+alg);
        boolean res = true;
        try
        {
            Signature c1= Signature.getInstance(alg, "CryptixCrypto");
            Signature c = Signature.getInstance(alg, "SUN");
            
            KeyPairGenerator kgen = KeyPairGenerator.getInstance("DSA");
            kgen.initialize(1024);
            KeyPair kp = kgen.genKeyPair();
            
            byte[] sig1 = null;
            c1.initSign(kp.getPrivate());
            c1.update("jeroen".getBytes());
            sig1 = c1.sign();
            
            int num = 1000;
            System.out.println("begin of num: " + num);
            long start = System.currentTimeMillis();
            for( int i=0; i<num; i++ ) {
                c1.initSign(kp.getPrivate());
                c1.update("jeroen".getBytes());
                c1.sign();
            }
            long end = System.currentTimeMillis();
            System.out.println("mills/iter: " + ((end-start)/num));
            
            
            System.out.println("begin of num: " + num);
            start = System.currentTimeMillis();
            for( int i=0; i<num; i++ ) {
                c1.initVerify(kp.getPublic());
                c1.update("jeroen".getBytes());
                if( !c1.verify(sig1) )
                    throw new RuntimeException();
            }
            end = System.currentTimeMillis();
            System.out.println("mills/iter: " + ((end-start)/num));
            

            c.initVerify(kp.getPublic());
            c.update("jeroen".getBytes());
            boolean res1 = c.verify(sig1);
            System.out.println("res1: " + res1);
            
            c.initVerify(kp.getPublic());
            c.update("jeroen".getBytes());
            boolean res2 = c.verify(sig1);
            System.out.println("res2: " + res2);
            
            c.initVerify(kp.getPublic());
            c.update("jeoen".getBytes());
            boolean res3 = c.verify(sig1);
            System.out.println("res3: " + res3);
            
        } catch(NoSuchAlgorithmException e)
        {
            e.printStackTrace();
            res=false;
        }
        passIf(res);
    }


    protected void doIt()
    throws Exception
    {
        testExistence("DSA");
    }
}       
