/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.test.Test;
import java.io.Serializable;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;

final class TestSealedObject
extends Test {
    private static final String name = "SealedObject";
    private Cipher c;
    private Cipher d;
    private SecretKey sk;
    private final String s = "ThisIsASecretSecretMessag";
    private String algo;
    private int KEY_SIZE;

    protected TestSealedObject() {
        super(name);
        this.algo = "DES";
        this.KEY_SIZE = 56;
    }

    protected TestSealedObject(String string, int n) {
        super(name);
        this.algo = string;
        this.KEY_SIZE = n;
    }

    protected void doIt() throws Exception {
        this.init();
        this.beginTest("Decrypt with the cipher");
        this.passIf(this.test1(this.c, this.d, "ThisIsASecretSecretMessag"));
        this.beginTest("Decrypting with the secretkey");
        this.passIf(this.test2(this.c, this.sk, "ThisIsASecretSecretMessag"));
    }

    private void init() throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(this.algo);
        keyGenerator.init(this.KEY_SIZE);
        this.sk = keyGenerator.generateKey();
        this.algo = String.valueOf(this.algo) + "/ECB/NoPadding";
        this.c = Cipher.getInstance(this.algo);
        this.d = Cipher.getInstance(this.algo);
        this.c.init(1, this.sk);
        this.d.init(2, this.sk);
    }

    private boolean test1(Cipher cipher, Cipher cipher2, String string) throws Exception {
        String string2 = "";
        SealedObject sealedObject = new SealedObject((Serializable)((Object)string), cipher);
        string2 = (String)sealedObject.getObject(cipher2);
        return string2.equals(string);
    }

    private boolean test2(Cipher cipher, SecretKey secretKey, String string) throws Exception {
        String string2 = "";
        SealedObject sealedObject = new SealedObject((Serializable)((Object)string), cipher);
        string2 = (String)sealedObject.getObject(secretKey);
        return string2.equals(string);
    }
}

