/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.test.Test;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

final class TestModeAndPadding
extends Test {
    private static final String name = "ModeAndPadding";
    private final String s1 = "ThisIsSecretSecretMessageInText!";
    private final String s2 = "ThisIsSecretMessage";
    private Cipher c;
    private Cipher d;
    private SecretKey sk;
    private String algo;
    private int KEY_SIZE;

    protected TestModeAndPadding() {
        super(name);
        this.algo = "DES";
        this.KEY_SIZE = 56;
    }

    protected TestModeAndPadding(String string, int n) {
        super(name);
        this.algo = string;
        this.KEY_SIZE = n;
    }

    private void changeMode(String string, String string2) throws Exception {
        String string3 = String.valueOf(this.algo) + "/" + string + "/" + string2;
        this.c = Cipher.getInstance(string3);
        this.d = Cipher.getInstance(string3);
        this.c.init(1, this.sk);
        if (string.equals("ECB")) {
            this.d.init(2, this.sk);
        } else {
            this.d.init(2, (Key)this.sk, new IvParameterSpec(this.c.getIV()));
        }
    }

    protected void doIt() throws Exception {
        this.init();
        this.beginTest("ECB mode with no padding");
        this.changeMode("ECB", "NONE");
        this.passIf(this.test1(this.c, this.d, "ThisIsSecretSecretMessageInText!") && this.test2(this.c, this.d, "ThisIsSecretSecretMessageInText!"));
        this.beginTest("ECB mode with PKCS5 padding");
        this.changeMode("ECB", "PKCS5");
        this.passIf(this.test1(this.c, this.d, "ThisIsSecretMessage") && this.test2(this.c, this.d, "ThisIsSecretMessage"));
        this.beginTest("CBC mode with no padding");
        this.changeMode("CBC", "NoPadding");
        this.passIf(this.test1(this.c, this.d, "ThisIsSecretSecretMessageInText!") && this.test2(this.c, this.d, "ThisIsSecretSecretMessageInText!"));
        this.beginTest("CBC mode with PKCS5 padding");
        this.changeMode("CBC", "PKCS5");
        this.passIf(this.test1(this.c, this.d, "ThisIsSecretMessage") && this.test2(this.c, this.d, "ThisIsSecretMessage"));
        this.beginTest("OFB mode with no padding");
        this.changeMode("OFB", "NONE");
        this.passIf(this.test1(this.c, this.d, "ThisIsSecretMessage") && this.test2(this.c, this.d, "ThisIsSecretMessage"));
        this.beginTest("OFB mode with PKCS5 padding");
        this.changeMode("OFB", "PKCS5");
        this.passIf(this.test1(this.c, this.d, "ThisIsSecretMessage") && this.test2(this.c, this.d, "ThisIsSecretMessage"));
        this.beginTest("CFB mode with no padding");
        this.changeMode("CFB56", "None");
        this.passIf(this.test1(this.c, this.d, "ThisIsSecretMessage") && this.test2(this.c, this.d, "ThisIsSecretMessage"));
        this.beginTest("CFB mode with PKCS5 padding");
        this.changeMode("CFB", "PKCS5");
        this.passIf(this.test1(this.c, this.d, "ThisIsSecretMessage") && this.test2(this.c, this.d, "ThisIsSecretMessage"));
    }

    private void init() throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(this.algo);
        keyGenerator.init(this.KEY_SIZE);
        this.sk = keyGenerator.generateKey();
    }

    private boolean test1(Cipher cipher, Cipher cipher2, String string) throws Exception {
        byte[] byArray = cipher.update(string.getBytes());
        byte[] byArray2 = cipher.doFinal();
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return string.equals(new String(cipher2.doFinal(byArray3)));
    }

    private boolean test2(Cipher cipher, Cipher cipher2, String string) throws Exception {
        byte[] byArray = cipher.doFinal(string.getBytes());
        return string.equals(new String(cipher2.doFinal(byArray)));
    }
}

