/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.test.Test;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import javax.crypto.Cipher;

class TestElGamal
extends Test {
    private static SecureRandom random = new SecureRandom();
    private KeyPair kp;
    private Cipher c;

    TestElGamal() {
        super("ElGamal");
    }

    protected void doIt() {
        this.doItPrivate2();
        this.doItPrivate3();
    }

    private void doItPrivate2() {
        this.beginTest("ElGamal KeyGen");
        boolean bl = false;
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ElGamal");
            keyPairGenerator.initialize(512, new SecureRandom(String.valueOf(System.currentTimeMillis()).getBytes()));
            this.kp = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
            this.c = Cipher.getInstance("ElGamal/ECB/PKCS#1");
            bl = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.passIf(bl);
    }

    private void doItPrivate3() {
        this.beginTest("ElGamal encrypting");
        boolean bl = true;
        try {
            byte[] byArray = new byte[20];
            random.nextBytes(byArray);
            this.c.init(1, (Key)this.kp.getPublic(), random);
            byte[] byArray2 = this.c.doFinal(byArray);
            this.c.init(2, (Key)this.kp.getPrivate(), random);
            byte[] byArray3 = this.c.doFinal(byArray2);
            int n = 0;
            while (n < byArray3.length) {
                if (byArray[n] != byArray3[n]) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            bl = false;
            throwable.printStackTrace();
        }
        this.passIf(bl);
    }
}

