/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.test.Test;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

final class TestCipherStream
extends Test {
    private static final String name = "CipherStreams";
    private Cipher c;
    private Cipher d;
    private final String s = "ThisIsASecretSecretMessageOfNull";
    private String algo;
    private int KEY_SIZE;

    protected TestCipherStream() {
        super(name);
        this.algo = "DES";
        this.KEY_SIZE = 56;
    }

    protected TestCipherStream(String string, int n) {
        super(name);
        this.algo = string;
        this.KEY_SIZE = n;
    }

    protected void doIt() throws Exception {
        this.init();
        this.beginTest("COS(file, ENCRYPT) -> CIS(file, DECRYPT)");
        this.passIf(this.test1(this.c, this.d, "ThisIsASecretSecretMessageOfNull"));
        this.beginTest("CIS(CIS(file, ENCRYPT), DECRYPT)");
        this.passIf(this.test2(this.c, this.d, "ThisIsASecretSecretMessageOfNull"));
        this.beginTest("COS(COS(file, DECRYPT), ENCRYPT)");
        this.passIf(this.test3(this.c, this.d, "ThisIsASecretSecretMessageOfNull"));
    }

    private void init() throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(this.algo);
        keyGenerator.init(this.KEY_SIZE);
        SecretKey secretKey = keyGenerator.generateKey();
        this.algo = String.valueOf(this.algo) + "/ECB/PKCS5";
        this.c = Cipher.getInstance(this.algo);
        this.d = Cipher.getInstance(this.algo);
        this.c.init(1, secretKey);
        this.d.init(2, secretKey);
    }

    private boolean test1(Cipher cipher, Cipher cipher2, String string) throws Exception {
        int n;
        File file = new File("slask.tmp");
        if (file.exists()) {
            file.delete();
        }
        byte[] byArray = string.getBytes();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        CipherOutputStream cipherOutputStream = new CipherOutputStream(fileOutputStream, cipher);
        cipherOutputStream.write(byArray);
        cipherOutputStream.flush();
        cipherOutputStream.close();
        fileOutputStream.close();
        FileInputStream fileInputStream = new FileInputStream(file);
        CipherInputStream cipherInputStream = new CipherInputStream(fileInputStream, cipher2);
        byte[] byArray2 = new byte[1024];
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while ((n = cipherInputStream.read(byArray2)) != -1) {
            stringBuffer.append(new String(byArray2, 0, n));
            n2 += n;
        }
        cipherInputStream.close();
        fileInputStream.close();
        file.delete();
        return stringBuffer.toString().equals(string);
    }

    private boolean test2(Cipher cipher, Cipher cipher2, String string) throws Exception {
        int n;
        File file;
        File file2 = new File("slask1.tmp");
        if (file2.exists()) {
            file2.delete();
        }
        if ((file = new File("slask2.tmp")).exists()) {
            file.delete();
        }
        FileWriter fileWriter = new FileWriter(file2);
        fileWriter.write(string);
        fileWriter.close();
        FileInputStream fileInputStream = new FileInputStream(file2);
        CipherInputStream cipherInputStream = new CipherInputStream(fileInputStream, cipher);
        CipherInputStream cipherInputStream2 = new CipherInputStream(cipherInputStream, cipher2);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[8];
        while ((n = cipherInputStream2.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        cipherInputStream.close();
        cipherInputStream2.close();
        fileInputStream.close();
        fileOutputStream.close();
        FileReader fileReader = new FileReader(file);
        char[] cArray = new char[1024];
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = fileReader.read(cArray)) != -1) {
            stringBuffer.append(new String(cArray, 0, n));
        }
        fileReader.close();
        file2.delete();
        file.delete();
        return stringBuffer.toString().equals(string);
    }

    private boolean test3(Cipher cipher, Cipher cipher2, String string) throws Exception {
        int n;
        File file;
        File file2 = new File("slask1.tmp");
        if (file2.exists()) {
            file2.delete();
        }
        if ((file = new File("slask2.tmp")).exists()) {
            file.delete();
        }
        FileWriter fileWriter = new FileWriter(file2);
        fileWriter.write(string);
        fileWriter.close();
        FileInputStream fileInputStream = new FileInputStream(file2);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        CipherOutputStream cipherOutputStream = new CipherOutputStream(fileOutputStream, cipher2);
        CipherOutputStream cipherOutputStream2 = new CipherOutputStream(cipherOutputStream, cipher);
        byte[] byArray = new byte[8];
        while ((n = fileInputStream.read(byArray)) != -1) {
            cipherOutputStream2.write(byArray, 0, n);
        }
        cipherOutputStream2.flush();
        cipherOutputStream2.close();
        cipherOutputStream.close();
        fileOutputStream.close();
        fileInputStream.close();
        FileReader fileReader = new FileReader(file);
        char[] cArray = new char[8];
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = fileReader.read(cArray)) != -1) {
            stringBuffer.append(new String(cArray, 0, n));
        }
        fileReader.close();
        file2.delete();
        file.delete();
        return stringBuffer.toString().equals(string);
    }
}

