/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.provider.CryptixCrypto;
import java.security.Provider;
import java.security.Security;

public abstract class Test {
    private static final String CLASS_PREFIX = "cryptix.jce.test.Test";
    private static final String VERSION = "$Revision: 1.22 $";
    private static boolean verbose = true;
    private static String[] TESTS = new String[]{"DSA", "MD2", "MD4", "MD5", "RIPEMD", "RIPEMD128", "RIPEMD160", "SHA0", "SHA1", "SHA256", "SHA384", "SHA512", "Tiger", "Blowfish", "CAST5", "DES", "IDEA", "MARS", "Null", "RC2", "RC6", "Rijndael", "Serpent", "SKIPJACK", "Square", "TripleDES", "Twofish", "RSA_ECB_PKCS1", "ElGamal", "ModeAndPadding", "AlgorithmParameters", "CipherStream", "SealedObject"};
    private static String currentTest;

    protected Test(String string) {
        currentTest = string;
    }

    protected void beginTest(String string) {
        System.out.print("Testing " + currentTest + " (" + string + ")... ");
    }

    protected abstract void doIt() throws Exception;

    private static Test getTest(String string) throws Exception {
        Class<?> clazz = Class.forName(CLASS_PREFIX + string);
        Object obj = clazz.newInstance();
        return (Test)obj;
    }

    public static void main(String[] stringArray) {
        Test.printVerbose("Cryptix JCE Test Driver - $Revision: 1.22 $ - http://www.cryptix.org/");
        Test.printVerbose("");
        Test.printVerbose("Platform: JDK " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ") on " + System.getProperty("os.name") + " (" + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + ")");
        Test.printVerbose("Classpath: " + System.getProperty("java.class.path"));
        Test.printVerbose("");
        if (stringArray.length == 0) {
            System.out.println("Usage: Test <testname>  or  Test All");
            System.exit(0);
        }
        try {
            Security.addProvider((Provider)new CryptixCrypto());
            String[] stringArray2 = stringArray[0].equalsIgnoreCase("All") ? TESTS : stringArray;
            int n = 0;
            while (n < stringArray2.length) {
                Test test = Test.getTest(stringArray2[n]);
                test.doIt();
                ++n;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Test not found.");
            System.exit(1);
        }
        catch (Throwable throwable) {
            System.out.println("Failed");
            throwable.printStackTrace();
            System.exit(1);
        }
        System.exit(10);
    }

    protected void passIf(boolean bl) {
        if (!bl) {
            throw new RuntimeException("Test failed");
        }
        System.out.println("Ok");
    }

    private static void printVerbose(String string) {
        if (verbose) {
            System.out.println(string);
        }
    }
}

