/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.test.Test;
import cryptix.jce.test.Util;
import java.security.MessageDigest;

abstract class MessageDigestTest
extends Test {
    protected MessageDigestTest(String string) {
        super(string);
    }

    protected void testCloning(String string) throws Exception {
        this.beginTest("Cloning");
        boolean bl = true;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string, "CryptixCrypto");
            MessageDigest messageDigest2 = (MessageDigest)messageDigest.clone();
            messageDigest.update((byte)97);
            MessageDigest messageDigest3 = (MessageDigest)messageDigest.clone();
            messageDigest.update((byte)97);
            messageDigest2.update((byte)97);
            messageDigest2.update((byte)97);
            messageDigest3.update((byte)97);
            byte[] byArray = messageDigest.digest();
            byte[] byArray2 = messageDigest2.digest();
            byte[] byArray3 = messageDigest3.digest();
            if (!Util.areEqual(byArray, byArray2) || !Util.areEqual(byArray, byArray3)) {
                bl = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        this.passIf(bl);
    }

    protected void testExistence(String string) throws Exception {
        this.beginTest("Algorithm available as " + string);
        boolean bl = true;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string, "CryptixCrypto");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        this.passIf(bl);
    }

    protected void testLargeString(String string, byte by, int n, String string2) throws Exception {
        this.beginTest("Test Values (Large String)");
        boolean bl = true;
        try {
            byte[] byArray = Util.hexFromString(string2);
            MessageDigest messageDigest = MessageDigest.getInstance(string, "CryptixCrypto");
            int n2 = 0;
            while (n2 < n) {
                messageDigest.update(by);
                ++n2;
            }
            byte[] byArray2 = messageDigest.digest();
            if (!Util.areEqual(byArray2, byArray)) {
                bl = false;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            bl = false;
        }
        this.passIf(bl);
    }

    protected void testValues(String string, String[][] stringArray) throws Exception {
        this.beginTest("Test Values");
        boolean bl = true;
        try {
            int n = 0;
            while (n < stringArray.length) {
                byte[] byArray = stringArray[n][0].getBytes();
                byte[] byArray2 = Util.hexFromString(stringArray[n][1]);
                MessageDigest messageDigest = MessageDigest.getInstance(string, "CryptixCrypto");
                byte[] byArray3 = messageDigest.digest(byArray);
                if (!Util.areEqual(byArray3, byArray2)) {
                    bl = false;
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            bl = false;
        }
        this.passIf(bl);
    }
}

