/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.rsa;

import cryptix.jce.provider.asn.AsnBitString;
import cryptix.jce.provider.asn.AsnInteger;
import cryptix.jce.provider.asn.AsnObject;
import cryptix.jce.provider.asn.AsnObjectId;
import cryptix.jce.provider.asn.AsnOutputStream;
import cryptix.jce.provider.asn.AsnSequence;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;

final class RSAPublicKeyX509
implements RSAPublicKey {
    private final BigInteger n;
    private final BigInteger e;

    RSAPublicKeyX509(BigInteger bigInteger, BigInteger bigInteger2) {
        this.n = bigInteger;
        this.e = bigInteger2;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public byte[] getEncoded() {
        byte[] byArray;
        AsnObject[] asnObjectArray;
        Object object;
        AsnObject[] asnObjectArray2 = new AsnObject[]{new AsnInteger(this.n), new AsnInteger(this.e)};
        try {
            object = new ByteArrayOutputStream();
            asnObjectArray = new AsnOutputStream((OutputStream)object);
            asnObjectArray.write(new AsnSequence(asnObjectArray2));
            asnObjectArray.flush();
            asnObjectArray.close();
            byArray = ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("PANIC");
        }
        object = new AsnBitString(byArray);
        asnObjectArray = new AsnObject[]{AsnObjectId.OID_rsaEncryption};
        AsnSequence asnSequence = new AsnSequence(asnObjectArray);
        AsnObject[] asnObjectArray3 = new AsnObject[]{asnSequence, object};
        AsnSequence asnSequence2 = new AsnSequence(asnObjectArray3);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            AsnOutputStream asnOutputStream = new AsnOutputStream(byteArrayOutputStream);
            asnOutputStream.write(asnSequence2);
            asnOutputStream.flush();
            asnOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("PANIC");
        }
    }

    public String getFormat() {
        return "X.509";
    }

    public BigInteger getModulus() {
        return this.n;
    }

    public BigInteger getPublicExponent() {
        return this.e;
    }
}

