/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.rsa;

import cryptix.jce.provider.rsa.RSAAlgorithm;
import cryptix.jce.provider.rsa.RSAPrivateCrtKeyCryptix;
import cryptix.jce.provider.rsa.RSAPublicKeyCryptix;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public final class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger F4 = BigInteger.valueOf(65537L);
    private static final int KEYSIZE_MIN = 384;
    private static final int KEYSIZE_DEFAULT = 3072;
    private static final int KEYSIZE_MAX = 16384;
    private static final int CERTAINTY = 80;
    private int keysize;
    private BigInteger publicExponent;
    private SecureRandom random;
    private boolean initialized = false;

    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5;
        BigInteger bigInteger6;
        if (!this.initialized) {
            this.initialize();
        }
        int n = this.keysize / 2;
        int n2 = this.keysize - n;
        BigInteger bigInteger7 = this.publicExponent;
        while (true) {
            try {
                do {
                    bigInteger6 = new BigInteger(n, 80, this.random);
                    bigInteger5 = new BigInteger(n2, 80, this.random);
                    bigInteger4 = bigInteger6.multiply(bigInteger5);
                } while (bigInteger6.compareTo(bigInteger5) == 0 || bigInteger4.bitLength() != this.keysize);
                bigInteger3 = bigInteger6.subtract(ONE);
                bigInteger2 = bigInteger5.subtract(ONE);
                BigInteger bigInteger8 = bigInteger3.multiply(bigInteger2);
                bigInteger = bigInteger7.modInverse(bigInteger8);
            }
            catch (ArithmeticException arithmeticException) {
                continue;
            }
            break;
        }
        BigInteger bigInteger9 = bigInteger.mod(bigInteger3);
        BigInteger bigInteger10 = bigInteger.mod(bigInteger2);
        BigInteger bigInteger11 = bigInteger5.modInverse(bigInteger6);
        BigInteger bigInteger12 = new BigInteger(n, this.random);
        BigInteger bigInteger13 = RSAAlgorithm.rsa(bigInteger12, bigInteger4, bigInteger7);
        BigInteger bigInteger14 = RSAAlgorithm.rsa(bigInteger13, bigInteger4, bigInteger, bigInteger6, bigInteger5, bigInteger9, bigInteger10, bigInteger11);
        if (!bigInteger14.equals(bigInteger12)) {
            throw new RuntimeException("RSA KeyPair doesn't work");
        }
        RSAPrivateCrtKeyCryptix rSAPrivateCrtKeyCryptix = new RSAPrivateCrtKeyCryptix(bigInteger4, bigInteger7, bigInteger, bigInteger6, bigInteger5, bigInteger9, bigInteger10, bigInteger11);
        RSAPublicKeyCryptix rSAPublicKeyCryptix = new RSAPublicKeyCryptix(bigInteger4, bigInteger7);
        return new KeyPair(rSAPublicKeyCryptix, rSAPrivateCrtKeyCryptix);
    }

    private void initialize() {
        this.initialize(3072, new SecureRandom());
    }

    public void initialize(int n, SecureRandom secureRandom) {
        if (n < 384 || n > 16384) {
            throw new IllegalArgumentException("keysize: invalid size (" + n + ")");
        }
        this.keysize = n;
        this.random = secureRandom;
        this.publicExponent = F4;
        this.initialized = true;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new RuntimeException("NYI");
    }
}

