/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.rsa;

import cryptix.jce.provider.rsa.RSAAlgorithm;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public final class RSACipher_ECB_PKCS1
extends CipherSpi {
    private BigInteger n;
    private BigInteger e;
    private BigInteger p;
    private BigInteger q;
    private BigInteger u;
    private boolean decrypt;

    protected final byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        int n3;
        byte[] byArray2 = new byte[this.engineGetOutputSize(n2)];
        try {
            n3 = this.engineDoFinal(byArray, n, n2, byArray2, 0);
            if (n3 == byArray2.length) {
                return byArray2;
            }
        }
        catch (ShortBufferException shortBufferException) {
            throw new RuntimeException("PANIC: Should not happned!");
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        return byArray3;
    }

    protected final int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (byArray2.length < this.engineGetOutputSize(n2)) {
            throw new ShortBufferException("Output buffer too small!");
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, n, byArray3, 0, n2);
        if (this.decrypt) {
            BigInteger bigInteger = new BigInteger(1, byArray3);
            if (bigInteger.compareTo(this.n) != -1) {
                throw new RuntimeException("TT");
            }
            BigInteger bigInteger2 = RSAAlgorithm.rsa(bigInteger, this.n, this.e, this.p, this.q, this.u);
            byte[] byArray4 = bigInteger2.toByteArray();
            return this.unpad(byArray4, byArray4.length, 0, byArray2, n3);
        }
        BigInteger bigInteger = new BigInteger(1, this.pad(byArray3, byArray3.length, 0, 2));
        if (bigInteger.compareTo(this.n) != -1) {
            throw new RuntimeException("TT");
        }
        BigInteger bigInteger3 = RSAAlgorithm.rsa(bigInteger, this.n, this.e);
        if (bigInteger3.compareTo(this.n) != -1) {
            throw new RuntimeException("TT");
        }
        int n4 = this.engineGetBlockSize();
        byte[] byArray5 = bigInteger3.toByteArray();
        if (byArray5.length - 1 > n4) {
            throw new RuntimeException("YY");
        }
        if (byArray5.length > n4) {
            byte[] byArray6 = new byte[n4];
            System.arraycopy(byArray5, 1, byArray6, 0, n4);
            byArray5 = byArray6;
        }
        int n5 = 0;
        while (n5 < n4) {
            byArray2[n3 + n5] = 0;
            ++n5;
        }
        int n6 = n4 - byArray5.length;
        System.arraycopy(byArray5, 0, byArray2, n3 + n6, byArray5.length);
        return byArray5.length + n6;
    }

    protected final int engineGetBlockSize() {
        return (this.n.bitLength() + 7) / 8;
    }

    protected final byte[] engineGetIV() {
        return null;
    }

    protected final int engineGetOutputSize(int n) {
        return n < this.engineGetBlockSize() + 1 ? this.engineGetBlockSize() + 1 : n;
    }

    protected final AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected final void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("This cipher do not support AlgorithmParameters");
    }

    protected final void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof RSAPrivateKey) && !(key instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Key must be instance of either RSAPublicKey or RSAPrivateKey!");
        }
        boolean bl = this.decrypt = n == 2 || n == 6;
        if (this.decrypt) {
            this.n = ((RSAPrivateKey)key).getModulus();
            this.e = ((RSAPrivateKey)key).getPrivateExponent();
        } else {
            this.n = ((RSAPublicKey)key).getModulus();
            this.e = ((RSAPublicKey)key).getPublicExponent();
        }
        if (key instanceof RSAPrivateCrtKey) {
            this.p = ((RSAPrivateCrtKey)key).getPrimeP();
            this.q = ((RSAPrivateCrtKey)key).getPrimeQ();
            this.u = ((RSAPrivateCrtKey)key).getCrtCoefficient();
        } else {
            this.u = null;
            this.q = null;
            this.p = null;
        }
    }

    protected final void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("This cipher do not support AlgorithmParameterSpecs");
    }

    protected final void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!string.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("Wrong mode type!");
        }
    }

    protected final void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!(string.equalsIgnoreCase("PKCS1") || string.equalsIgnoreCase("PKCS#1") || string.equalsIgnoreCase("PKCS1Padding"))) {
            throw new NoSuchPaddingException("Wrong padding scheme!");
        }
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        if (n != 5) {
            throw new InvalidKeyException("Wrong keytype!");
        }
        try {
            KeyGenerator.getInstance(string, "Cryptix");
            byte[] byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, 0, byArray2.length, string);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string);
            return secretKeyFactory.generateSecret(secretKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("Algorithm not supported!");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException("PANIC: Should not happend!");
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException("PANIC: This should not happend!");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new RuntimeException("PANIC: This should not happend!");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new RuntimeException("PANIC: This should not happend!");
        }
    }

    protected final byte[] engineUpdate(byte[] byArray, int n, int n2) {
        throw new RuntimeException("You can't do an update when using PKCS1!");
    }

    protected final int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        throw new RuntimeException("You can't do an update when using PKCS1!");
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        String string = key.getFormat();
        if (string == null || !string.equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Wrong format on key!");
        }
        byte[] byArray = key.getEncoded();
        try {
            return this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException("PANIC: This should not happend!");
        }
    }

    private byte[] pad(byte[] byArray, int n, int n2, int n3) throws BadPaddingException {
        int n4 = (this.n.bitLength() + 7) / 8;
        if (n > n4 - 11) {
            throw new BadPaddingException("Data to long for this modulus!");
        }
        byte[] byArray2 = new byte[n4];
        int n5 = n4 - 3 - n;
        byArray2[2 + n5] = 0;
        byArray2[0] = 0;
        switch (n3) {
            case 0: {
                int n6 = 1;
                while (n6 < 2 + n5) {
                    byArray2[n6] = 0;
                    ++n6;
                }
                break;
            }
            case 1: {
                byArray2[1] = 1;
                int n7 = 2;
                while (n7 < 2 + n5) {
                    byArray2[n7] = -1;
                    ++n7;
                }
                break;
            }
            case 2: {
                byArray2[1] = 2;
                byte[] byArray3 = new byte[1];
                SecureRandom secureRandom = new SecureRandom();
                int n8 = 2;
                while (n8 < 2 + n5) {
                    byArray3[0] = 0;
                    while (byArray3[0] == 0) {
                        secureRandom.nextBytes(byArray3);
                    }
                    byArray2[n8] = byArray3[0];
                    ++n8;
                }
                break;
            }
            default: {
                throw new BadPaddingException("Wrong block type!");
            }
        }
        System.arraycopy(byArray, n2, byArray2, n5 + 3, n);
        return byArray2;
    }

    private int unpad(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws BadPaddingException {
        byte by = byArray[n2];
        int n4 = 1;
        switch (by) {
            case 0: {
                while (byArray[n2 + n4 + 1] == 0) {
                    ++n4;
                }
                break;
            }
            case 1: 
            case 2: {
                while (byArray[n2 + n4] != 0) {
                    ++n4;
                }
                break;
            }
            default: {
                throw new BadPaddingException("Wrong block type!");
            }
        }
        int n5 = n - n2 - ++n4;
        System.arraycopy(byArray, n2 + n4, byArray2, n3, n5);
        return n5;
    }
}

