/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.key;

import cryptix.jce.provider.key.RawSecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

abstract class RawKeyGenerator
extends KeyGeneratorSpi {
    private final String algorithm;
    private final int defaultKeySize;
    private SecureRandom random = null;
    private int keySize = 0;

    protected RawKeyGenerator(String string, int n) {
        this.algorithm = string;
        this.defaultKeySize = n;
    }

    protected SecretKey engineGenerateKey() {
        if (this.random == null) {
            throw new IllegalStateException("KeyGenerator not initialized.");
        }
        byte[] byArray = new byte[(this.strengthToBits(this.keySize) + 7) / 8];
        do {
            this.random.nextBytes(byArray);
        } while (this.isWeak(byArray = this.fixUp(byArray)));
        return new RawSecretKey(this.algorithm, byArray);
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        if (!this.isValidSize(n)) {
            throw new InvalidParameterException("Key size not supported [" + n + "]");
        }
        this.random = secureRandom;
        this.keySize = n;
    }

    protected void engineInit(SecureRandom secureRandom) {
        this.random = secureRandom;
        this.keySize = this.defaultKeySize;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("No AlgorithmParameterSpec supported.");
    }

    protected byte[] fixUp(byte[] byArray) {
        return byArray;
    }

    protected abstract boolean isValidSize(int var1);

    protected abstract boolean isWeak(byte[] var1);

    protected int strengthToBits(int n) {
        return n;
    }
}

