/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.elgamal;

import cryptix.jce.ElGamalParams;
import cryptix.jce.ElGamalPublicKey;
import cryptix.jce.util.MPIOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

final class ElGamalPublicKeyCryptix
implements ElGamalPublicKey {
    private final BigInteger y;
    private final ElGamalParams params;

    ElGamalPublicKeyCryptix(BigInteger bigInteger, ElGamalParams elGamalParams) {
        this.y = bigInteger;
        this.params = elGamalParams;
    }

    public String getAlgorithm() {
        return "ElGamal";
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            MPIOutputStream mPIOutputStream = new MPIOutputStream((OutputStream)byteArrayOutputStream);
            mPIOutputStream.write(this.params.getP());
            mPIOutputStream.write(this.params.getQ());
            mPIOutputStream.write(this.params.getG());
            mPIOutputStream.write(this.y);
            mPIOutputStream.flush();
            mPIOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("PANIC");
        }
    }

    public String getFormat() {
        return "Cryptix";
    }

    public ElGamalParams getParams() {
        return this.params;
    }

    public BigInteger getY() {
        return this.y;
    }
}

