/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import cryptix.jce.provider.cipher.DES;
import cryptix.jce.provider.key.RawSecretKey;
import java.security.InvalidKeyException;
import java.security.Key;

public final class TripleDES
extends BlockCipher {
    private static final int BLOCK_SIZE = 8;
    private static final int KEY_LENGTH = 24;
    private static final int ALT_KEY_LENGTH = 21;
    private static final int DES_KEY_LENGTH = 8;
    private DES des1 = new DES();
    private DES des2 = new DES();
    private DES des3 = new DES();

    public TripleDES() {
        super(8);
    }

    protected void coreCrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.des1.coreCrypt(byArray, n, byArray2, n2);
        this.des2.coreCrypt(byArray2, n2, byArray2, n2);
        this.des3.coreCrypt(byArray2, n2, byArray2, n2);
    }

    protected void coreInit(Key key, boolean bl) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Null user key");
        }
        int n = 0;
        if (byArray.length == 24) {
            n = 8;
        } else if (byArray.length == 21) {
            n = 7;
        } else {
            throw new InvalidKeyException("Invalid user key length");
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        RawSecretKey rawSecretKey = new RawSecretKey("DES", byArray2);
        this.des1.coreInit(rawSecretKey, bl);
        System.arraycopy(byArray, n, byArray2, 0, n);
        rawSecretKey = new RawSecretKey("DES", byArray2);
        this.des2.coreInit(rawSecretKey, bl ^ true);
        System.arraycopy(byArray, n + n, byArray2, 0, n);
        rawSecretKey = new RawSecretKey("DES", byArray2);
        this.des3.coreInit(rawSecretKey, bl);
        if (bl) {
            DES dES = this.des1;
            this.des1 = this.des3;
            this.des3 = dES;
        }
    }
}

