/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import java.security.InvalidKeyException;
import java.security.Key;

public final class Square
extends BlockCipher {
    private static final int BLOCK_SIZE = 16;
    private static final int KEY_LENGTH = 10;
    private static final int R = 8;
    private static final byte[] SE;
    private static final byte[] SD;
    private static final int[] TE;
    private static final int[] TD;
    private static final int ROOT = 501;
    private static final int[] OFFSET;
    private int[][] sKey = new int[9][4];
    private boolean decrypt;

    static {
        int n;
        SE = new byte[256];
        SD = new byte[256];
        TE = new int[256];
        TD = new int[256];
        OFFSET = new int[8];
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byArray[0] = 1;
        int n2 = 1;
        while (n2 < 256) {
            n = byArray[n2 - 1] << 1;
            if ((n & 0x100) != 0) {
                n ^= 0x1F5;
            }
            byArray[n2] = (byte)n;
            byArray2[n & 0xFF] = (byte)n2;
            ++n2;
        }
        Square.SE[0] = 0;
        Square.SE[1] = 1;
        n2 = 2;
        while (n2 < 256) {
            Square.SE[n2] = byArray[255 - byArray2[n2] & 0xFF];
            ++n2;
        }
        int[] nArray = new int[]{1, 3, 5, 15, 31, 61, 123, 214};
        n2 = 0;
        while (n2 < 256) {
            int n3 = 177;
            n = 0;
            while (n < 8) {
                int n4 = SE[n2] & nArray[n] & 0xFF;
                n4 ^= n4 >>> 4;
                n4 ^= n4 >>> 2;
                n4 ^= n4 >>> 1;
                n3 ^= (n4 &= 1) << n;
                ++n;
            }
            Square.SE[n2] = (byte)n3;
            Square.SD[n3] = (byte)n2;
            ++n2;
        }
        Square.OFFSET[0] = 1;
        n2 = 1;
        while (n2 < 8) {
            Square.OFFSET[n2] = Square.mul(OFFSET[n2 - 1], 2);
            int n5 = n2 - 1;
            OFFSET[n5] = OFFSET[n5] << 24;
            ++n2;
        }
        OFFSET[7] = OFFSET[7] << 24;
        n2 = 0;
        while (n2 < 256) {
            int n6 = SE[n2] & 0xFF;
            int n7 = SD[n2] & 0xFF;
            Square.TE[n2] = SE[n2 & 3] == 0 ? 0 : Square.mul(n6, 2) << 24 | n6 << 16 | n6 << 8 | Square.mul(n6, 3);
            Square.TD[n2] = SD[n2 & 3] == 0 ? 0 : Square.mul(n7, 14) << 24 | Square.mul(n7, 9) << 16 | Square.mul(n7, 13) << 8 | Square.mul(n7, 11);
            ++n2;
        }
    }

    public Square() {
        super(16);
    }

    protected void coreCrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this.decrypt) {
            this.square(byArray, n, byArray2, n2, TD, SD);
        } else {
            this.square(byArray, n, byArray2, n2, TE, SE);
        }
    }

    protected void coreInit(Key key, boolean bl) throws InvalidKeyException {
        this.makeKey(key, bl ^ true);
        this.decrypt = bl;
    }

    private void makeKey(Key key, boolean bl) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Null user key");
        }
        if (byArray.length != 16) {
            throw new InvalidKeyException("Invalid user key length");
        }
        int n = 0;
        if (bl) {
            int n2 = 0;
            while (n2 < 4) {
                this.sKey[0][n2] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                ++n2;
            }
            n2 = 1;
            while (n2 < 9) {
                n = n2 - 1;
                this.sKey[n2][0] = this.sKey[n][0] ^ Square.rot32L(this.sKey[n][3], 8) ^ OFFSET[n];
                this.sKey[n2][1] = this.sKey[n][1] ^ this.sKey[n2][0];
                this.sKey[n2][2] = this.sKey[n][2] ^ this.sKey[n2][1];
                this.sKey[n2][3] = this.sKey[n][3] ^ this.sKey[n2][2];
                Square.transform(this.sKey[n], this.sKey[n]);
                ++n2;
            }
        } else {
            int[][] nArray = new int[9][4];
            int n3 = 0;
            while (n3 < 4) {
                nArray[0][n3] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                ++n3;
            }
            n3 = 1;
            while (n3 < 9) {
                n = n3 - 1;
                nArray[n3][0] = nArray[n][0] ^ Square.rot32L(nArray[n][3], 8) ^ OFFSET[n];
                nArray[n3][1] = nArray[n][1] ^ nArray[n3][0];
                nArray[n3][2] = nArray[n][2] ^ nArray[n3][1];
                nArray[n3][3] = nArray[n][3] ^ nArray[n3][2];
                ++n3;
            }
            n3 = 0;
            while (n3 < 8) {
                System.arraycopy(nArray[8 - n3], 0, this.sKey[n3], 0, 4);
                ++n3;
            }
            Square.transform(nArray[0], this.sKey[8]);
        }
    }

    private static final int mul(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        n &= 0xFF;
        n2 &= 0xFF;
        int n3 = 0;
        while (n2 != 0) {
            if ((n2 & 1) != 0) {
                n3 ^= n;
            }
            if ((n <<= 1) > 255) {
                n ^= 0x1F5;
            }
            n2 >>>= 1;
        }
        return n3 & 0xFF;
    }

    private static int rot32L(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    private static int rot32R(int n, int n2) {
        return n >>> n2 | n << 32 - n2;
    }

    private void square(byte[] byArray, int n, byte[] byArray2, int n2, int[] nArray, byte[] byArray3) {
        int n3 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        int n4 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        int n5 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        int n6 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        n3 ^= this.sKey[0][0];
        n4 ^= this.sKey[0][1];
        n5 ^= this.sKey[0][2];
        n6 ^= this.sKey[0][3];
        int n7 = 1;
        while (n7 < 8) {
            int n8 = nArray[n3 >>> 24 & 0xFF] ^ Square.rot32R(nArray[n4 >>> 24 & 0xFF], 8) ^ Square.rot32R(nArray[n5 >>> 24 & 0xFF], 16) ^ Square.rot32R(nArray[n6 >>> 24 & 0xFF], 24) ^ this.sKey[n7][0];
            int n9 = nArray[n3 >>> 16 & 0xFF] ^ Square.rot32R(nArray[n4 >>> 16 & 0xFF], 8) ^ Square.rot32R(nArray[n5 >>> 16 & 0xFF], 16) ^ Square.rot32R(nArray[n6 >>> 16 & 0xFF], 24) ^ this.sKey[n7][1];
            int n10 = nArray[n3 >>> 8 & 0xFF] ^ Square.rot32R(nArray[n4 >>> 8 & 0xFF], 8) ^ Square.rot32R(nArray[n5 >>> 8 & 0xFF], 16) ^ Square.rot32R(nArray[n6 >>> 8 & 0xFF], 24) ^ this.sKey[n7][2];
            int n11 = nArray[n3 & 0xFF] ^ Square.rot32R(nArray[n4 & 0xFF], 8) ^ Square.rot32R(nArray[n5 & 0xFF], 16) ^ Square.rot32R(nArray[n6 & 0xFF], 24) ^ this.sKey[n7][3];
            n3 = n8;
            n4 = n9;
            n5 = n10;
            n6 = n11;
            ++n7;
        }
        n7 = 0;
        int n12 = 24;
        while (n7 < 4) {
            int n13 = (byArray3[n3 >>> n12 & 0xFF] & 0xFF) << 24 | (byArray3[n4 >>> n12 & 0xFF] & 0xFF) << 16 | (byArray3[n5 >>> n12 & 0xFF] & 0xFF) << 8 | byArray3[n6 >>> n12 & 0xFF] & 0xFF;
            byArray2[n2++] = (byte)((n13 ^= this.sKey[8][n7]) >>> 24 & 0xFF);
            byArray2[n2++] = (byte)(n13 >>> 16 & 0xFF);
            byArray2[n2++] = (byte)(n13 >>> 8 & 0xFF);
            byArray2[n2++] = (byte)(n13 & 0xFF);
            ++n7;
            n12 -= 8;
        }
    }

    private static void transform(int[] nArray, int[] nArray2) {
        int n = 0;
        while (n < 4) {
            int n2 = nArray[n];
            int n3 = n2 >>> 8;
            int n4 = n2 >>> 16;
            int n5 = n2 >>> 24;
            int n6 = ((Square.mul(n5, 2) ^ Square.mul(n4, 3) ^ n3 ^ n2) & 0xFF) << 24;
            n6 ^= ((n5 ^ Square.mul(n4, 2) ^ Square.mul(n3, 3) ^ n2) & 0xFF) << 16;
            n6 ^= ((n5 ^ n4 ^ Square.mul(n3, 2) ^ Square.mul(n2, 3)) & 0xFF) << 8;
            nArray2[n] = n6 ^= (Square.mul(n5, 3) ^ n4 ^ n3 ^ Square.mul(n2, 2)) & 0xFF;
            ++n;
        }
    }
}

