/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import cryptix.jce.provider.cipher.Mode;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

class ModeCFB
extends Mode {
    private final byte[] keyStreamBuf;
    private int keyStreamPtr;
    private final byte[] shiftReg;
    private int shiftRegPtr;
    protected long byteCount;
    private int feedbackSize;
    private boolean decrypt;
    private byte[] iVec = null;

    ModeCFB(BlockCipher blockCipher) {
        super(blockCipher);
        this.keyStreamBuf = new byte[this.CIPHER_BLOCK_SIZE];
        this.shiftReg = new byte[this.CIPHER_BLOCK_SIZE];
        this.feedbackSize = this.CIPHER_BLOCK_SIZE;
    }

    ModeCFB(BlockCipher blockCipher, int n) throws NoSuchAlgorithmException {
        super(blockCipher);
        if (n == 0 || n % 8 != 0) {
            throw new NoSuchAlgorithmException("Feedback size is 0 or not a multiple of 8 bits.");
        }
        if ((n /= 8) < 1 || n > this.CIPHER_BLOCK_SIZE) {
            throw new NoSuchAlgorithmException("Feedback size <1 or >CIPHER_BLOCK_SIZE");
        }
        this.keyStreamBuf = new byte[this.CIPHER_BLOCK_SIZE];
        this.shiftReg = new byte[this.CIPHER_BLOCK_SIZE];
        this.feedbackSize = n;
    }

    final byte[] coreGetIV() {
        return this.iVec;
    }

    final int coreGetOutputSize(int n) {
        return n;
    }

    final AlgorithmParameterSpec coreGetParamSpec() {
        if (this.iVec == null) {
            return new IvParameterSpec(this.generateIV());
        }
        return new IvParameterSpec(this.iVec);
    }

    void coreInit(boolean bl, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipher.coreInit(key, false);
        this.decrypt = bl;
        IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
        this.iVec = ivParameterSpec.getIV();
        int n = this.iVec.length;
        if (n != this.CIPHER_BLOCK_SIZE) {
            throw new InvalidAlgorithmParameterException("Invalid IV specified, incorrect length.");
        }
        this.byteCount = 0L;
        System.arraycopy(this.iVec, 0, this.shiftReg, 0, n);
        this.crank();
    }

    int coreUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n2;
        while (n4-- > 0) {
            byte by = this.keyStreamBuf[this.keyStreamPtr++];
            byte by2 = byArray[n++];
            byte by3 = (byte)(by2 ^ by);
            this.shiftInByte(this.decrypt ? by2 : by3);
            byArray2[n3++] = by3;
        }
        return n2;
    }

    private void crank() {
        int n = 0;
        while (n < this.CIPHER_BLOCK_SIZE) {
            this.keyStreamBuf[n] = this.shiftReg[this.shiftRegPtr++ % this.CIPHER_BLOCK_SIZE];
            ++n;
        }
        this.cipher.coreCrypt(this.keyStreamBuf, 0, this.keyStreamBuf, 0);
        this.keyStreamPtr = 0;
    }

    protected boolean needCrank() {
        return this.byteCount % (long)this.feedbackSize == 0L;
    }

    final boolean needsPadding() {
        return false;
    }

    private void shiftInByte(byte by) {
        this.shiftReg[this.shiftRegPtr++ % this.CIPHER_BLOCK_SIZE] = by;
        ++this.byteCount;
        if (this.needCrank()) {
            this.crank();
        }
    }
}

