/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import cryptix.jce.provider.cipher.ModeCBC;
import cryptix.jce.provider.cipher.ModeCFB;
import cryptix.jce.provider.cipher.ModeECB;
import cryptix.jce.provider.cipher.ModeOFB;
import cryptix.jce.provider.cipher.ModeOpenpgpCFB;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

abstract class Mode {
    protected final BlockCipher cipher;
    protected final int CIPHER_BLOCK_SIZE;
    protected boolean decrypt;
    protected int bufCount;

    Mode(BlockCipher blockCipher) {
        this.cipher = blockCipher;
        this.CIPHER_BLOCK_SIZE = blockCipher.coreGetBlockSize();
    }

    abstract byte[] coreGetIV();

    abstract int coreGetOutputSize(int var1);

    abstract AlgorithmParameterSpec coreGetParamSpec();

    abstract void coreInit(boolean var1, Key var2, AlgorithmParameterSpec var3, SecureRandom var4) throws InvalidKeyException, InvalidAlgorithmParameterException;

    abstract int coreUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5);

    protected byte[] generateIV() {
        byte[] byArray = new byte[this.CIPHER_BLOCK_SIZE];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    final int getBlockSize() {
        return this.CIPHER_BLOCK_SIZE;
    }

    final int getBufSize() {
        return this.bufCount;
    }

    final byte[] getIV() {
        return this.coreGetIV();
    }

    static Mode getInstance(String string, BlockCipher blockCipher) throws NoSuchAlgorithmException {
        try {
            if (string.equalsIgnoreCase("CBC")) {
                return new ModeCBC(blockCipher);
            }
            if (string.substring(0, 3).equalsIgnoreCase("CFB")) {
                String string2 = string.substring(3, string.length());
                if (string2.length() > 0) {
                    return new ModeCFB(blockCipher, Integer.parseInt(string2));
                }
                return new ModeCFB(blockCipher);
            }
            if (string.equalsIgnoreCase("ECB")) {
                return new ModeECB(blockCipher);
            }
            if (string.equalsIgnoreCase("OFB")) {
                return new ModeOFB(blockCipher);
            }
            if (string.equalsIgnoreCase("openpgpCFB")) {
                return new ModeOpenpgpCFB(blockCipher);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        throw new NoSuchAlgorithmException("Mode (" + string + ") not available.");
    }

    final int getOutputSize(int n) {
        return this.coreGetOutputSize(n);
    }

    final AlgorithmParameterSpec getParamSpec() {
        return this.coreGetParamSpec();
    }

    void init(boolean bl, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.decrypt = bl;
        this.coreInit(bl, key, algorithmParameterSpec, secureRandom);
    }

    abstract boolean needsPadding();

    final int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        return this.coreUpdate(byArray, n, n2, byArray2, n3);
    }
}

