/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.asn;

import cryptix.jce.provider.asn.AsnObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class AsnOutputStream {
    private final OutputStream os;

    public AsnOutputStream() {
        this.os = new ByteArrayOutputStream();
    }

    public AsnOutputStream(OutputStream outputStream) {
        this.os = outputStream;
    }

    public void close() throws IOException {
        this.os.flush();
        this.os.close();
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    int getLengthOfLength(int n) {
        if (n <= 127) {
            return 1;
        }
        if (n <= 255) {
            return 2;
        }
        if (n <= 65535) {
            return 3;
        }
        if (n <= 0xFFFFFF) {
            return 4;
        }
        return 5;
    }

    public byte[] toByteArray() {
        if (!(this.os instanceof ByteArrayOutputStream)) {
            throw new IllegalStateException("Underlying stream is not instanceof ByteArrayOutputStream.");
        }
        ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.os;
        return byteArrayOutputStream.toByteArray();
    }

    public void write(AsnObject asnObject) throws IOException {
        asnObject.encode(this);
    }

    void writeByte(byte by) throws IOException {
        this.os.write(by & 0xFF);
    }

    void writeBytes(byte[] byArray) throws IOException {
        this.os.write(byArray);
    }

    void writeLength(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("len: < 0");
        }
        if (n <= 127) {
            this.os.write((char)n);
            return;
        }
        int n2 = this.getLengthOfLength(n) - 1;
        this.os.write((byte)(n2 | 0x80));
        while (n2-- > 0) {
            this.os.write((byte)(n >>> n2 * 8));
        }
    }

    void writeType(byte by) throws IOException {
        this.os.write(by);
    }
}

