/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.asn;

import cryptix.jce.provider.asn.AsnBitString;
import cryptix.jce.provider.asn.AsnInteger;
import cryptix.jce.provider.asn.AsnNull;
import cryptix.jce.provider.asn.AsnObject;
import cryptix.jce.provider.asn.AsnObjectId;
import cryptix.jce.provider.asn.AsnSequence;
import cryptix.jce.provider.asn.AsnUnknown;
import cryptix.jce.provider.asn.SubInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class AsnInputStream {
    private final InputStream is;

    public AsnInputStream(InputStream inputStream) {
        this.is = inputStream;
    }

    public AsnInputStream(byte[] byArray) {
        this.is = new ByteArrayInputStream(byArray);
    }

    public int available() throws IOException {
        return this.is.available();
    }

    AsnInputStream getSubStream(int n) {
        return new AsnInputStream(new SubInputStream(this.is, n));
    }

    public AsnObject read() throws IOException {
        int n = this.is.read();
        if (n == -1) {
            throw new IOException("End of stream.");
        }
        byte by = (byte)n;
        switch (by) {
            case 6: {
                return new AsnObjectId(this);
            }
            case 3: {
                return new AsnBitString(this);
            }
            case 2: {
                return new AsnInteger(this);
            }
            case 5: {
                return new AsnNull(this);
            }
            case 48: {
                return new AsnSequence(this);
            }
        }
        return new AsnUnknown(by, this);
    }

    byte readByte() throws IOException {
        return this.readBytes(1)[0];
    }

    byte[] readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n > 0) {
            int n3 = this.is.read(byArray, n2, n);
            if (n3 == -1) {
                throw new IOException("EOF");
            }
            n -= n3;
            n2 += n3;
        }
        return byArray;
    }

    int readLength() throws IOException {
        int n = this.is.read();
        if (n == -1) {
            throw new IOException("Unexpected end of stream.");
        }
        if (n <= 127) {
            return n;
        }
        if ((n &= 0x7F) > 4) {
            throw new IOException("Length too big.");
        }
        int n2 = 0;
        while (n-- > 0) {
            int n3 = this.is.read();
            if (n3 == -1) {
                throw new IOException("Unexpected end of stream.");
            }
            n2 = n2 << 8 | n3;
        }
        if (n2 < 0) {
            throw new IOException("Negative length.");
        }
        return n2;
    }
}

