/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Properties;

public class AlgorithmParameters {
    private AlgorithmParametersSpi paramSpi = null;
    private Provider provider = null;
    private String algorithm = null;
    private boolean isInitialized = false;

    protected AlgorithmParameters(AlgorithmParametersSpi algorithmParametersSpi, Provider provider, String string) {
        this.paramSpi = algorithmParametersSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final byte[] getEncoded() throws IOException {
        if (!this.isInitialized) {
            throw new IOException();
        }
        return this.paramSpi.engineGetEncoded();
    }

    public final byte[] getEncoded(String string) throws IOException {
        if (!this.isInitialized) {
            throw new IOException();
        }
        return this.paramSpi.engineGetEncoded(string);
    }

    public static AlgorithmParameters getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        int n = 0;
        if (n < providerArray.length) {
            try {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(string, providerArray[n].getName());
                return algorithmParameters;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new NoSuchAlgorithmException();
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new NoSuchAlgorithmException();
            }
        }
        throw new NoSuchAlgorithmException();
    }

    public static AlgorithmParameters getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        AlgorithmParametersSpi algorithmParametersSpi = null;
        if (string2 == null || string2.length() == 0) {
            return AlgorithmParameters.getInstance(string);
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException();
        }
        String string3 = "AlgorithmParameters." + string;
        String string4 = ((Properties)provider).getProperty(string3);
        if (string4 == null) {
            throw new NoSuchAlgorithmException();
        }
        try {
            algorithmParametersSpi = (AlgorithmParametersSpi)Class.forName(string4).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new NoSuchAlgorithmException();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return new AlgorithmParameters(algorithmParametersSpi, provider, string);
    }

    public final AlgorithmParameterSpec getParameterSpec(Class clazz) throws InvalidParameterSpecException {
        return this.paramSpi.engineGetParameterSpec(clazz);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        this.paramSpi.engineInit(algorithmParameterSpec);
        this.isInitialized = true;
    }

    public final void init(byte[] byArray) throws IOException {
        this.paramSpi.engineInit(byArray);
        this.isInitialized = true;
    }

    public final void init(byte[] byArray, String string) throws IOException {
        this.paramSpi.engineInit(byArray, string);
        this.isInitialized = true;
    }

    public final String toString() {
        if (!this.isInitialized) {
            return null;
        }
        return this.paramSpi.engineToString();
    }
}

