/* $Id: Support.java,v 1.4 2000/01/15 03:25:04 gelderen Exp $
 *
 * Copyright (C) 1995-1999 The Cryptix Foundation Limited.
 * All rights reserved.
 * 
 * Use, modification, copying and distribution of this software is subject 
 * the terms and conditions of the Cryptix General Licence. You should have 
 * received a copy of the Cryptix General Licence along with this library; 
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package javax.crypto;


import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;


final class Support {
    
    static Object[] getImplementation(String type, String algorithm)
    throws NoSuchAlgorithmException { /*System.out.println("==> getImplementation(String type, String algorithm)");*/ try {
        
        Provider[] providers = Security.getProviders();
        if( (providers==null) || (providers.length==0) )
            throw new NoSuchAlgorithmException("No providers installed");
            
        for(int i=0; i<providers.length; i++) {
            Object[] res = getImplementation(type, algorithm, providers[i]);
            if(res != null)
                return res;
        }
        throw new NoSuchAlgorithmException("Algorithm not found. [" + type + "." + algorithm + "]");
    } finally { /*System.out.println("<== getImplementation(String type, String algorithm)");*/ } }


    static Object[] getImplementation(String type, String algorithm, String provider)
    throws NoSuchAlgorithmException, NoSuchProviderException {
        
        Provider p = Security.getProvider(provider);
        if(p==null)
            throw new NoSuchProviderException("Provider not found. [" + provider + "]");
            
        Object[] res = getImplementation(type, algorithm, p);
        if(res != null)
            return res;
            
        throw new NoSuchAlgorithmException("Algorithm not found. [" + type + "." + algorithm + "]");
    }

    
    static Object[] getImplementation(String algType, String algName, Provider p) { /*System.out.println("==> getImplementation(String algType, String algName, Provider p)");*/ try {
        
        //System.out.println("  Arguments: " + algType + ", " + algName + ", " + p);
        
        try {
            
            //System.out.println("  Trying: " + "Alg.Alias." + algType + "." + algName);
            String class_name = p.getProperty("Alg.Alias." + algType + "." + algName);
            
            if(class_name==null) {
                //System.out.println("  Failed: Trying: " + algType + "." + algName);
                class_name = p.getProperty(algType + "." + algName);
            } else {
                //System.out.println("  Succes: Trying: " + algType + "." + class_name);
                class_name = p.getProperty(algType + "." + class_name);
            }
            
            //System.out.println("  class_name = " + class_name);
            
            if(class_name == null)
                return null;    
            
            Object[] res = new Object[2];
            res[0] = Class.forName(class_name).newInstance();
            res[1] = p;       
            //System.out.println(" Returning: " + class_name);
            return res;
        } 
        catch(LinkageError e) {
            e.printStackTrace();
            // FIXME: Throw a RuntimeException with a sensible message????
        } 
        catch(ClassNotFoundException e) {
            e.printStackTrace();
            // FIXME: Throw a RuntimeException with a sensible message????
        } 
        catch(InstantiationException e) {
            e.printStackTrace();
            // FIXME: Throw a RuntimeException with a sensible message????
        } 
        catch(IllegalAccessException e) {
            e.printStackTrace();
            // FIXME: Throw a RuntimeException with a sensible message????
        }
    
        return null;        
        
    } finally { /*System.out.println("<== getImplementation(String algType, String algName, Provider p)");*/ } }
    
    
    static String getClassName(String algType, String algName, Provider p) {

            String class_name = p.getProperty("Alg.Alias." + algType + "." + algName);

            if(class_name==null)
                class_name = p.getProperty(algType + "." + algName);
            else
                class_name = p.getProperty(algType + "." + class_name);
                
            return class_name;
    }
    
    
/*    
    
    private static Object[] getCipherSpi(String transformation, Provider[] providers) 
    throws NoSuchAlgorithmException {
        
        for(int i=0; i<providers.length; i++) {
            
            CipherSpi spi = getCipherSpi(providers[i], transformation);
            if(spi == null)
                continue;
            
            Object[] res = new Object[2];
            res[0] = spi;
            res[1] = providers[i];       
            return res;
                             
        }
        throw new NoSuchAlgorithmException();
        
    }
    
    
    private static CipherSpi getCipherSpi(Provider p, String transformation) {
        
        //System.out.println("Trying: " + p + ", " + transformation);
        
        try {
            
            int index_1 = transformation.indexOf('/');
            int index_2 = transformation.indexOf('/', index_1+1);
            
            if(index_1==-1) {
                String s = p.getProperty("Cipher." + transformation);
                if(s==null)
                    return null;
                return (CipherSpi)Class.forName(s).newInstance();
            }
            
            if(index_2==-1) {
                throw new RuntimeException("Illegal transformation specified: " + transformation);
            }
        
            String part_alg  = transformation.substring(0, index_1);
            String part_mode = transformation.substring(index_1+1, index_2);
            String part_pad  = transformation.substring(index_2+1);
            
            System.out.println("Trying: " + part_alg + "/" + part_mode + "/" + part_pad);
            
            String    class_name;
            CipherSpi spi;
            
            class_name = p.getProperty("Cipher." + part_alg + "/" + part_mode + "/" + part_pad);
            if(class_name != null) {
                spi = (CipherSpi)Class.forName(class_name).newInstance();
                return spi;
            }
            
            class_name = p.getProperty("Cipher." + part_alg + "/" + part_mode);
            if(class_name != null) {
                spi = (CipherSpi)Class.forName(class_name).newInstance();
                spi.engineSetPadding(part_pad);
                return spi;
            }
            
            class_name = p.getProperty("Cipher." + part_alg + "//" + part_pad);
            if(class_name != null) {
                spi = (CipherSpi)Class.forName(class_name).newInstance();
                spi.engineSetMode(part_mode);
                return spi;
            }
            
            class_name = p.getProperty("Cipher." + part_alg);
            if(class_name != null) {
                spi = (CipherSpi)Class.forName(class_name).newInstance();
                System.out.println("Setting mode: [" + part_mode + "]");
                spi.engineSetMode(part_mode);
                System.out.println("Setting padding: [" + part_pad + "]");
                spi.engineSetPadding(part_pad);
                return spi;
            }
            
        } catch(Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Provider configuration error");
        }
        
        return null;
    }
*/    
}
