/* $Id: RC5ParameterSpec.java,v 1.4 2000/01/15 03:16:15 gelderen Exp $
 *
 * Copyright (C) 1995-1999 The Cryptix Foundation Limited.
 * All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package javax.crypto.spec;


import java.security.spec.AlgorithmParameterSpec;


/**
 * @version $Revision: 1.4 $
 * @author  Jeroen C. van Gelderen (gelderen@cryptix.org)
 */
public class RC5ParameterSpec
implements AlgorithmParameterSpec 
{
    private final int version;
    private final int rounds;
    private final int wordSize;
    private final byte[] iv;


    public RC5ParameterSpec(int version, int rounds, int wordSize) 
    {
        this.version  = version;
        this.rounds   = rounds;
        this.wordSize = wordSize;
        this.iv       = null;
    }


    public RC5ParameterSpec(int version, int rounds, int wordSize, byte[] iv) 
    {
        this.version  = version;
        this.rounds   = rounds;
        this.wordSize = wordSize;
        this.iv       = (byte[])iv.clone();
    }


    public RC5ParameterSpec(int version, int rounds, int wordSize,
                            byte[] iv, int offset)
    {
        this.version  = version;
        this.rounds   = rounds;
        this.wordSize = wordSize;

        this.iv = new byte[2*(wordSize/8)];
        System.arraycopy(iv, offset, this.iv, 0, this.iv.length);
    }


    public int getVersion() 
    {
        return this.version;
    }


    public int getRounds() 
    {
        return this.rounds;
    }


    public int getWordSize() 
    {
        return this.wordSize;
    }


    public byte[] getIV() 
    {
        return (byte[])this.iv.clone();
    }
}
