/* $Id: RC2ParameterSpec.java,v 1.4 2000/01/15 03:16:15 gelderen Exp $
 *
 * Copyright (C) 1995-1999 The Cryptix Foundation Limited.
 * All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package javax.crypto.spec;


import java.security.spec.AlgorithmParameterSpec;


/**
 * @version $Revision: 1.4 $
 * @author  Jeroen C. van Gelderen (gelderen@cryptix.org)
 */
public class RC2ParameterSpec
implements AlgorithmParameterSpec
{
    private final int    bits;
    private final byte[] iv;


    public RC2ParameterSpec(int effectiveKeyBits) 
    {
        this.bits = effectiveKeyBits;
        this.iv   = null;
    }


    public RC2ParameterSpec(int effectiveKeyBits, byte[] iv) 
    {
        this.bits = effectiveKeyBits;
        this.iv   = iv;
    }


    public RC2ParameterSpec(int effectiveKeyBits, byte[] iv, int offset) 
    {
        this.bits = effectiveKeyBits;
        this.iv = new byte[8];
        System.arraycopy(iv, offset, this.iv, 0, this.iv.length);
    }


    public int getEffectiveKeyBits() 
    {
        return this.bits;
    }


    public byte[] getIV() 
    {
        return (byte[])this.iv.clone();
    }
}
