/* $Id: Precomputed.java,v 1.1 2000/02/09 21:37:45 gelderen Exp $
 *
 * Copyright (C) 2000 The Cryptix Foundation Limited.
 * All rights reserved.
 * 
 * Use, modification, copying and distribution of this software is subject 
 * the terms and conditions of the Cryptix General Licence. You should have 
 * received a copy of the Cryptix General Licence along with this library; 
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce.util;


import java.math.BigInteger;


/**
 * @version $Revision: 1.1 $
 * @author  Jeroen C. van Gelderen (gelderen@cryptix.org)
 */
public final class Precomputed
{
    /**
     * Precomputed strong groups.
     *
     * P_00768: OAKLEY Well-Known Group 1, a 768 bit prime.
     * P_01024: OAKLEY Well-Known Group 2, a 1024 bit prime.
     * P_01536: OAKLEY Well-Known Group 5, a 1536 bit prime.
     *
     * See: RFC 2412
     */
    private static final Group
        OAKLEY_0768 = new Group(
            new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B" +  
                           "80DC1CD129024E088A67CC74020BBEA63B139B22514A087" +
                           "98E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE135" +
                           "6D6D51C245E485B576625E7EC6F44C42E9A63A3620FFFFF" +
                           "FFFFFFFFFFF", 16),
            new BigInteger("7FFFFFFFFFFFFFFFE487ED5110B4611A62633145" +
                           "C06E0E68948127044533E63A0105DF531D89CD9128A5043" +
                           "CC71A026EF7CA8CD9E69D218D98158536F92F8A1BA7F09A" +
                           "B6B6A8E122F242DABB312F3F637A262174D31D1B107FFFF" + 
                           "FFFFFFFFFFF", 16),
            new BigInteger("2", 16) ),
            
        OAKLEY_1024 = new Group(
            new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B" +
                          "80DC1CD129024E088A67CC74020BBEA63B139B22514A0879" +
                          "8E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D" +
                          "6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6" +
                          "F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651" +
                          "ECE65381FFFFFFFFFFFFFFFF", 16),
            new BigInteger("7FFFFFFFFFFFFFFFE487ED5110B4611A62633145" +
                          "C06E0E68948127044533E63A0105DF531D89CD9128A5043C" +
                          "C71A026EF7CA8CD9E69D218D98158536F92F8A1BA7F09AB6" +
                          "B6A8E122F242DABB312F3F637A262174D31BF6B585FFAE5B" +
                          "7A035BF6F71C35FDAD44CFD2D74F9208BE258FF324943328" +
                          "F67329C0FFFFFFFFFFFFFFFF", 16),
            new BigInteger("2", 16) ),
            
        OAKLEY_1536 = new Group(
            new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B" + 
                          "80DC1CD129024E088A67CC74020BBEA63B139B22514A0879" +
                          "8E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D" +
                          "6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6" +
                          "F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651" +
                          "ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8" +
                          "FD24CF5F83655D23DCA3AD961C62F356208552BB9ED52907" +
                          "7096966D670C354E4ABC9804F1746C08CA237327FFFFFFFF" +
                          "FFFFFFFF", 16),
            new BigInteger("7FFFFFFFFFFFFFFFE487ED5110B4611A62633145" +
                          "C06E0E68948127044533E63A0105DF531D89CD9128A5043C" +
                          "C71A026EF7CA8CD9E69D218D98158536F92F8A1BA7F09AB6" +
                          "B6A8E122F242DABB312F3F637A262174D31BF6B585FFAE5B" +
                          "7A035BF6F71C35FDAD44CFD2D74F9208BE258FF324943328" +
                          "F6722D9EE1003E5C50B1DF82CC6D241B0E2AE9CD348B1FD4" +
                          "7E9267AFC1B2AE91EE51D6CB0E3179AB1042A95DCF6A9483" +
                          "B84B4B36B3861AA7255E4C0278BA36046511B993FFFFFFFF" +
                          "FFFFFFFF", 16),
            new BigInteger("2", 16) );
        
        
    public static Group getElGamalGroup(int keysize)
    {
        return getStrongGroup(keysize);
    }
    
    
    public static Group getStrongGroup(int keysize)
    {
        switch(keysize)
        {
        case 768:
            return OAKLEY_0768;
        case 1024:
            return OAKLEY_1024;
        case 1536:
            return OAKLEY_1536;
        default:
            return null; // we don't have any
        }
    }
}