/* $Id: ASNSequence.java,v 1.2 2000/01/20 14:59:38 gelderen Exp $
 *
 * Copyright (C) 2000 The Cryptix Foundation Limited.
 * All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce.util.der;


import java.io.IOException;
import java.io.OutputStream;


/**
 * @version $Revision: 1.2 $
 * @author  Jeroen C. van Gelderen (gelderen@cryptix.org)
 */
public final class ASNSequence
extends ASNObject
{
    
// Instance variables
//...........................................................................

    private final ASNObject[] components;


// Constructors
//...........................................................................

    public ASNSequence(ASNObject[] components)
    {
        this.components = (ASNObject[])components.clone();
    }


// Concreteness
//...........................................................................

    /*package*/ void write(DEROutputStream dos) throws IOException
    {
        dos.writeType(SEQUENCE);
        dos.writeLength(getLengthOfComponents());
        
        for(int i=0; i<this.components.length; i++)
            dos.write( this.components[i] );
    }


    /*package*/ int getEncodedLength()
    {
        return getLengthOfComponents() + 1; // len of components + len of type
    }
    
    
// Private helper methods
//...........................................................................

    private int getLengthOfComponents()
    {
        int totalLen = 0;
        for(int i=0; i<this.components.length; i++)
            totalLen += components[i].getEncodedLength();

        return totalLen;
    }
}
