/* $Id: ASNObjectIdentifier.java,v 1.2 2000/01/20 14:59:38 gelderen Exp $
 *
 * Copyright (C) 2000 The Cryptix Foundation Limited.
 * All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce.util.der;


import java.io.IOException;
import java.io.OutputStream;


/**
 * @version $Revision: 1.2 $
 * @author  Jeroen C. van Gelderen (gelderen@cryptix.org)
 */
public final class ASNObjectIdentifier
extends ASNObject
{

// Constants
//...........................................................................

    /* RSA AlgorithmIdentifier: 1.2.840.113549.1.1.1 */
    private static final byte[] RSA_BYTES = {
        // algorithm
        (byte)0x30, (byte)0x0D,
        
        // rsaEncryption (OID)
        (byte)0x06, (byte)0x09, (byte)0x2A, (byte)0x86,
        (byte)0x48, (byte)0x86, (byte)0xF7, (byte)0x0D,
        (byte)0x01, (byte)0x01, (byte)0x01,

        // null
        (byte)0x05, (byte)0x00
    };     


    public static final ASNObjectIdentifier
        RSA = new ASNObjectIdentifier(RSA_BYTES);


// Instance variables
//...........................................................................

    private final byte[] bytes;   


// Constructor
//...........................................................................

    private ASNObjectIdentifier(byte[] oid)
    {
        // clone because we're immutable
        this.bytes = (byte[])oid.clone();
    }
    

// Concreteness
//...........................................................................

    /*package*/ void write(DEROutputStream os)
    throws IOException
    {
        os.writeBytes(this.bytes);
    }


    /*package*/ int getEncodedLength()
    {
        return bytes.length;
    }
}
