/* $Id: ASNObject.java,v 1.2 2000/01/20 14:59:38 gelderen Exp $
 *
 * Copyright (C) 2000 The Cryptix Foundation Limited.
 * All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce.util.der;


import java.io.IOException;
import java.io.OutputStream;


/**
 * Abstract ASNObject that knows how to read and write itself. Is immutable.
 * 
 * @version $Revision: 1.2 $
 * @author  Jeroen C. van Gelderen (gelderen@cryptix.org)
 */
public abstract class ASNObject
{
    
// Constants
//...........................................................................

    protected static final byte
        CONSTRUCTED  = 0x20;
        
    protected static final byte
        INTEGER      = 0x02,
        BIT_STRING   = 0x03,
        OCTET_STRING = 0x04,
        SEQUENCE     = (0x10 | CONSTRUCTED);


//...........................................................................

    static int getLengthOfEncodedLength(int len)
    {
        if(len<0)
            throw new RuntimeException("PANIC");
            
        else if(len <= 0x7F)
            return 1;
        else if(len <= 0xFFFF)
            return 3;
        else if(len <= 0xFFFFFF)
            return 4;
        else
            return 5;
    }


// Abstract methods
//...........................................................................

    /*package*/ abstract void write(DEROutputStream os) throws IOException;
    
    
    /*package*/ abstract int getEncodedLength();
}
